/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.client.event.ClientChatEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.montoyo.wd.SharedProxy;
import net.montoyo.wd.client.ClientProxy;
import net.montoyo.wd.client.gui.camera.KeyboardCamera;
import net.montoyo.wd.config.ClientConfig;
import net.montoyo.wd.config.CommonConfig;
import net.montoyo.wd.controls.ScreenControlRegistry;
import net.montoyo.wd.core.CraftComponent;
import net.montoyo.wd.core.Criterion;
import net.montoyo.wd.core.HasAdvancement;
import net.montoyo.wd.core.IWDDCapability;
import net.montoyo.wd.core.WDDCapability;
import net.montoyo.wd.miniserv.server.Server;
import net.montoyo.wd.net.WDNetworkRegistry;
import net.montoyo.wd.net.client_bound.S2CMessageServerInfo;
import net.montoyo.wd.registry.BlockRegistry;
import net.montoyo.wd.registry.ItemRegistry;
import net.montoyo.wd.registry.TileRegistry;
import net.montoyo.wd.registry.WDTabs;
import net.montoyo.wd.utilities.DistSafety;
import net.montoyo.wd.utilities.Log;
import net.montoyo.wd.utilities.serialization.Util;

@Mod(value="webdisplays")
public class WebDisplays {
    public static WebDisplays INSTANCE;
    public static SharedProxy PROXY;
    public static final ResourceLocation ADV_PAD_BREAK;
    public static final String BLACKLIST_URL = "mod://webdisplays/blacklisted.html";
    public static final Gson GSON;
    public static final ResourceLocation CAPABILITY;
    public SoundEvent soundTyping;
    public SoundEvent soundUpgradeAdd;
    public SoundEvent soundUpgradeDel;
    public SoundEvent soundScreenCfg;
    public SoundEvent soundServer;
    public SoundEvent soundIronic;
    public Criterion criterionPadBreak;
    public Criterion criterionUpgradeScreen;
    public Criterion criterionLinkPeripheral;
    public Criterion criterionKeyboardCat;
    public static final double PAD_RATIO = 1.9666666666666666;
    public double padResX;
    public double padResY;
    private int lastPadId = 0;
    public double unloadDistance2;
    public double loadDistance2;
    public int miniservPort;
    public long miniservQuota;
    public float ytVolume;
    public float avDist100;
    public float avDist0;
    private boolean hasOC;
    private boolean hasCC;
    ArrayList<ResourceKey<Level>> serverStartedDimensions = new ArrayList();
    public static DeferredRegister<SoundEvent> SOUNDS;

    public WebDisplays() {
        INSTANCE = this;
        PROXY = FMLEnvironment.dist.isClient() ? DistSafety.createProxy() : new SharedProxy();
        if (FMLEnvironment.dist.isClient()) {
            FMLJavaModLoadingContext.get().getModEventBus().addListener(ClientProxy::onKeybindRegistry);
            MinecraftForge.EVENT_BUS.addListener(ClientProxy::onDrawSelection);
            MinecraftForge.EVENT_BUS.addListener(KeyboardCamera::updateCamera);
            MinecraftForge.EVENT_BUS.addListener(KeyboardCamera::gameTick);
            ClientConfig.init();
        }
        CommonConfig.init();
        this.criterionPadBreak = new Criterion("pad_break");
        this.criterionUpgradeScreen = new Criterion("upgrade_screen");
        this.criterionLinkPeripheral = new Criterion("link_peripheral");
        this.criterionKeyboardCat = new Criterion("keyboard_cat");
        WebDisplays.registerTrigger(this.criterionPadBreak, this.criterionUpgradeScreen, this.criterionLinkPeripheral, this.criterionKeyboardCat);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        WDNetworkRegistry.init();
        SOUNDS.register(bus);
        this.onRegisterSounds();
        WDTabs.init(bus);
        BlockRegistry.init(bus);
        ItemRegistry.init(bus);
        TileRegistry.init(bus);
        PROXY.preInit();
        MinecraftForge.EVENT_BUS.register((Object)this);
        PROXY.init();
        PROXY.postInit();
        this.hasOC = ModList.get().isLoaded("opencomputers");
        this.hasCC = ModList.get().isLoaded("computercraft");
        if (!FMLEnvironment.production) {
            ScreenControlRegistry.init();
        }
    }

    @SubscribeEvent
    public static void onAttachPlayerCap(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player && !((Entity)event.getObject()).getCapability(WDDCapability.Provider.cap).isPresent()) {
            event.addCapability(new ResourceLocation("webdisplays", "wddcapability"), (ICapabilityProvider)new WDDCapability.Provider());
        }
    }

    public void onRegisterSounds() {
        this.soundTyping = WebDisplays.registerSound("keyboard_type");
        this.soundUpgradeAdd = WebDisplays.registerSound("upgrade_add");
        this.soundUpgradeDel = WebDisplays.registerSound("upgrade_del");
        this.soundScreenCfg = WebDisplays.registerSound("screencfg_open");
        this.soundServer = WebDisplays.registerSound("server");
        this.soundIronic = WebDisplays.registerSound("ironic");
    }

    @SubscribeEvent
    public void onWorldLoad(LevelEvent.Load ev) {
        LevelAccessor levelAccessor = ev.getLevel();
        if (levelAccessor instanceof Level) {
            Level level = (Level)levelAccessor;
            if (ev.getLevel().m_5776_() || level.m_46472_() != Level.f_46428_) {
                return;
            }
            File worldDir = Objects.requireNonNull(ev.getLevel().m_7654_()).m_6237_();
            File f = new File(worldDir, "wd_next.txt");
            if (f.exists()) {
                try {
                    BufferedReader br = new BufferedReader(new FileReader(f));
                    String idx = br.readLine();
                    Util.silentClose(br);
                    if (idx == null) {
                        throw new RuntimeException("Seems like the file is empty (1)");
                    }
                    if ((idx = idx.trim()).isEmpty()) {
                        throw new RuntimeException("Seems like the file is empty (2)");
                    }
                    this.lastPadId = Integer.parseInt(idx);
                }
                catch (Throwable t) {
                    Log.warningEx("Could not read last minePad ID from %s. I'm afraid this might break all minePads.", t, f.getAbsolutePath());
                }
            }
            if (this.miniservPort != 0) {
                Server sv = Server.getInstance();
                if (!this.serverStartedDimensions.contains(level.m_46472_())) {
                    sv.setPort(this.miniservPort);
                    sv.setDirectory(new File(worldDir, "wd_filehost"));
                    sv.start();
                    this.serverStartedDimensions.add((ResourceKey<Level>)level.m_46472_());
                }
            }
        }
    }

    @SubscribeEvent
    public void onWorldLeave(LevelEvent.Unload ev) throws IOException {
        LevelAccessor levelAccessor = ev.getLevel();
        if (levelAccessor instanceof Level) {
            Level level = (Level)levelAccessor;
            if (ev.getLevel().m_5776_() || level.m_46472_() != Level.f_46428_) {
                return;
            }
            Server sw = Server.getInstance();
            sw.stopServer();
            this.serverStartedDimensions.remove(level.m_46472_());
        }
    }

    @SubscribeEvent
    public void onWorldSave(LevelEvent.Save ev) {
        LevelAccessor levelAccessor = ev.getLevel();
        if (levelAccessor instanceof Level) {
            Level level = (Level)levelAccessor;
            if (ev.getLevel().m_5776_() || level.m_46472_() != Level.f_46428_) {
                return;
            }
            File f = new File(Objects.requireNonNull(ev.getLevel().m_7654_()).m_6237_(), "wd_next.txt");
            try {
                BufferedWriter bw = new BufferedWriter(new FileWriter(f));
                bw.write(this.lastPadId + "\n");
                Util.silentClose(bw);
            }
            catch (Throwable t) {
                Log.warningEx("Could not save last minePad ID (%d) to %s. I'm afraid this might break all minePads.", t, this.lastPadId, f.getAbsolutePath());
            }
        }
    }

    @SubscribeEvent
    public void onToss(ItemTossEvent ev) {
        ItemStack is;
        if (!ev.getEntity().m_9236_().f_46443_ && (is = ev.getEntity().m_32055_()).m_41720_() == ItemRegistry.MINEPAD.get()) {
            CompoundTag tag = is.m_41783_();
            if (tag == null) {
                tag = new CompoundTag();
                is.m_41751_(tag);
            }
            UUID thrower = ev.getPlayer().m_36316_().getId();
            tag.m_128356_("ThrowerMSB", thrower.getMostSignificantBits());
            tag.m_128356_("ThrowerLSB", thrower.getLeastSignificantBits());
            tag.m_128347_("ThrowHeight", ev.getPlayer().m_20186_() + (double)ev.getPlayer().m_20192_());
        }
    }

    @SubscribeEvent
    public void onPlayerCraft(PlayerEvent.ItemCraftedEvent ev) {
        if (CommonConfig.hardRecipes && ItemRegistry.isCompCraftItem(ev.getCrafting().m_41720_()) && CraftComponent.EXTCARD.makeItemStack().m_150930_(ev.getCrafting().m_41720_()) && (ev.getEntity() instanceof ServerPlayer && !this.hasPlayerAdvancement((ServerPlayer)ev.getEntity(), ADV_PAD_BREAK) || PROXY.hasClientPlayerAdvancement(ADV_PAD_BREAK) != HasAdvancement.YES)) {
            ev.getCrafting().m_41721_(CraftComponent.BADEXTCARD.ordinal());
            if (!ev.getEntity().m_9236_().f_46443_) {
                ev.getEntity().m_9236_().m_6263_(null, ev.getEntity().m_20185_(), ev.getEntity().m_20186_(), ev.getEntity().m_20189_(), SoundEvents.f_12018_, SoundSource.MASTER, 1.0f, 1.0f);
            }
        }
    }

    @SubscribeEvent
    public static void onServerStop(ServerStoppingEvent ev) throws IOException {
        Server.getInstance().stopServer();
    }

    @SubscribeEvent
    public void onLogIn(PlayerEvent.PlayerLoggedInEvent ev) {
        if (!CommonConfig.joinMessage) {
            return;
        }
        if (!ev.getEntity().m_9236_().f_46443_ && ev.getEntity() instanceof ServerPlayer) {
            IWDDCapability cap = (IWDDCapability)ev.getEntity().getCapability(WDDCapability.Provider.cap, null).orElseThrow(RuntimeException::new);
            if (cap.isFirstRun()) {
                Util.toast(ev.getEntity(), ChatFormatting.LIGHT_PURPLE, "welcome1", new Object[0]);
                Util.toast(ev.getEntity(), ChatFormatting.LIGHT_PURPLE, "welcome2", new Object[0]);
                Util.toast(ev.getEntity(), ChatFormatting.LIGHT_PURPLE, "welcome3", new Object[0]);
                cap.clearFirstRun();
            }
            PacketDistributor.PacketTarget packetDistrutor = PacketDistributor.PLAYER.with(() -> (ServerPlayer)ev.getEntity());
            S2CMessageServerInfo message = new S2CMessageServerInfo(this.miniservPort);
            WDNetworkRegistry.INSTANCE.send(packetDistrutor, (Object)message);
        }
    }

    @SubscribeEvent
    public void onLogOut(PlayerEvent.PlayerLoggedOutEvent ev) {
        if (!ev.getEntity().m_9236_().f_46443_) {
            Server.getInstance().getClientManager().revokeClientKey(ev.getEntity().m_36316_().getId());
        }
    }

    @SubscribeEvent
    public void attachEntityCaps(AttachCapabilitiesEvent<Entity> ev) {
        if (ev.getObject() instanceof Player) {
            ev.addCapability(CAPABILITY, (ICapabilityProvider)new WDDCapability.Provider());
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone ev) {
        IWDDCapability src = (IWDDCapability)ev.getOriginal().getCapability(WDDCapability.Provider.cap, null).orElse((Object)new WDDCapability.Factory().call());
        IWDDCapability dst = (IWDDCapability)ev.getEntity().getCapability(WDDCapability.Provider.cap, null).orElse((Object)new WDDCapability.Factory().call());
        if (src == null) {
            Log.error("src is null", new Object[0]);
            return;
        }
        if (dst == null) {
            Log.error("dst is null", new Object[0]);
            return;
        }
        src.cloneTo(dst);
    }

    @SubscribeEvent
    public void onServerChat(ServerChatEvent ev) {
        String msg = ev.getMessage().getString().replaceAll("\\s+", " ").toLowerCase();
        StringBuilder sb = new StringBuilder(msg.length());
        for (int i = 0; i < msg.length(); ++i) {
            char chr = msg.charAt(i);
            if (chr == '.' || chr == ',' || chr == ';' || chr == '!' || chr == '?' || chr == ':' || chr == '\'' || chr == '\"' || chr == '`') continue;
            sb.append(chr);
        }
        if (sb.toString().equals("ironic he could save others from death but not himself")) {
            ServerPlayer ply = ev.getPlayer();
            ply.m_9236_().m_6263_(null, ply.m_20185_(), ply.m_20186_(), ply.m_20189_(), this.soundIronic, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    @SubscribeEvent
    public void onClientChat(ClientChatEvent ev) {
        if (ev.getMessage().equals("!WD render recipes")) {
            PROXY.renderRecipes();
        }
    }

    private boolean hasPlayerAdvancement(ServerPlayer ply, ResourceLocation rl) {
        MinecraftServer server = PROXY.getServer();
        if (server == null) {
            return false;
        }
        Advancement adv = server.m_129889_().m_136041_(rl);
        return adv != null && ply.m_8960_().m_135996_(adv).m_8193_();
    }

    public static int getNextAvailablePadID() {
        return new WebDisplays().lastPadId++;
    }

    private static SoundEvent registerSound(String resName) {
        ResourceLocation resLoc = new ResourceLocation("webdisplays", resName);
        SoundEvent ret = SoundEvent.m_262824_((ResourceLocation)resLoc);
        SOUNDS.register(resName, () -> ret);
        return ret;
    }

    private static void registerTrigger(Criterion ... criteria) {
        for (Criterion c : criteria) {
            CriteriaTriggers.m_10595_((CriterionTrigger)c);
        }
    }

    public static boolean isSiteBlacklisted(String url) {
        try {
            URL url2 = new URL(Util.addProtocol(url));
            for (String str : CommonConfig.Browser.blacklist) {
                if (!str.equalsIgnoreCase(url2.getHost())) continue;
                return true;
            }
            return false;
        }
        catch (MalformedURLException ex) {
            return false;
        }
    }

    public static String applyBlacklist(String url) {
        return WebDisplays.isSiteBlacklisted(url) ? BLACKLIST_URL : url;
    }

    static {
        PROXY = null;
        ADV_PAD_BREAK = new ResourceLocation("webdisplays", "webdisplays/pad_break");
        GSON = new Gson();
        CAPABILITY = new ResourceLocation("webdisplays", "customdatacap");
        SOUNDS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"webdisplays");
    }
}

