/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.client.gui;

import com.cinemamod.mcef.MCEFBrowser;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.montoyo.wd.WebDisplays;
import net.montoyo.wd.client.ClientProxy;
import net.montoyo.wd.client.gui.WDScreen;
import net.montoyo.wd.utilities.browser.WDBrowser;
import net.montoyo.wd.utilities.browser.handlers.js.Scripts;
import net.montoyo.wd.utilities.data.BlockSide;
import org.cef.browser.CefBrowser;
import org.cef.misc.CefCursorType;
import org.lwjgl.glfw.GLFW;

@OnlyIn(value=Dist.CLIENT)
public class GuiMinePad
extends WDScreen {
    private ClientProxy.PadData pad;
    private double vx;
    private double vy;
    private double vw;
    private double vh;
    int trueWidth;
    int trueHeight;
    boolean locked = false;
    double lockCenterX = -1.0;
    double lockCenterY = -1.0;

    public GuiMinePad() {
        super(Component.m_130674_(null));
    }

    public GuiMinePad(ClientProxy.PadData pad) {
        this();
        this.pad = pad;
    }

    @Override
    public void m_7856_() {
        this.vw = (double)this.f_96543_ - 32.0;
        this.vh = this.vw / 1.9666666666666666;
        this.vx = 16.0;
        this.vy = ((double)this.f_96544_ - this.vh) / 2.0;
        this.trueWidth = this.f_96543_;
        this.trueHeight = this.f_96544_;
        this.f_96543_ = (int)this.vw;
        this.f_96544_ = (int)this.vh;
        super.m_7856_();
        ((MCEFBrowser)this.pad.view).setCursor(CefCursorType.fromId((int)this.pad.activeCursor));
        ((MCEFBrowser)this.pad.view).setCursorChangeListener(id -> {
            this.pad.activeCursor = id;
            ((MCEFBrowser)this.pad.view).setCursor(CefCursorType.fromId((int)id));
        });
    }

    private static void addRect(BufferBuilder bb, double x, double y, double w, double h) {
        bb.m_5483_(x, y, 0.0).m_6122_(255, 255, 255, 255).m_5752_();
        bb.m_5483_(x + w, y, 0.0).m_6122_(255, 255, 255, 255).m_5752_();
        bb.m_5483_(x + w, y + h, 0.0).m_6122_(255, 255, 255, 255).m_5752_();
        bb.m_5483_(x, y + h, 0.0).m_6122_(255, 255, 255, 255).m_5752_();
    }

    @Override
    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float ptt) {
        this.f_96543_ = this.trueWidth;
        this.f_96544_ = this.trueHeight;
        this.m_280273_(graphics);
        this.f_96543_ = (int)this.vw;
        this.f_96544_ = (int)this.vh;
        RenderSystem.disableCull();
        RenderSystem.setShaderColor((float)0.73f, (float)0.73f, (float)0.73f, (float)1.0f);
        Tesselator t = Tesselator.m_85913_();
        BufferBuilder bb = t.m_85915_();
        bb.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        GuiMinePad.addRect(bb, this.vx, this.vy - 16.0, this.vw, 16.0);
        GuiMinePad.addRect(bb, this.vx, this.vy + this.vh, this.vw, 16.0);
        GuiMinePad.addRect(bb, this.vx - 16.0, this.vy, 16.0, this.vh);
        GuiMinePad.addRect(bb, this.vx + this.vw, this.vy, 16.0, this.vh);
        t.m_85914_();
        if (this.pad.view != null) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableDepthTest();
            RenderSystem.setShader(GameRenderer::m_172820_);
            RenderSystem.setShaderTexture((int)0, (int)((MCEFBrowser)this.pad.view).getRenderer().getTextureID());
            t = Tesselator.m_85913_();
            BufferBuilder buffer = t.m_85915_();
            buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
            double x1 = this.vx;
            double y1 = this.vy;
            double x2 = this.vx + this.vw;
            double y2 = this.vy + this.vh;
            buffer.m_252986_(graphics.m_280168_().m_85850_().m_252922_(), (float)x1, (float)y1, 0.0f).m_7421_(0.0f, 0.0f).m_6122_(255, 255, 255, 255).m_5752_();
            buffer.m_252986_(graphics.m_280168_().m_85850_().m_252922_(), (float)x2, (float)y1, 0.0f).m_7421_(1.0f, 0.0f).m_6122_(255, 255, 255, 255).m_5752_();
            buffer.m_252986_(graphics.m_280168_().m_85850_().m_252922_(), (float)x2, (float)y2, 0.0f).m_7421_(1.0f, 1.0f).m_6122_(255, 255, 255, 255).m_5752_();
            buffer.m_252986_(graphics.m_280168_().m_85850_().m_252922_(), (float)x1, (float)y2, 0.0f).m_7421_(0.0f, 1.0f).m_6122_(255, 255, 255, 255).m_5752_();
            t.m_85914_();
            RenderSystem.enableDepthTest();
        }
        RenderSystem.enableCull();
        Font font = this.f_96541_.f_91062_;
        String string = Language.m_128107_().m_6834_("webdisplays.gui.minepad.close");
        int n = (int)this.vx + 4;
        int n2 = (int)this.vy;
        Objects.requireNonNull(this.f_96541_.f_91062_);
        graphics.m_280056_(font, string, n, n2 - 9 - 3, 0xFFFFFF, true);
    }

    @Override
    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        return this.keyChanged(keyCode, scanCode, modifiers, true) || super.m_7933_(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        return this.keyChanged(keyCode, scanCode, modifiers, false) || super.m_7920_(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean m_5534_(char codePoint, int modifiers) {
        if (this.pad.view != null) {
            ((MCEFBrowser)this.pad.view).sendKeyTyped(codePoint, modifiers);
            return true;
        }
        return super.m_5534_(codePoint, modifiers);
    }

    public boolean keyChanged(int keyCode, int scanCode, int modifiers, boolean pressed) {
        assert (this.f_96541_ != null);
        if ((modifiers & 1) == 1 && keyCode == 256) {
            this.m_7379_();
            return true;
        }
        InputConstants.Key iuKey = InputConstants.m_84827_((int)keyCode, (int)scanCode);
        String keystr = iuKey.m_84875_().getString();
        if (keystr.length() == 0) {
            return false;
        }
        int key = keystr.charAt(keystr.length() - 1);
        if (keystr.equals("Enter")) {
            keyCode = 10;
            key = 10;
        }
        if (this.pad.view != null) {
            if (pressed) {
                ((MCEFBrowser)this.pad.view).sendKeyPress(keyCode, (long)scanCode, modifiers);
            } else {
                ((MCEFBrowser)this.pad.view).sendKeyRelease(keyCode, (long)scanCode, modifiers);
            }
            if (pressed && key == 10 && modifiers != 0) {
                ((MCEFBrowser)this.pad.view).sendKeyTyped('\r', modifiers);
            }
            return true;
        }
        return false;
    }

    @Override
    public void m_94757_(double mouseX, double mouseY) {
        super.m_94757_(mouseX, mouseY);
        this.mouse(-1, false, (int)mouseX, (int)mouseY, 0.0);
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        this.mouse(button, true, (int)mouseX, (int)mouseY, 0.0);
        return super.m_6375_(mouseX, mouseY, button);
    }

    @Override
    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.mouse(button, false, (int)mouseX, (int)mouseY, 0.0);
        return super.m_6348_(mouseX, mouseY, button);
    }

    @Override
    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        double mx = (mouseX - this.vx) / this.vw;
        double my = (mouseY - this.vy) / this.vh;
        int sx = (int)(mx * WebDisplays.INSTANCE.padResX);
        int sy = (int)(my * WebDisplays.INSTANCE.padResY);
        ((MCEFBrowser)this.pad.view).sendMouseWheel(sx, sy, amount, GuiMinePad.m_96637_() && !GuiMinePad.m_96639_() && !GuiMinePad.m_96638_() ? 2 : 0);
        return super.m_6050_(mouseX, mouseY, amount);
    }

    public void capturedMouse(double scaledX, double scaledY, int sx, int sy) {
        double centerX = (int)(0.5 * (double)this.f_96541_.m_91268_().m_85445_());
        double centerY = (int)(0.5 * (double)this.f_96541_.m_91268_().m_85446_());
        if (sx == (int)centerX && sy == (int)centerY) {
            return;
        }
        double mx = (centerX - this.vx) / this.vw;
        double my = (centerY - this.vy) / this.vh;
        double scaledCentX = mx * WebDisplays.INSTANCE.padResX;
        double scaledCentY = my * WebDisplays.INSTANCE.padResY;
        double deltX = scaledX - scaledCentX;
        double deltY = scaledY - scaledCentY;
        String scr = Scripts.MOUSE_EVENT;
        this.pad.view.executeJavaScript(scr.replace("%xCoord%", "" + (int)centerX).replace("%yCoord%", "" + (int)centerY).replace("%xDelta%", "" + deltX).replace("%yDelta%", "" + deltY), "WebDisplays", 0);
        try {
            double xpos = this.f_96541_.m_91268_().m_85443_() / 2;
            double ypos = this.f_96541_.m_91268_().m_85444_() / 2;
            GLFW.glfwSetCursorPos((long)this.f_96541_.m_91268_().m_85439_(), (double)xpos, (double)ypos);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void mouse(int btn, boolean pressed, int sx, int sy, double scrollAmount) {
        double mx = ((double)sx - this.vx) / this.vw;
        double my = ((double)sy - this.vy) / this.vh;
        if (this.pad.view != null && mx >= 0.0 && mx <= 1.0) {
            int scaledX = (int)(mx * WebDisplays.INSTANCE.padResX);
            int scaledY = (int)(my * WebDisplays.INSTANCE.padResY);
            if (btn == -1) {
                if (this.locked) {
                    this.capturedMouse(mx * WebDisplays.INSTANCE.padResX, my * WebDisplays.INSTANCE.padResY, sx, sy);
                } else {
                    ((MCEFBrowser)this.pad.view).sendMouseMove(scaledX, scaledY);
                }
            } else if (pressed) {
                ((MCEFBrowser)this.pad.view).sendMousePress(scaledX, scaledY, btn);
            } else {
                ((MCEFBrowser)this.pad.view).sendMouseRelease(scaledX, scaledY, btn);
            }
            this.pad.view.setFocus(true);
        }
    }

    public static Optional<Character> getChar(int keyCode, int scanCode) {
        String keystr = GLFW.glfwGetKeyName((int)keyCode, (int)scanCode);
        if (keystr == null) {
            keystr = "\u0000";
        }
        if (keyCode == 257) {
            keystr = "\n";
        }
        if (keystr.length() == 0) {
            return Optional.empty();
        }
        return Optional.of(Character.valueOf(keystr.charAt(keystr.length() - 1)));
    }

    @Override
    public void m_86600_() {
        if (this.pad.view == null) {
            this.f_96541_.m_91152_(null);
        }
        this.pollElement();
    }

    @Override
    public boolean isForBlock(BlockPos bp, BlockSide side) {
        return false;
    }

    public void m_7861_() {
        super.m_7861_();
        InputConstants.m_84848_((long)this.f_96541_.m_91268_().m_85439_(), (boolean)((Boolean)Minecraft.m_91087_().f_91066_.m_232123_().m_231551_()));
        CefBrowser cefBrowser = this.pad.view;
        if (cefBrowser instanceof MCEFBrowser) {
            MCEFBrowser browser = (MCEFBrowser)cefBrowser;
            browser.setCursor(CefCursorType.POINTER);
            browser.setCursorChangeListener(cursor -> {
                this.pad.activeCursor = cursor;
            });
        }
    }

    @Override
    public void m_7379_() {
        super.m_7379_();
        this.m_7861_();
        this.f_96541_.popGuiLayer();
    }

    protected void updateCrd(JsonObject obj) {
        if (obj.getAsJsonPrimitive("exists").getAsBoolean()) {
            this.locked = true;
            RenderSystem.recordRenderCall(() -> {
                InputConstants.m_84848_((long)this.f_96541_.m_91268_().m_85439_(), (boolean)obj.getAsJsonPrimitive("unadjust").getAsBoolean());
                GLFW.glfwSetInputMode((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)208897, (int)212995);
            });
            this.lockCenterX = obj.getAsJsonPrimitive("x").getAsDouble() + obj.getAsJsonPrimitive("w").getAsDouble() / 2.0;
            this.lockCenterY = obj.getAsJsonPrimitive("y").getAsDouble() + obj.getAsJsonPrimitive("h").getAsDouble() / 2.0;
        } else if (this.locked) {
            this.locked = false;
            RenderSystem.recordRenderCall(() -> {
                InputConstants.m_84848_((long)this.f_96541_.m_91268_().m_85439_(), (boolean)((Boolean)Minecraft.m_91087_().f_91066_.m_232123_().m_231551_()));
                GLFW.glfwSetInputMode((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)208897, (int)212993);
                GLFW.glfwSetCursor((long)Minecraft.m_91087_().m_91268_().m_85439_(), (long)CefCursorType.fromId((int)this.pad.activeCursor).glfwId);
            });
        }
    }

    protected void pollElement() {
        WDBrowser browser;
        JsonObject object;
        CefBrowser cefBrowser = this.pad.view;
        if (cefBrowser instanceof WDBrowser && (object = (browser = (WDBrowser)cefBrowser).pointerLockElement().getObj()) != null) {
            this.updateCrd(object);
        }
    }
}

