/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.client.renderers;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.montoyo.wd.client.ClientProxy;
import net.montoyo.wd.client.renderers.IItemRenderer;
import net.montoyo.wd.item.ItemLaserPointer;
import net.montoyo.wd.registry.ItemRegistry;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public final class LaserPointerRenderer
implements IItemRenderer {
    private final Tesselator t = Tesselator.m_85913_();
    private final BufferBuilder bb = this.t.m_85915_();

    public static boolean isOn() {
        if (Minecraft.m_91087_().f_91080_ != null) {
            return false;
        }
        Minecraft mc = Minecraft.m_91087_();
        return !(mc.f_91074_ == null || mc.f_91073_ == null || !ClientProxy.mouseOn && !ItemLaserPointer.isOn() || !mc.f_91074_.m_21120_(InteractionHand.MAIN_HAND).m_41720_().equals(ItemRegistry.LASER_POINTER.get()) || mc.f_91077_ != null && mc.f_91077_.m_6662_() != HitResult.Type.BLOCK && mc.f_91077_.m_6662_() != HitResult.Type.MISS);
    }

    @Override
    public boolean render(PoseStack poseStack, ItemStack is, float handSideSign, float swingProgress, float equipProgress, MultiBufferSource multiBufferSource, int packedLight) {
        RenderSystem.disableCull();
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        float PI = (float)Math.PI;
        float sqrtSwingProg = (float)Math.sqrt(swingProgress);
        float sinSqrtSwingProg1 = (float)Math.sin(sqrtSwingProg * PI);
        RenderSystem.setShader(GameRenderer::m_172811_);
        Matrix4f matrix0 = poseStack.m_85850_().m_252922_();
        poseStack.m_85836_();
        poseStack.m_252880_(handSideSign * -0.4f * sinSqrtSwingProg1, (float)((double)0.2f * Math.sin(sqrtSwingProg * PI * 2.0f)), (float)((double)-0.2f * Math.sin(swingProgress * PI)));
        poseStack.m_252880_(handSideSign * 0.56f, -0.52f - equipProgress * 0.6f, -0.72f);
        poseStack.m_252781_(Axis.f_252436_.m_252977_((float)((double)handSideSign * (45.0 - Math.sin(swingProgress * swingProgress * PI) * 20.0))));
        poseStack.m_252781_(Axis.f_252403_.m_252977_(handSideSign * sinSqrtSwingProg1 * -20.0f));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(sinSqrtSwingProg1 * -80.0f));
        poseStack.m_252781_(Axis.f_252436_.m_252977_(handSideSign * -30.0f));
        poseStack.m_252880_(0.0f, 0.2f, 0.0f);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(10.0f));
        poseStack.m_85841_(0.0625f, 0.0625f, 0.0625f);
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        this.bb.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        this.bb.m_252986_(matrix, 0.0f, 0.0f, 0.0f).m_85950_(0.5f, 0.5f, 0.5f, 1.0f).m_5752_();
        this.bb.m_252986_(matrix, 1.0f, 0.0f, 0.0f).m_85950_(0.5f, 0.5f, 0.5f, 1.0f).m_5752_();
        this.bb.m_252986_(matrix, 1.0f, 0.0f, 4.0f).m_85950_(0.5f, 0.5f, 0.5f, 1.0f).m_5752_();
        this.bb.m_252986_(matrix, 0.0f, 0.0f, 4.0f).m_85950_(0.5f, 0.5f, 0.5f, 1.0f).m_5752_();
        this.bb.m_252986_(matrix, 0.0f, 0.0f, 0.0f).m_85950_(0.5f, 0.5f, 0.5f, 1.0f).m_5752_();
        this.bb.m_252986_(matrix, 0.0f, -1.0f, 0.0f).m_85950_(0.5f, 0.5f, 0.5f, 1.0f).m_5752_();
        this.bb.m_252986_(matrix, 0.0f, -1.0f, 4.0f).m_85950_(0.5f, 0.5f, 0.5f, 1.0f).m_5752_();
        this.bb.m_252986_(matrix, 0.0f, 0.0f, 4.0f).m_85950_(0.5f, 0.5f, 0.5f, 1.0f).m_5752_();
        this.bb.m_252986_(matrix, 1.0f, 0.0f, 0.0f).m_85950_(0.5f, 0.5f, 0.5f, 1.0f).m_5752_();
        this.bb.m_252986_(matrix, 1.0f, -1.0f, 0.0f).m_85950_(0.5f, 0.5f, 0.5f, 1.0f).m_5752_();
        this.bb.m_252986_(matrix, 1.0f, -1.0f, 4.0f).m_85950_(0.5f, 0.5f, 0.5f, 1.0f).m_5752_();
        this.bb.m_252986_(matrix, 1.0f, 0.0f, 4.0f).m_85950_(0.5f, 0.5f, 0.5f, 1.0f).m_5752_();
        this.bb.m_252986_(matrix, 0.0f, -1.0f, 4.0f).m_85950_(0.5f, 0.5f, 0.5f, 1.0f).m_5752_();
        this.bb.m_252986_(matrix, 1.0f, -1.0f, 4.0f).m_85950_(0.5f, 0.5f, 0.5f, 1.0f).m_5752_();
        this.bb.m_252986_(matrix, 1.0f, 0.0f, 4.0f).m_85950_(0.5f, 0.5f, 0.5f, 1.0f).m_5752_();
        this.bb.m_252986_(matrix, 0.0f, 0.0f, 4.0f).m_85950_(0.5f, 0.5f, 0.5f, 1.0f).m_5752_();
        if (LaserPointerRenderer.isOn()) {
            LaserPointerRenderer.drawLineBetween(this.bb, matrix0, matrix, new Vec3(0.5, -0.5, 0.5), new Vec3(-40.0, 4000.5, -100.0));
        }
        this.t.m_85914_();
        RenderSystem.disableBlend();
        RenderSystem.disableDepthTest();
        RenderSystem.enableCull();
        poseStack.m_85849_();
        return true;
    }

    private static void drawLineBetween(BufferBuilder bb, Matrix4f matrix0, Matrix4f matrix, Vec3 local, Vec3 target) {
        float distance = (float)local.m_82554_(target) / 2.0f;
        float quarterWidth = 0.25f;
        float biggerWidth = 10.0f;
        bb.m_252986_(matrix, 0.25f, -0.25f, 0.5f).m_85950_(0.5f, 0.0f, 0.0f, 1.0f).m_5752_();
        bb.m_252986_(matrix, quarterWidth + 0.25f, -0.25f, 0.5f).m_85950_(0.5f, 0.0f, 0.0f, 1.0f).m_5752_();
        bb.m_252986_(matrix0, biggerWidth - 6.0f, 3.0f, -distance).m_85950_(0.5f, 0.0f, 0.0f, 1.0f).m_5752_();
        bb.m_252986_(matrix0, -6.0f, 3.0f, -distance).m_85950_(0.5f, 0.0f, 0.0f, 1.0f).m_5752_();
        bb.m_252986_(matrix, 0.25f, -0.25f, 0.5f).m_85950_(0.5f, 0.0f, 0.0f, 1.0f).m_5752_();
        bb.m_252986_(matrix, 0.25f, -quarterWidth - 0.25f, 0.5f).m_85950_(0.5f, 0.0f, 0.0f, 1.0f).m_5752_();
        bb.m_252986_(matrix0, -6.0f, -biggerWidth + 3.0f, -distance).m_85950_(0.5f, 0.0f, 0.0f, 1.0f).m_5752_();
        bb.m_252986_(matrix0, -6.0f, 3.0f, -distance).m_85950_(0.5f, 0.0f, 0.0f, 1.0f).m_5752_();
        bb.m_252986_(matrix, quarterWidth + 0.25f, -0.25f, 0.5f).m_85950_(0.5f, 0.0f, 0.0f, 1.0f).m_5752_();
        bb.m_252986_(matrix, quarterWidth + 0.25f, -quarterWidth - 0.25f, 0.5f).m_85950_(0.5f, 0.0f, 0.0f, 1.0f).m_5752_();
        bb.m_252986_(matrix0, biggerWidth - 6.0f, -biggerWidth + 3.0f, -distance).m_85950_(0.5f, 0.0f, 0.0f, 1.0f).m_5752_();
        bb.m_252986_(matrix0, biggerWidth - 6.0f, 3.0f, -distance).m_85950_(0.5f, 0.0f, 0.0f, 1.0f).m_5752_();
    }
}

