/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.config.annoconfg;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.montoyo.wd.config.annoconfg.ConfigEntry;
import net.montoyo.wd.config.annoconfg.annotation.format.CFGSegment;
import net.montoyo.wd.config.annoconfg.annotation.format.Comment;
import net.montoyo.wd.config.annoconfg.annotation.format.Config;
import net.montoyo.wd.config.annoconfg.annotation.format.Name;
import net.montoyo.wd.config.annoconfg.annotation.format.Skip;
import net.montoyo.wd.config.annoconfg.annotation.format.Translation;
import net.montoyo.wd.config.annoconfg.annotation.value.Default;
import net.montoyo.wd.config.annoconfg.annotation.value.DoubleRange;
import net.montoyo.wd.config.annoconfg.annotation.value.IntRange;
import net.montoyo.wd.config.annoconfg.annotation.value.LongRange;
import net.montoyo.wd.config.annoconfg.handle.UnsafeHandle;
import net.montoyo.wd.config.annoconfg.util.EnumType;

public class AnnoCFG {
    private ForgeConfigSpec mySpec;
    private final HashMap<String, ConfigEntry> handles = new HashMap();
    private static final ArrayList<AnnoCFG> configs = new ArrayList();
    private final Method postInit;

    public AnnoCFG(IEventBus bus, Class<?> clazz) {
        bus.addListener(this::onConfigChange);
        ForgeConfigSpec.Builder configBuilder = new ForgeConfigSpec.Builder();
        this.setup("", configBuilder, clazz);
        configs.add(this);
        Method m = null;
        try {
            m = clazz.getDeclaredMethod("postLoad", new Class[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.postInit = m;
        Config configDescriptor = clazz.getAnnotation(Config.class);
        if (configDescriptor != null) {
            Object pth = configDescriptor.path();
            if (!((String)pth).isEmpty()) {
                pth = (String)pth + "/";
            }
            switch (configDescriptor.type()) {
                case SERVER: {
                    this.create(ModConfig.Type.SERVER, (String)pth + ModLoadingContext.get().getActiveNamespace() + "_server.toml");
                    break;
                }
                case CLIENT: {
                    this.create(ModConfig.Type.CLIENT, (String)pth + ModLoadingContext.get().getActiveNamespace() + "_client.toml");
                    break;
                }
                case COMMON: {
                    this.create(ModConfig.Type.COMMON, (String)pth + ModLoadingContext.get().getActiveNamespace() + "_common.toml");
                    break;
                }
                default: {
                    throw new RuntimeException("wat");
                }
            }
        }
    }

    protected void setupCommentsAndTranslations(AnnotatedElement element, ForgeConfigSpec.Builder builder, String ... additionalLines) {
        Translation translation = element.getAnnotation(Translation.class);
        Comment comment = element.getAnnotation(Comment.class);
        StringBuilder builder1 = new StringBuilder();
        if (comment != null) {
            for (int i = 0; i < comment.value().length; ++i) {
                String s = comment.value()[i];
                builder1.append(s);
                if (i == comment.value().length - 1) continue;
                builder1.append("\n");
            }
        }
        for (String additionalLine : additionalLines) {
            builder1.append(additionalLine);
        }
        if (!builder1.isEmpty()) {
            builder.comment(builder1.toString());
        }
        if (translation != null) {
            builder.translation(translation.value());
        }
    }

    public void setup(String dir, ForgeConfigSpec.Builder builder, Class<?> clazz) {
        Object name;
        if (dir.startsWith(".")) {
            dir = dir.substring(1);
        }
        for (Field field : clazz.getFields()) {
            Object value;
            Skip skip;
            if (!field.canAccess(null) || (skip = field.getAnnotation(Skip.class)) != null) continue;
            name = field.getAnnotation(Name.class);
            String nameStr = field.getName();
            if (name != null) {
                nameStr = name.value();
            }
            this.setupCommentsAndTranslations(field, builder, new String[0]);
            Default defaultValue = field.getAnnotation(Default.class);
            try {
                switch (EnumType.forClass(field.getType())) {
                    case INT: {
                        Annotation range = field.getAnnotation(IntRange.class);
                        int v = defaultValue.valueI();
                        if (range != null) {
                            int min = range.minV();
                            int max = range.maxV();
                            value = builder.defineInRange(nameStr, v, min, max);
                            break;
                        }
                        value = builder.define(nameStr, (Object)v);
                        break;
                    }
                    case LONG: {
                        Annotation range = field.getAnnotation(LongRange.class);
                        long v = defaultValue.valueL();
                        if (range != null) {
                            long min = range.minV();
                            long max = range.maxV();
                            value = builder.defineInRange(nameStr, v, min, max);
                            break;
                        }
                        value = builder.define(nameStr, (Object)v);
                        break;
                    }
                    case DOUBLE: {
                        Annotation range = field.getAnnotation(DoubleRange.class);
                        double v = defaultValue.valueD();
                        if (range != null) {
                            double min = range.minV();
                            double max = range.maxV();
                            value = builder.defineInRange(nameStr, v, min, max);
                            break;
                        }
                        value = builder.define(nameStr, (Object)v);
                        break;
                    }
                    case BOOLEAN: {
                        boolean b = defaultValue.valueBoolean();
                        value = builder.define(nameStr, b);
                        break;
                    }
                    case OTHER: {
                        Class<?> fieldType = field.getType();
                        if (fieldType.equals(String[].class)) {
                            ForgeConfigSpec.ConfigValue sup = builder.define(nameStr, (Object)defaultValue.valueStr());
                            value = () -> AnnoCFG.lambda$setup$0((Supplier)sup);
                            break;
                        }
                        if (fieldType.equals(String.class)) {
                            value = builder.define(nameStr, (Object)defaultValue.valueStr());
                            break;
                        }
                        throw new RuntimeException("NYI " + field.getType());
                    }
                    default: {
                        throw new RuntimeException("NYI " + field.getType());
                    }
                }
            }
            catch (NullPointerException npe) {
                String inf = "";
                if (npe.getMessage().contains("\"value.Default\"")) {
                    inf = " this is likely due to a missing default.";
                }
                throw new RuntimeException("A null pointer occurred on " + field.getName() + inf, npe);
            }
            try {
                Object o = field.get(null);
            }
            catch (Throwable inf) {
                // empty catch block
            }
            UnsafeHandle handle = new UnsafeHandle(field);
            Object o = handle.get();
            handle.set(o);
            this.handles.put(dir + "." + nameStr, new ConfigEntry(handle, ((Supplier)value)::get));
        }
        for (AnnotatedElement annotatedElement : clazz.getClasses()) {
            if (annotatedElement == clazz || !((Class)annotatedElement).getName().startsWith(clazz.getName())) continue;
            CFGSegment segment = ((Class)annotatedElement).getAnnotation(CFGSegment.class);
            if (segment == null) {
                System.out.println(annotatedElement);
                throw new RuntimeException("NYI: default name");
            }
            name = segment.value();
            this.setupCommentsAndTranslations(annotatedElement, builder, new String[0]);
            builder.push((String)name);
            this.setup(dir + "." + (String)name, builder, (Class<?>)annotatedElement);
            builder.pop();
        }
        this.mySpec = builder.build();
    }

    public void onConfigChange(ModConfigEvent event) {
        if (event.getConfig().getSpec().equals(this.mySpec) || event.getConfig().getSpec() == this.mySpec) {
            for (String s : this.handles.keySet()) {
                ConfigEntry entry = this.handles.get(s);
                entry.handle.set(entry.supplier.get());
            }
        }
        try {
            this.postInit.invoke(null, new Object[0]);
        }
        catch (Throwable err) {
            err.printStackTrace();
        }
    }

    public void create(ModConfig.Type type, String file) {
        ModLoadingContext.get().registerConfig(type, (IConfigSpec)this.mySpec, file);
    }

    private static /* synthetic */ Object lambda$setup$0(Supplier sup) {
        String v = (String)sup.get();
        return v.split(",");
    }
}

