/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.controls;

import java.util.Objects;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;
import net.montoyo.wd.core.MissingPermissionException;
import net.montoyo.wd.entity.ScreenBlockEntity;
import net.montoyo.wd.utilities.data.BlockSide;

public abstract class ScreenControl {
    private final ResourceLocation id;

    public ScreenControl(ResourceLocation id) {
        this.id = id;
    }

    public abstract void write(FriendlyByteBuf var1);

    public abstract void handleServer(BlockPos var1, BlockSide var2, ScreenBlockEntity var3, NetworkEvent.Context var4, Function<Integer, Boolean> var5) throws MissingPermissionException;

    @OnlyIn(value=Dist.CLIENT)
    public abstract void handleClient(BlockPos var1, BlockSide var2, ScreenBlockEntity var3, NetworkEvent.Context var4);

    public void checkPerms(int perms, Function<Integer, Boolean> checker, ServerPlayer player) throws MissingPermissionException {
        if (!checker.apply(perms).booleanValue()) {
            throw new MissingPermissionException(perms, Objects.requireNonNull(player));
        }
    }

    public final ResourceLocation getId() {
        return this.id;
    }
}

