/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.controls.builtin;

import io.netty.buffer.ByteBuf;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;
import net.montoyo.wd.controls.ScreenControl;
import net.montoyo.wd.core.MissingPermissionException;
import net.montoyo.wd.entity.ScreenBlockEntity;
import net.montoyo.wd.utilities.data.BlockSide;
import net.montoyo.wd.utilities.math.Vector2i;

public class ClickControl
extends ScreenControl {
    public static final ResourceLocation id = new ResourceLocation("webdisplays:click");
    ControlType type;
    Vector2i coord;

    public ClickControl(ControlType type, Vector2i coord) {
        this(type, coord, -1);
        this.type = type;
    }

    public ClickControl(ControlType type, Vector2i coord, int button) {
        super(id);
        this.coord = coord;
    }

    public ClickControl(FriendlyByteBuf buf) {
        super(id);
        this.type = ControlType.values()[buf.readByte()];
        this.coord = new Vector2i((ByteBuf)buf);
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.writeByte(this.type.ordinal());
        this.coord.writeTo((ByteBuf)buf);
    }

    @Override
    public void handleServer(BlockPos pos, BlockSide side, ScreenBlockEntity tes, NetworkEvent.Context ctx, Function<Integer, Boolean> permissionChecker) throws MissingPermissionException {
        throw new RuntimeException("Cannot call click control on server");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handleClient(BlockPos pos, BlockSide side, ScreenBlockEntity tes, NetworkEvent.Context ctx) {
        if (this.coord != null) {
            tes.handleMouseEvent(side, ControlType.MOVE, this.coord, -1);
        }
        tes.handleMouseEvent(side, this.type, this.coord, 1);
    }

    public static enum ControlType {
        CLICK,
        MOVE,
        DOWN,
        UP;

    }
}

