/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.controls.builtin;

import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;
import net.montoyo.wd.controls.ScreenControl;
import net.montoyo.wd.core.MissingPermissionException;
import net.montoyo.wd.entity.ScreenBlockEntity;
import net.montoyo.wd.utilities.data.BlockSide;
import net.montoyo.wd.utilities.serialization.NameUUIDPair;

public class OwnerControl
extends ScreenControl {
    public static final ResourceLocation id = new ResourceLocation("webdisplays:set_owner");
    NameUUIDPair owner;

    public OwnerControl(NameUUIDPair pair) {
        super(id);
        this.owner = pair;
    }

    public OwnerControl(FriendlyByteBuf buf) {
        super(id);
        this.owner = new NameUUIDPair(buf);
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        this.owner.writeTo(buf);
    }

    @Override
    public void handleServer(BlockPos pos, BlockSide side, ScreenBlockEntity tes, NetworkEvent.Context ctx, Function<Integer, Boolean> permissionChecker) throws MissingPermissionException {
        throw new RuntimeException("Cannot handle ownership theft packet from server");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handleClient(BlockPos pos, BlockSide side, ScreenBlockEntity tes, NetworkEvent.Context ctx) {
        tes.getScreen((BlockSide)side).owner = this.owner;
    }
}

