/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.utilities.browser.handlers;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.montoyo.wd.utilities.browser.WDBrowser;
import net.montoyo.wd.utilities.browser.handlers.js.JSQueryHandler;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.callback.CefQueryCallback;
import org.cef.handler.CefMessageRouterHandlerAdapter;

public class WDRouter
extends CefMessageRouterHandlerAdapter {
    public static final WDRouter INSTANCE = new WDRouter();
    private static boolean exists = false;
    ArrayList<QueryData> awaitingQueries = new ArrayList();
    private static final Gson gson = new Gson();

    public WDRouter() {
        if (exists) {
            throw new RuntimeException("Can only have one WD message router.");
        }
        exists = true;
    }

    public boolean onQuery(CefBrowser browser, CefFrame frame, long queryId, String request, boolean persistent, CefQueryCallback callback) {
        if (request.startsWith("WebDisplays_")) {
            request = request.substring("Webdisplays_".length());
            QueryData target = null;
            for (QueryData awaitingQuery : this.awaitingQueries) {
                if (browser != awaitingQuery.browser || !request.startsWith(awaitingQuery.type)) continue;
                String requestData = request.substring(awaitingQuery.type.length());
                target = awaitingQuery;
                awaitingQuery.consumer.accept(requestData, callback);
                break;
            }
            if (target != null) {
                this.awaitingQueries.remove(target);
                callback.success("");
            } else if (browser instanceof WDBrowser) {
                WDBrowser wdBrowser = (WDBrowser)browser;
                HashMap<String, JSQueryHandler> handlerMap = wdBrowser.queryHandlers();
                int i0 = request.indexOf(40);
                int i1 = request.indexOf(123);
                if (i0 == -1) {
                    i0 = i1;
                }
                if (i1 == -1) {
                    i1 = i0;
                }
                if (i1 == -1) {
                    if (handlerMap.containsKey(request) && !((JSQueryHandler)handlerMap.get(request)).handle(browser, frame, null, persistent, callback)) {
                        callback.failure(-1, "Query " + queryId + " with data " + request + " completed, but wasn't marked as successful.");
                    }
                } else {
                    int min = Math.min(i0, i1);
                    String text = request.substring(0, min);
                    if (handlerMap.containsKey(text)) {
                        JsonObject obj = null;
                        if (request.charAt(min) == '{') {
                            obj = (JsonObject)gson.fromJson(request.substring(min), JsonObject.class);
                        }
                        if (!((JSQueryHandler)handlerMap.get(text)).handle(browser, frame, obj, persistent, callback)) {
                            callback.failure(-1, "Query " + queryId + " with data " + request + " completed, but wasn't marked as successful.");
                        }
                    }
                    callback.failure(-1, "Query " + queryId + " with data " + request + " completed, but there was no active request waiting for the result.");
                }
            }
            return true;
        }
        return false;
    }

    public Task<JsonObject> requestJson(CefBrowser screen, String queryType, String script) {
        JsonObject[] obj = new JsonObject[1];
        QueryData qd = new QueryData(screen, queryType, (data, context) -> {
            obj[0] = (JsonObject)gson.fromJson(data, JsonObject.class);
        });
        this.awaitingQueries.add(qd);
        screen.executeJavaScript(script, "", 0);
        return new Task<JsonObject>(qd, CompletableFuture.supplyAsync(() -> {
            while (obj[0] == null) {
                try {
                    Thread.sleep(1L);
                }
                catch (Throwable throwable) {}
            }
            return obj[0];
        }));
    }

    class QueryData {
        CefBrowser browser;
        String type;
        BiConsumer<String, CefQueryCallback> consumer;

        public QueryData(CefBrowser browser, String type, BiConsumer<String, CefQueryCallback> consumer) {
            this.browser = browser;
            this.type = type;
            this.consumer = consumer;
        }
    }

    public class Task<T> {
        QueryData qd;
        CompletableFuture<T> wrapped;

        public Task(QueryData qd, CompletableFuture<T> wrapped) {
            this.qd = qd;
            this.wrapped = wrapped;
        }

        public void cancel() {
            this.wrapped.cancel(true);
            WDRouter.this.awaitingQueries.remove(this.qd);
        }

        public Task<T> thenAccept(Consumer<T> consumer) {
            this.wrapped.thenAccept((Consumer)consumer);
            return this;
        }
    }
}

