/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.items;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mob_grinding_utils.ModItems;
import mob_grinding_utils.ModTags;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemMobSwab
extends Item {
    public boolean used;

    public ItemMobSwab(Item.Properties properties, boolean used) {
        super(properties);
        this.used = used;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level world, @Nonnull List<Component> list, @Nonnull TooltipFlag flag) {
        if (!this.used) {
            list.add((Component)Component.m_237115_((String)"tooltip.mobswab_1").m_130940_(ChatFormatting.YELLOW));
        } else if (stack.m_41782_() && Objects.requireNonNull(stack.m_41783_()).m_128441_("mguMobName")) {
            list.add((Component)Component.m_237115_((String)"tooltip.mobswab_2").m_130940_(ChatFormatting.YELLOW));
            list.add((Component)Component.m_237115_((String)"tooltip.mobswab_3").m_130940_(ChatFormatting.GREEN).m_130946_(" " + Objects.requireNonNull(stack.m_41783_().m_128423_("mguMobName")).m_7916_() + " 'DNA'."));
        }
    }

    @Nonnull
    public InteractionResult m_6880_(@Nonnull ItemStack stack, @Nonnull Player player, @Nonnull LivingEntity target, @Nonnull InteractionHand hand) {
        if (!(target instanceof Player || this.used || target.m_6095_().m_204039_(ModTags.Entities.NO_SWAB))) {
            String mobName = Objects.requireNonNull(ForgeRegistries.ENTITY_TYPES.getKey((Object)target.m_6095_())).toString();
            ItemStack stack2 = new ItemStack((ItemLike)ModItems.MOB_SWAB_USED.get(), 1);
            if (!stack2.m_41784_().m_128441_("mguMobName")) {
                stack2.m_41783_().m_128359_("mguMobName", mobName);
                CompoundTag nbt = new CompoundTag();
                target.m_7380_(nbt);
            }
            player.m_21008_(hand, stack2);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

