/*
 * Decompiled with CFR 0.152.
 */
package ru.liko.dronedetector.client;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import ru.liko.dronedetector.client.ClientConfig;
import ru.liko.dronedetector.client.DroneTracker;

public final class DroneDetectorHud {
    public static final IGuiOverlay OVERLAY = (gui, gfx, pt, sw, sh) -> {
        if (!((Boolean)ClientConfig.HUD_ENABLED.get()).booleanValue()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || mc.f_91066_.f_92062_) {
            return;
        }
        List<DroneTracker.Target> targets = DroneTracker.INSTANCE.getSnapshotLimited((Integer)ClientConfig.HUD_LIST_COUNT.get());
        if (targets.isEmpty()) {
            return;
        }
        Font font = mc.f_91062_;
        int lineH = 10;
        int pad = 4;
        int maxW = 0;
        for (DroneTracker.Target t : targets) {
            String text = DroneDetectorHud.formatLine(t.name, (int)Math.round(t.distance), t.bearingDeg);
            maxW = Math.max(maxW, font.m_92895_(text));
        }
        int width = maxW + pad * 2;
        int height = targets.size() * lineH + pad * 2;
        int x = (Integer)ClientConfig.HUD_X.get();
        int y = (Integer)ClientConfig.HUD_Y.get();
        if (((Boolean)ClientConfig.HUD_ANCHOR_RIGHT.get()).booleanValue()) {
            x = sw - width - (Integer)ClientConfig.HUD_X.get();
        }
        int bg = -2013265920;
        int br = 0x66FFFFFF;
        gfx.m_280509_(x, y, x + width, y + height, bg);
        gfx.m_280509_(x, y, x + width, y + 1, br);
        gfx.m_280509_(x, y + height - 1, x + width, y + height, br);
        gfx.m_280509_(x, y, x + 1, y + height, br);
        gfx.m_280509_(x + width - 1, y, x + width, y + height, br);
        int cy = y + pad + 1;
        for (DroneTracker.Target t : targets) {
            String text = DroneDetectorHud.formatLine(t.name, (int)Math.round(t.distance), t.bearingDeg);
            int color = DroneDetectorHud.colorByDistance(t.distance);
            gfx.m_280056_(font, text, x + pad, cy, color, true);
            cy += lineH;
        }
    };

    private static String formatLine(String name, int meters, float bearingDeg) {
        String arrow = DroneDetectorHud.bearingToArrow(bearingDeg);
        return arrow + " " + name + " [" + meters + "m]";
    }

    private static String bearingToArrow(float deg) {
        float a = (deg + 360.0f) % 360.0f;
        if ((double)a < 22.5 || (double)a >= 337.5) {
            return "\u2191";
        }
        if ((double)a < 67.5) {
            return "\u2197";
        }
        if ((double)a < 112.5) {
            return "\u2192";
        }
        if ((double)a < 157.5) {
            return "\u2198";
        }
        if ((double)a < 202.5) {
            return "\u2193";
        }
        if ((double)a < 247.5) {
            return "\u2199";
        }
        if ((double)a < 292.5) {
            return "\u2190";
        }
        return "\u2196";
    }

    private static int colorByDistance(double d) {
        if (d < 15.0) {
            return -43691;
        }
        if (d < 35.0) {
            return -171;
        }
        return -11141291;
    }

    private DroneDetectorHud() {
    }
}

