/*
 * Decompiled with CFR 0.152.
 */
package ru.liko.dronedetector.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import ru.liko.dronedetector.client.ClientConfig;
import ru.liko.dronedetector.common.DroneTags;
import ru.liko.dronedetector.common.ServerValues;
import ru.liko.dronedetector.item.DroneDetectorItem;
import ru.liko.dronedetector.registry.ModSounds;

public final class DroneTracker {
    public static final DroneTracker INSTANCE = new DroneTracker();
    private final List<Target> snapshot = new ArrayList<Target>();
    private UUID nearestId = null;
    private int beepCooldownTicks = 0;

    private DroneTracker() {
    }

    public List<Target> getSnapshotLimited(int limit) {
        if (this.snapshot.size() <= limit) {
            return Collections.unmodifiableList(this.snapshot);
        }
        return Collections.unmodifiableList(this.snapshot.subList(0, Math.max(0, limit)));
    }

    public Optional<Target> getNearest() {
        return this.snapshot.isEmpty() ? Optional.empty() : Optional.of(this.snapshot.get(0));
    }

    public static boolean hasActiveDetector(Player p) {
        if (p == null) {
            return false;
        }
        ItemStack main = p.m_21205_();
        if (main.m_41720_() instanceof DroneDetectorItem && DroneDetectorItem.isActive(main)) {
            return true;
        }
        ItemStack off = p.m_21206_();
        if (off.m_41720_() instanceof DroneDetectorItem && DroneDetectorItem.isActive(off)) {
            return true;
        }
        Inventory inv = p.m_150109_();
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack st = inv.m_8020_(i);
            if (!(st.m_41720_() instanceof DroneDetectorItem) || !DroneDetectorItem.isActive(st)) continue;
            return true;
        }
        return false;
    }

    public void tick(Minecraft mc) {
        LocalPlayer player = mc.f_91074_;
        ClientLevel level = mc.f_91073_;
        if (player == null || level == null) {
            return;
        }
        if (!DroneTracker.hasActiveDetector((Player)player)) {
            this.snapshot.clear();
            this.nearestId = null;
            this.beepCooldownTicks = 0;
            return;
        }
        double range = ServerValues.getRange();
        boolean onlyNearestBeep = (Boolean)ClientConfig.ONLY_NEAREST_BEEP.get();
        AABB box = player.m_20191_().m_82400_(range);
        Predicate<Entity> filter = this::isDroneCandidate;
        List found = level.m_6443_(Entity.class, box, e -> e != player && filter.test((Entity)e));
        this.snapshot.clear();
        for (Entity e2 : found) {
            this.snapshot.add(new Target(e2, (Player)player));
        }
        this.snapshot.sort(Comparator.comparingDouble(t -> t.distance));
        if (onlyNearestBeep && !this.snapshot.isEmpty()) {
            Target nearest = this.snapshot.get(0);
            if (!nearest.id.equals(this.nearestId)) {
                this.nearestId = nearest.id;
                this.beepCooldownTicks = 0;
            }
            this.handleBeep((Level)level, (Player)player, nearest, range);
        } else {
            this.nearestId = null;
        }
    }

    private void handleBeep(Level level, Player player, Target nearest, double range) {
        if (this.beepCooldownTicks > 0) {
            --this.beepCooldownTicks;
            return;
        }
        double d = nearest.distance;
        double minD = 5.0;
        double maxD = Math.max(range, 16.0);
        double t = Mth.m_14008_((double)((d - minD) / (maxD - minD)), (double)0.0, (double)1.0);
        int minPeriod = (Integer)ClientConfig.BEEP_MIN_PERIOD.get();
        int maxPeriod = (Integer)ClientConfig.BEEP_MAX_PERIOD.get();
        int period = (int)Mth.m_14139_((double)t, (double)minPeriod, (double)maxPeriod);
        float minPitch = ((Double)ClientConfig.BEEP_PITCH_MAX.get()).floatValue();
        float maxPitch = ((Double)ClientConfig.BEEP_PITCH_MIN.get()).floatValue();
        float pitch = (float)Mth.m_14139_((double)t, (double)minPitch, (double)maxPitch);
        float volume = ((Double)ClientConfig.BEEP_VOLUME.get()).floatValue();
        SoundEvent sound = ModSounds.DETECTOR_BEEP.isPresent() ? (SoundEvent)ModSounds.DETECTOR_BEEP.get() : (SoundEvent)SoundEvents.f_12215_.m_203334_();
        level.m_7785_(player.m_20185_(), player.m_20186_(), player.m_20189_(), sound, SoundSource.PLAYERS, volume, pitch, false);
        this.beepCooldownTicks = Math.max(1, period);
    }

    private boolean isDroneCandidate(Entity e) {
        ResourceLocation key = BuiltInRegistries.f_256780_.m_7981_((Object)e.m_6095_());
        if (key == null) {
            return false;
        }
        if (e.m_6095_().m_204039_(DroneTags.DRONE_TARGETS)) {
            return true;
        }
        String ns = key.m_135827_();
        String path = key.m_135815_();
        return (ns.equals("sbw") || ns.equals("superbwarfare")) && path.contains("drone");
    }

    public static final class Target {
        public final UUID id;
        public final Entity entity;
        public final String name;
        public final double distance;
        public final float bearingDeg;

        Target(Entity e, Player player) {
            this.id = e.m_20148_();
            this.entity = e;
            this.name = e.m_5446_().getString();
            this.distance = e.m_20270_((Entity)player);
            Vec3 vec = e.m_20182_().m_82546_(player.m_20182_());
            float yawTo = (float)(Mth.m_14136_((double)vec.f_82481_, (double)vec.f_82479_) * 57.29577951308232) - 90.0f;
            this.bearingDeg = Mth.m_14177_((float)(yawTo - player.m_146908_()));
        }
    }
}

