/*
 * Decompiled with CFR 0.152.
 */
package ru.liko.dronedetector.item;

import java.util.function.Consumer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import ru.liko.dronedetector.client.render.item.DroneDetectorItemRenderer;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class DroneDetectorItem
extends Item
implements GeoItem {
    private static final String ACTIVE_TAG = "active";
    private static final RawAnimation IDLE = RawAnimation.begin().thenLoop("idle");
    private static final RawAnimation PING = RawAnimation.begin().thenPlay("ping");
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public DroneDetectorItem(Item.Properties props) {
        super(props.m_41487_(1));
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    public static boolean isActive(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        return tag.m_128471_(ACTIVE_TAG);
    }

    public static void setActive(ItemStack stack, boolean value) {
        stack.m_41784_().m_128379_(ACTIVE_TAG, value);
    }

    public static boolean toggle(ItemStack stack) {
        boolean now = !DroneDetectorItem.isActive(stack);
        DroneDetectorItem.setActive(stack, now);
        return now;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "main", 0, state -> state.setAndContinue(IDLE)).triggerableAnim("ping", PING)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private BlockEntityWithoutLevelRenderer renderer;

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                if (this.renderer == null) {
                    this.renderer = new DroneDetectorItemRenderer();
                }
                return this.renderer;
            }
        });
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!level.f_46443_ && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            boolean on = DroneDetectorItem.toggle(stack);
            long id = GeoItem.getOrAssignId((ItemStack)stack, (ServerLevel)serverLevel);
            this.triggerAnim((Entity)player, id, "main", "ping");
        }
        return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.f_46443_);
    }
}

