/*
 * Decompiled with CFR 0.152.
 */
package ru.liko.dronedetector.util;

import java.util.List;
import java.util.Locale;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import ru.liko.dronedetector.config.DroneDetectorConfig;

public class DroneFinder {
    public static Entity findNearestDrone(Level level, Vec3 center, double radius, double vRadius, boolean requireLoS) {
        AABB box = new AABB(center.f_82479_ - radius, center.f_82480_ - vRadius, center.f_82481_ - radius, center.f_82479_ + radius, center.f_82480_ + vRadius, center.f_82481_ + radius);
        List list = level.m_6443_(Entity.class, box, DroneFinder::isDroneLike);
        Entity nearest = null;
        double best = Double.MAX_VALUE;
        for (Entity e : list) {
            double d2 = e.m_20238_(center);
            if (!(d2 < best) || requireLoS && !DroneFinder.hasLineOfSight(level, center, e.m_20182_())) continue;
            best = d2;
            nearest = e;
        }
        return nearest;
    }

    private static boolean hasLineOfSight(Level level, Vec3 from, Vec3 to) {
        BlockHitResult res = level.m_45547_(new ClipContext(from, to, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null));
        return res == null || res.m_6662_() == HitResult.Type.MISS;
    }

    private static boolean isDroneLike(Entity e) {
        ResourceLocation key = BuiltInRegistries.f_256780_.m_7981_((Object)e.m_6095_());
        if (key != null) {
            String ns = key.m_135827_();
            String path = key.m_135815_().toLowerCase(Locale.ROOT);
            if (!((Boolean)DroneDetectorConfig.CLIENT.detectOnlyFromNamespace.get()).booleanValue() || ns.equals("superbwarfare")) {
                if (path.contains("drone") || path.contains("uav")) {
                    return true;
                }
                for (String pat : (List)DroneDetectorConfig.CLIENT.matchEntityIds.get()) {
                    if (!path.contains(pat.toLowerCase(Locale.ROOT))) continue;
                    return true;
                }
            }
        }
        String cn = e.getClass().getSimpleName().toLowerCase(Locale.ROOT);
        return cn.contains("drone");
    }
}

