/*
 * Decompiled with CFR 0.152.
 */
package mrthomas20121.thermal_extra.data.thermal_recipe;

import cofh.thermal.lib.util.recipes.ThermalCatalyst;
import java.util.function.Consumer;
import mrthomas20121.thermal_extra.data.thermal_recipe.FinishedThermalCatalyst;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;

public class CatalystBuilder<T extends ThermalCatalyst> {
    private final RecipeSerializer<T> catalystId;
    private Ingredient i;
    private float primary = 1.0f;
    private float secondary = 1.0f;
    private float energy = 1.0f;
    private float minChance = 1.0f;
    private float useChance = 1.0f;

    public CatalystBuilder(RecipeSerializer<T> catalystId) {
        this.catalystId = catalystId;
    }

    public CatalystBuilder<T> ingredient(Ingredient ingredient) {
        this.i = ingredient;
        return this;
    }

    public CatalystBuilder<T> ingredient(TagKey<Item> tagKey) {
        return this.ingredient(Ingredient.m_204132_(tagKey));
    }

    public CatalystBuilder<T> ingredient(ItemStack stack) {
        return this.ingredient(Ingredient.m_43927_((ItemStack[])new ItemStack[]{stack}));
    }

    public CatalystBuilder<T> ingredient(Item stack) {
        this.i = Ingredient.m_43929_((ItemLike[])new ItemLike[]{stack});
        return this;
    }

    public CatalystBuilder<T> primaryMod(float mod) {
        this.primary = mod;
        return this;
    }

    public CatalystBuilder<T> secondaryMod(float mod) {
        this.secondary = mod;
        return this;
    }

    public CatalystBuilder<T> energyMod(float mod) {
        this.energy = mod;
        return this;
    }

    public CatalystBuilder<T> minChanceMod(float mod) {
        this.minChance = mod;
        return this;
    }

    public CatalystBuilder<T> useChanceMod(float mod) {
        this.useChance = mod;
        return this;
    }

    public void save(Consumer<FinishedRecipe> finishedRecipeConsumer, ResourceLocation recipeId) {
        finishedRecipeConsumer.accept(new FinishedThermalCatalyst<T>(this.catalystId, recipeId, this.i, this.primary, this.secondary, this.energy, this.minChance, this.useChance));
    }
}

