/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.slope;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.model.FramedBlockModel;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.client.model.slopepanel.FramedSlopePanelModel;
import xfacthd.framedblocks.client.model.slopeslab.FramedSlopeSlabModel;
import xfacthd.framedblocks.common.FBContent;

public class FramedPyramidModel
extends FramedBlockModel {
    private static final Vector3f BOTTOM_CENTER = new Vector3f(0.5f, 0.0f, 0.5f);
    private static final Vector3f TOP_CENTER = new Vector3f(0.5f, 1.0f, 0.5f);
    private static final Vector3f ZERO = new Vector3f();
    private final Direction facing;
    private final boolean ySlope;

    public FramedPyramidModel(BlockState state, BakedModel baseModel) {
        super(state, baseModel);
        this.facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
        this.ySlope = (Boolean)state.m_61143_((Property)FramedProperties.Y_SLOPE);
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        Direction quadDir = quad.m_111306_();
        if (Utils.isY(this.facing)) {
            boolean up;
            boolean bl = up = this.facing == Direction.UP;
            if (!this.ySlope && quadDir.m_122434_() != this.facing.m_122434_()) {
                QuadModifier.geometry(quad).apply(Modifiers.cutSideLeftRight(false, up ? 0.5f : 1.0f, up ? 1.0f : 0.5f)).apply(Modifiers.cutSideLeftRight(true, up ? 0.5f : 1.0f, up ? 1.0f : 0.5f)).apply(Modifiers.makeVerticalSlope(up, FramedSlopePanelModel.SLOPE_ANGLE)).export(quadMap.get(null));
            } else if (this.ySlope && quadDir == this.facing) {
                for (Direction dir : Direction.Plane.HORIZONTAL) {
                    float angle = up ? -FramedSlopePanelModel.SLOPE_ANGLE : FramedSlopePanelModel.SLOPE_ANGLE;
                    angle = (up ? -90.0f : 90.0f) - angle;
                    if (dir == Direction.NORTH || dir == Direction.EAST) {
                        angle *= -1.0f;
                    }
                    Vector3f origin = up ? TOP_CENTER : BOTTOM_CENTER;
                    QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(dir.m_122428_(), 0.5f, 1.0f)).apply(Modifiers.cutTopBottom(dir.m_122427_(), 1.0f, 0.5f)).apply(Modifiers.offset(dir.m_122424_(), 0.5f)).apply(Modifiers.rotate(dir.m_122427_().m_122434_(), origin, angle, true)).export(quadMap.get(null));
                }
            }
        } else if (!this.ySlope && quadDir.m_122434_() == this.facing.m_122434_()) {
            QuadModifier.geometry(quad).apply(Modifiers.cutSideLeftRight(this.facing.m_122427_(), 1.0f, 0.5f)).apply(Modifiers.cutSideLeftRight(this.facing.m_122428_(), 1.0f, 0.5f)).apply(Modifiers.makeVerticalSlope(true, FramedSlopeSlabModel.SLOPE_ANGLE)).apply(Modifiers.offset(Direction.UP, 0.5f)).export(quadMap.get(null));
            QuadModifier.geometry(quad).apply(Modifiers.cutSideLeftRight(this.facing.m_122427_(), 0.5f, 1.0f)).apply(Modifiers.cutSideLeftRight(this.facing.m_122428_(), 0.5f, 1.0f)).apply(Modifiers.makeVerticalSlope(false, FramedSlopeSlabModel.SLOPE_ANGLE)).apply(Modifiers.offset(Direction.DOWN, 0.5f)).export(quadMap.get(null));
        } else if (this.ySlope && Utils.isY(quadDir)) {
            float angle;
            boolean up = quadDir == Direction.UP;
            float f = angle = up ? FramedSlopePanelModel.SLOPE_ANGLE : -FramedSlopePanelModel.SLOPE_ANGLE;
            if (this.facing == Direction.NORTH || this.facing == Direction.EAST) {
                angle *= -1.0f;
            }
            Vector3f origin = this.facing.m_122424_().m_253071_().max((Vector3fc)ZERO);
            if (up) {
                origin.add(0.0f, 1.0f, 0.0f);
            }
            QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(this.facing.m_122428_(), 0.5f, 1.0f)).apply(Modifiers.cutTopBottom(this.facing.m_122427_(), 1.0f, 0.5f)).apply(Modifiers.rotate(this.facing.m_122427_().m_122434_(), origin, angle, true)).export(quadMap.get(null));
        } else if (quadDir.m_122434_() == this.facing.m_122427_().m_122434_()) {
            boolean right = quadDir == this.facing.m_122427_();
            QuadModifier.geometry(quad).apply(Modifiers.cutSideUpDown(true, right ? 1.0f : 0.5f, right ? 0.5f : 1.0f)).apply(Modifiers.cutSideUpDown(false, right ? 1.0f : 0.5f, right ? 0.5f : 1.0f)).apply(Modifiers.makeHorizontalSlope(!right, FramedSlopePanelModel.SLOPE_ANGLE)).export(quadMap.get(null));
        }
    }

    @Override
    protected void applyInHandTransformation(PoseStack poseStack, ItemDisplayContext ctx) {
        poseStack.m_85837_(0.0, 0.5, 0.0);
    }

    public static BlockState itemSource() {
        return ((Block)FBContent.BLOCK_FRAMED_PYRAMID.get()).m_49966_();
    }
}

