/*
 * Decompiled with CFR 0.152.
 */
package com.reggarf.mods.create_better_motors.content.motors.blocksentity;

import com.mrh0.createaddition.CreateAddition;
import com.mrh0.createaddition.blocks.electric_motor.ElectricMotorBlock;
import com.mrh0.createaddition.blocks.electric_motor.ElectricMotorBlockEntity;
import com.mrh0.createaddition.compat.computercraft.ElectricMotorPeripheral;
import com.mrh0.createaddition.compat.computercraft.Peripherals;
import com.mrh0.createaddition.energy.InternalEnergyStorage;
import com.mrh0.createaddition.sound.CASoundScapes;
import com.mrh0.createaddition.util.Util;
import com.reggarf.mods.create_better_motors.config.CommonConfig;
import com.reggarf.mods.create_better_motors.registry.CBMBlocks;
import com.reggarf.mods.create_better_motors.util.StringFormattingTool;
import com.simibubi.create.content.kinetics.motor.KineticScrollValueBehaviour;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.CenteredSideValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollValueBehaviour;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;

public class HardenedMotorBlockEntity
extends ElectricMotorBlockEntity {
    protected float motorSpeed;
    protected ScrollValueBehaviour generatedSpeed;
    protected final InternalEnergyStorage energy = new InternalEnergyStorage(((Integer)CommonConfig.HARDENED_ELECTRIC_MOTOR_CAPACITY.get()).intValue(), ((Integer)CommonConfig.HARDENED_ELECTRIC_MOTOR_MAX_INPUT.get()).intValue(), 0);
    private LazyOptional<IEnergyStorage> lazyEnergy = LazyOptional.of(() -> this.energy);
    private LazyOptional<ElectricMotorPeripheral> lazyPeripheral = null;
    private boolean cc_update_rpm = false;
    private float cc_new_rpm = 32.0f;
    private boolean active = false;
    boolean first = true;

    public HardenedMotorBlockEntity(BlockEntityType<? extends ElectricMotorBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        if (CreateAddition.CC_ACTIVE) {
            this.lazyPeripheral = LazyOptional.of(() -> Peripherals.createElectricMotorPeripheral((ElectricMotorBlockEntity)this));
        }
        this.setLazyTickRate(20);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        CenteredSideValueBoxTransform slot = new CenteredSideValueBoxTransform((motor, side) -> motor.m_61143_((Property)ElectricMotorBlock.FACING) == side.m_122424_());
        this.generatedSpeed = new KineticScrollValueBehaviour((Component)CreateLang.translateDirect((String)"generic.speed", (Object[])new Object[0]), (SmartBlockEntity)this, (ValueBoxTransform)slot);
        this.generatedSpeed.between(-((Integer)CommonConfig.HARDENED_ELECTRIC_MOTOR_RPM_RANGE.get()).intValue(), ((Integer)CommonConfig.HARDENED_ELECTRIC_MOTOR_RPM_RANGE.get()).intValue());
        this.generatedSpeed.value = 16;
        this.generatedSpeed.withCallback(i -> this.updateGeneratedRotation((int)i));
        behaviours.add((BlockEntityBehaviour)this.generatedSpeed);
    }

    public float calculateAddedStressCapacity() {
        float capacity;
        this.lastCapacityProvided = capacity = (float)((Integer)CommonConfig.HARDENED_MAX_STRESS.get()).intValue() / 256.0f;
        return capacity;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        CreateLang.translate((String)"tooltip.create_better_motors.energy_stored", (Object[])new Object[0]).style(ChatFormatting.WHITE).forGoggles(tooltip);
        CreateLang.translate((String)"tooltip.create_better_motors.energy_storage", (Object[])new Object[]{StringFormattingTool.formatLong(this.energy.getEnergyStored()), StringFormattingTool.formatLong(this.energy.getMaxEnergyStored())}).style(ChatFormatting.AQUA).forGoggles(tooltip, 1);
        CreateLang.translate((String)"tooltip.create_better_motors.using", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        CreateLang.translate((String)"tooltip.create_better_motors.energy_per_tick", (Object[])new Object[]{" " + Util.format((int)HardenedMotorBlockEntity.getEnergyConsumptionRate(this.generatedSpeed.getValue()))}).style(ChatFormatting.AQUA).forGoggles(tooltip, 1);
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        return true;
    }

    public void updateGeneratedRotation(int rpm) {
        this.motorSpeed = rpm;
        super.updateGeneratedRotation();
    }

    public void initialize() {
        super.initialize();
        if (!this.hasSource() || this.getGeneratedSpeed() > this.getTheoreticalSpeed()) {
            this.updateGeneratedRotation();
        }
    }

    public float getGeneratedSpeed() {
        if (!CBMBlocks.HARDENED_MOTOR.has(this.m_58900_())) {
            return 0.0f;
        }
        return HardenedMotorBlockEntity.convertToDirection((float)(this.active ? this.motorSpeed : 0.0f), (Direction)((Direction)this.m_58900_().m_61143_((Property)ElectricMotorBlock.FACING)));
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ENERGY) {
            return this.lazyEnergy.cast();
        }
        if (CreateAddition.CC_ACTIVE && Peripherals.isPeripheral(cap)) {
            return this.lazyPeripheral.cast();
        }
        return super.getCapability(cap, side);
    }

    public void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.energy.read(compound);
        this.active = compound.m_128471_("active");
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        this.energy.write(compound);
        compound.m_128379_("active", this.active);
    }

    public void lazyTick() {
        super.lazyTick();
    }

    public static int getEnergyConsumptionRate(float rpm) {
        return Math.abs(rpm) > 0.0f ? (int)Math.max((double)((Integer)CommonConfig.HARDENED_FE_RPM.get()).intValue() * ((double)Math.abs(rpm) / 256.0), (double)((Integer)CommonConfig.HARDENED_ELECTRIC_MOTOR_MINIMUM_CONSUMPTION.get()).intValue()) : 0;
    }

    public void tick() {
        super.tick();
        if (this.first) {
            this.motorSpeed = this.generatedSpeed.getValue();
            this.updateGeneratedRotation();
            this.first = false;
        }
        if (this.cc_update_rpm) {
            this.generatedSpeed.setValue(Math.round(this.cc_new_rpm));
            this.motorSpeed = this.cc_new_rpm;
            this.cc_update_rpm = false;
            this.updateGeneratedRotation();
        }
        if (this.f_58857_.m_5776_()) {
            return;
        }
        int con = HardenedMotorBlockEntity.getEnergyConsumptionRate(this.motorSpeed);
        if (!this.active) {
            if (this.energy.getEnergyStored() > con * 2 && !((Boolean)this.m_58900_().m_61143_((Property)ElectricMotorBlock.POWERED)).booleanValue()) {
                this.active = true;
                this.updateGeneratedRotation();
            }
        } else {
            int ext = this.energy.internalConsumeEnergy(con);
            if (ext < con || ((Boolean)this.m_58900_().m_61143_((Property)ElectricMotorBlock.POWERED)).booleanValue()) {
                this.active = false;
                this.updateGeneratedRotation();
            }
        }
    }

    public void tickAudio() {
        super.tickAudio();
        if (!this.active) {
            return;
        }
        if (((Boolean)CommonConfig.HARDENED_AUDIO_ENABLED.get()).booleanValue()) {
            CASoundScapes.play((CASoundScapes.AmbienceGroup)CASoundScapes.AmbienceGroup.DYNAMO, (BlockPos)this.f_58858_, (float)1.0f);
        }
    }

    public boolean setRPM(float rpm) {
        this.cc_new_rpm = rpm = Math.max(Math.min(rpm, (float)((Integer)CommonConfig.HARDENED_ELECTRIC_MOTOR_RPM_RANGE.get()).intValue()), (float)(-((Integer)CommonConfig.HARDENED_ELECTRIC_MOTOR_RPM_RANGE.get()).intValue()));
        this.cc_update_rpm = true;
        return true;
    }
}

