/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.api.tool.BulletHandler;
import blusunrize.immersiveengineering.common.items.BulletItem;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.RecipeSerializers;
import javax.annotation.Nonnull;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.ItemHandlerHelper;

public class PotionBulletFillRecipe
extends CustomRecipe {
    public PotionBulletFillRecipe(ResourceLocation resourceLocation) {
        super(resourceLocation, CraftingBookCategory.MISC);
    }

    public boolean matches(CraftingContainer inv, @Nonnull Level world) {
        boolean hasBullet = false;
        boolean hasPotion = false;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stackInSlot = inv.m_8020_(i);
            if (stackInSlot.m_41619_()) continue;
            if (this.isPotionBullet(stackInSlot)) {
                if (hasBullet) {
                    return false;
                }
                hasBullet = true;
                continue;
            }
            if (stackInSlot.m_41720_() instanceof PotionItem) {
                if (hasPotion) {
                    return false;
                }
                hasPotion = true;
                continue;
            }
            return false;
        }
        return hasBullet && hasPotion;
    }

    @Nonnull
    public ItemStack assemble(CraftingContainer inv, RegistryAccess access) {
        ItemStack bullet = ItemStack.f_41583_;
        ItemStack potion = ItemStack.f_41583_;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stackInSlot = inv.m_8020_(i);
            if (stackInSlot.m_41619_()) continue;
            if (bullet.m_41619_() && this.isPotionBullet(stackInSlot)) {
                bullet = stackInSlot;
                continue;
            }
            if (!potion.m_41619_() || !(stackInSlot.m_41720_() instanceof PotionItem)) continue;
            potion = stackInSlot;
        }
        ItemStack newBullet = ItemHandlerHelper.copyStackWithSize((ItemStack)bullet, (int)1);
        ItemNBTHelper.setItemStack(newBullet, "potion", potion.m_41777_());
        return newBullet;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeSerializers.POTION_BULLET_FILL.get();
    }

    private boolean isPotionBullet(ItemStack stack) {
        return stack.m_41720_() instanceof BulletItem && ((BulletItem)stack.m_41720_()).getType() == BulletHandler.getBullet(BulletItem.POTION);
    }
}

