/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.explorerscompass.client;

import com.chaosthedude.explorerscompass.ExplorersCompass;
import com.chaosthedude.explorerscompass.config.ConfigHandler;
import com.chaosthedude.explorerscompass.items.ExplorersCompassItem;
import com.chaosthedude.explorerscompass.util.CompassState;
import com.chaosthedude.explorerscompass.util.ItemUtils;
import com.chaosthedude.explorerscompass.util.RenderUtils;
import com.chaosthedude.explorerscompass.util.StructureUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class ClientEventHandler {
    private static final Minecraft mc = Minecraft.m_91087_();

    @SubscribeEvent
    public void onRenderTick(RenderGuiOverlayEvent.Post event) {
        LocalPlayer player;
        ItemStack stack;
        if (ClientEventHandler.mc.f_91074_ != null && ClientEventHandler.mc.f_91073_ != null && !ClientEventHandler.mc.f_91066_.f_92062_ && !ClientEventHandler.mc.f_91066_.f_92063_ && (ClientEventHandler.mc.f_91080_ == null || ((Boolean)ConfigHandler.CLIENT.displayWithChatOpen.get()).booleanValue() && ClientEventHandler.mc.f_91080_ instanceof ChatScreen) && (stack = ItemUtils.getHeldItem((Player)(player = ClientEventHandler.mc.f_91074_), ExplorersCompass.explorersCompass)) != null && stack.m_41720_() instanceof ExplorersCompassItem) {
            ExplorersCompassItem compass = (ExplorersCompassItem)stack.m_41720_();
            if (compass.getState(stack) == CompassState.SEARCHING) {
                RenderUtils.drawConfiguredStringOnHUD(event.getGuiGraphics(), I18n.m_118938_((String)"string.explorerscompass.status", (Object[])new Object[0]), 5, 5, 0xFFFFFF, 0);
                RenderUtils.drawConfiguredStringOnHUD(event.getGuiGraphics(), I18n.m_118938_((String)"string.explorerscompass.searching", (Object[])new Object[0]), 5, 5, 0xAAAAAA, 1);
                RenderUtils.drawConfiguredStringOnHUD(event.getGuiGraphics(), I18n.m_118938_((String)"string.explorerscompass.structure", (Object[])new Object[0]), 5, 5, 0xFFFFFF, 3);
                RenderUtils.drawConfiguredStringOnHUD(event.getGuiGraphics(), StructureUtils.getPrettyStructureName(compass.getStructureKey(stack)), 5, 5, 0xAAAAAA, 4);
                RenderUtils.drawConfiguredStringOnHUD(event.getGuiGraphics(), I18n.m_118938_((String)"string.explorerscompass.radius", (Object[])new Object[0]), 5, 5, 0xFFFFFF, 6);
                RenderUtils.drawConfiguredStringOnHUD(event.getGuiGraphics(), String.valueOf(compass.getSearchRadius(stack)), 5, 5, 0xAAAAAA, 7);
            } else if (compass.getState(stack) == CompassState.FOUND) {
                RenderUtils.drawConfiguredStringOnHUD(event.getGuiGraphics(), I18n.m_118938_((String)"string.explorerscompass.status", (Object[])new Object[0]), 5, 5, 0xFFFFFF, 0);
                RenderUtils.drawConfiguredStringOnHUD(event.getGuiGraphics(), I18n.m_118938_((String)"string.explorerscompass.found", (Object[])new Object[0]), 5, 5, 0xAAAAAA, 1);
                RenderUtils.drawConfiguredStringOnHUD(event.getGuiGraphics(), I18n.m_118938_((String)"string.explorerscompass.structure", (Object[])new Object[0]), 5, 5, 0xFFFFFF, 3);
                RenderUtils.drawConfiguredStringOnHUD(event.getGuiGraphics(), StructureUtils.getPrettyStructureName(compass.getStructureKey(stack)), 5, 5, 0xAAAAAA, 4);
                if (compass.shouldDisplayCoordinates(stack)) {
                    RenderUtils.drawConfiguredStringOnHUD(event.getGuiGraphics(), I18n.m_118938_((String)"string.explorerscompass.coordinates", (Object[])new Object[0]), 5, 5, 0xFFFFFF, 6);
                    RenderUtils.drawConfiguredStringOnHUD(event.getGuiGraphics(), compass.getFoundStructureX(stack) + ", " + compass.getFoundStructureZ(stack), 5, 5, 0xAAAAAA, 7);
                    RenderUtils.drawConfiguredStringOnHUD(event.getGuiGraphics(), I18n.m_118938_((String)"string.explorerscompass.distance", (Object[])new Object[0]), 5, 5, 0xFFFFFF, 9);
                    RenderUtils.drawConfiguredStringOnHUD(event.getGuiGraphics(), String.valueOf(StructureUtils.getHorizontalDistanceToLocation((Player)player, compass.getFoundStructureX(stack), compass.getFoundStructureZ(stack))), 5, 5, 0xAAAAAA, 10);
                }
            } else if (compass.getState(stack) == CompassState.NOT_FOUND) {
                RenderUtils.drawConfiguredStringOnHUD(event.getGuiGraphics(), I18n.m_118938_((String)"string.explorerscompass.status", (Object[])new Object[0]), 5, 5, 0xFFFFFF, 0);
                RenderUtils.drawConfiguredStringOnHUD(event.getGuiGraphics(), I18n.m_118938_((String)"string.explorerscompass.notFound", (Object[])new Object[0]), 5, 5, 0xAAAAAA, 1);
                RenderUtils.drawConfiguredStringOnHUD(event.getGuiGraphics(), I18n.m_118938_((String)"string.explorerscompass.structure", (Object[])new Object[0]), 5, 5, 0xFFFFFF, 3);
                RenderUtils.drawConfiguredStringOnHUD(event.getGuiGraphics(), StructureUtils.getPrettyStructureName(compass.getStructureKey(stack)), 5, 5, 0xAAAAAA, 4);
                RenderUtils.drawConfiguredStringOnHUD(event.getGuiGraphics(), I18n.m_118938_((String)"string.explorerscompass.radius", (Object[])new Object[0]), 5, 5, 0xFFFFFF, 6);
                RenderUtils.drawConfiguredStringOnHUD(event.getGuiGraphics(), String.valueOf(compass.getSearchRadius(stack)), 5, 5, 0xAAAAAA, 7);
            }
        }
    }
}

