/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.integration.waila;

import java.util.HashMap;
import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import me.desht.modularrouters.item.upgrade.UpgradeItem;
import me.desht.modularrouters.util.MiscUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IServerDataProvider;

public class RouterDataProvider
implements IServerDataProvider<BlockAccessor> {
    public void appendServerData(CompoundTag compoundTag, BlockAccessor accessor) {
        BlockEntity blockEntity = accessor.getBlockEntity();
        if (blockEntity instanceof ModularRouterBlockEntity) {
            ModularRouterBlockEntity router = (ModularRouterBlockEntity)blockEntity;
            if (router.isPermitted(accessor.getPlayer())) {
                compoundTag.m_128405_("ModuleCount", router.getModuleCount());
                compoundTag.m_128405_("RedstoneMode", router.getRedstoneBehaviour().ordinal());
                compoundTag.m_128379_("EcoMode", router.getEcoMode());
                compoundTag.m_128365_("Upgrades", (Tag)this.getUpgrades(router));
            } else {
                compoundTag.m_128379_("Denied", true);
            }
        }
    }

    private CompoundTag getUpgrades(ModularRouterBlockEntity router) {
        IItemHandler handler = router.getUpgrades();
        HashMap<Item, Integer> counts = new HashMap<Item, Integer>();
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (!(stack.m_41720_() instanceof UpgradeItem)) continue;
            counts.put(stack.m_41720_(), counts.getOrDefault(stack.m_41720_(), 0) + stack.m_41613_());
        }
        CompoundTag upgrades = new CompoundTag();
        counts.forEach((k, v) -> upgrades.m_128405_(k.m_5524_(), v.intValue()));
        return upgrades;
    }

    public ResourceLocation getUid() {
        return MiscUtil.RL("router");
    }
}

