/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.item.smartfilter;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.modularrouters.client.gui.filter.FilterScreenFactory;
import me.desht.modularrouters.container.AbstractSmartFilterMenu;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.item.MRBaseItem;
import me.desht.modularrouters.logic.filter.matchers.IItemMatcher;
import me.desht.modularrouters.network.FilterSettingsMessage;
import me.desht.modularrouters.network.GuiSyncMessage;
import me.desht.modularrouters.util.MFLocator;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkHooks;

public abstract class SmartFilterItem
extends MRBaseItem {
    public SmartFilterItem() {
        super(ModItems.defaultProps());
    }

    @Nonnull
    public abstract IItemMatcher compile(ItemStack var1, ItemStack var2);

    @Nullable
    public abstract GuiSyncMessage onReceiveSettingsMessage(Player var1, FilterSettingsMessage var2, ItemStack var3, ItemStack var4);

    public abstract int getSize(ItemStack var1);

    public boolean hasMenu() {
        return true;
    }

    public AbstractSmartFilterMenu createMenu(int windowId, Inventory invPlayer, MFLocator loc) {
        return null;
    }

    @Override
    protected void addExtraInformation(ItemStack stack, List<Component> list) {
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        SmartFilterItem filter = (SmartFilterItem)stack.m_41720_();
        MFLocator loc = MFLocator.heldFilter(hand);
        if (!world.f_46443_ && filter.hasMenu()) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new FilterMenuProvider(player, loc), loc::writeBuf);
        } else if (world.f_46443_ && !this.hasMenu()) {
            FilterScreenFactory.openFilterGui(loc);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public static class FilterMenuProvider
    implements MenuProvider {
        private final MFLocator loc;
        private final ItemStack filterStack;

        public FilterMenuProvider(Player player, MFLocator loc) {
            this.loc = loc;
            this.filterStack = loc.getTargetItem(player);
        }

        public Component m_5446_() {
            return this.filterStack.m_41786_();
        }

        @Nullable
        public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player playerEntity) {
            return ((SmartFilterItem)this.filterStack.m_41720_()).createMenu(windowId, playerInventory, this.loc);
        }
    }
}

