/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.integration.energy;

import com.gregtechceu.gtceu.api.capability.IElectricItem;
import com.gregtechceu.gtceu.api.capability.IEnergyContainer;
import com.gregtechceu.gtceu.api.capability.forge.GTCapability;
import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import sonar.fluxnetworks.api.energy.IBlockEnergyConnector;
import sonar.fluxnetworks.api.energy.IItemEnergyConnector;
import sonar.fluxnetworks.common.util.FluxUtils;

public class GTCEUEnergyConnector
implements IBlockEnergyConnector,
IItemEnergyConnector {
    public static final GTCEUEnergyConnector INSTANCE = new GTCEUEnergyConnector();

    @Override
    public boolean hasCapability(@Nonnull BlockEntity target, @Nonnull Direction side) {
        return !target.m_58901_() && target.getCapability(GTCapability.CAPABILITY_ENERGY_CONTAINER, side).isPresent();
    }

    @Override
    public boolean canSendTo(@Nonnull BlockEntity target, @Nonnull Direction side) {
        if (!target.m_58901_()) {
            IEnergyContainer container = (IEnergyContainer)FluxUtils.get((ICapabilityProvider)target, GTCapability.CAPABILITY_ENERGY_CONTAINER, side);
            return container != null && container.inputsEnergy(side);
        }
        return false;
    }

    @Override
    public boolean canReceiveFrom(@Nonnull BlockEntity target, @Nonnull Direction side) {
        if (!target.m_58901_()) {
            IEnergyContainer container = (IEnergyContainer)FluxUtils.get((ICapabilityProvider)target, GTCapability.CAPABILITY_ENERGY_CONTAINER, side);
            return container != null && container.outputsEnergy(side);
        }
        return false;
    }

    @Override
    public long sendTo(long amount, @Nonnull BlockEntity target, @Nonnull Direction side, boolean simulate) {
        IEnergyContainer container = (IEnergyContainer)FluxUtils.get((ICapabilityProvider)target, GTCapability.CAPABILITY_ENERGY_CONTAINER, side);
        if (container == null) {
            return 0L;
        }
        long demand = container.getEnergyCanBeInserted();
        if (demand == 0L) {
            return 0L;
        }
        long voltage = container.getInputVoltage();
        long amperage = container.getInputAmperage();
        if (simulate) {
            long energy = Math.min(voltage * amperage, demand);
            return Math.min(energy << 2, amount);
        }
        long amountEu = amount >> 2;
        if ((voltage = Math.min(Math.min(voltage, amountEu), demand)) == 0L) {
            return 0L;
        }
        amperage = Math.min(amperage, amountEu / voltage);
        long energy = voltage * container.acceptEnergyFromNetwork(side, voltage, amperage);
        return energy << 2;
    }

    @Override
    public long receiveFrom(long amount, @Nonnull BlockEntity target, @Nonnull Direction side, boolean simulate) {
        IEnergyContainer container = (IEnergyContainer)FluxUtils.get((ICapabilityProvider)target, GTCapability.CAPABILITY_ENERGY_CONTAINER, side);
        if (container == null) {
            return 0L;
        }
        return container.removeEnergy(container.getOutputVoltage() * container.getOutputAmperage()) << 2;
    }

    @Override
    public boolean hasCapability(@Nonnull ItemStack stack) {
        return !stack.m_41619_() && stack.getCapability(GTCapability.CAPABILITY_ELECTRIC_ITEM).isPresent();
    }

    @Override
    public boolean canSendTo(@Nonnull ItemStack stack) {
        return this.hasCapability(stack);
    }

    @Override
    public boolean canReceiveFrom(@Nonnull ItemStack stack) {
        return this.hasCapability(stack);
    }

    @Override
    public long sendTo(long amount, @Nonnull ItemStack stack, boolean simulate) {
        IElectricItem electricItem = (IElectricItem)FluxUtils.get((ICapabilityProvider)stack, GTCapability.CAPABILITY_ELECTRIC_ITEM);
        if (electricItem != null) {
            return electricItem.charge(amount >> 2, electricItem.getTier(), false, simulate) << 2;
        }
        return 0L;
    }

    @Override
    public long receiveFrom(long amount, @Nonnull ItemStack stack, boolean simulate) {
        IElectricItem electricItem = (IElectricItem)FluxUtils.get((ICapabilityProvider)stack, GTCapability.CAPABILITY_ELECTRIC_ITEM);
        if (electricItem != null) {
            return electricItem.discharge(amount >> 2, electricItem.getTier(), false, true, false) << 2;
        }
        return 0L;
    }
}

