/*
 * Decompiled with CFR 0.152.
 */
package dev.tonimatas.mekanismcurios;

import com.mojang.logging.LogUtils;
import dev.tonimatas.mekanismcurios.bridge.PlayerBridge;
import dev.tonimatas.mekanismcurios.networking.ModMessages;
import java.util.Optional;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.SlotResult;

@Mod(value="mekanismcurios")
public class MekanismCurios {
    public static final String MODID = "mekanismcurios";
    public static final Logger LOGGER = LogUtils.getLogger();

    public MekanismCurios(FMLJavaModLoadingContext context) {
        ModMessages.register();
        LOGGER.info("Mekanism Curios initialized successfully.");
    }

    public static ItemStack getSlot(Player player) {
        return ((PlayerBridge)player).mci$getSlot().getItemStack(player);
    }

    public static ItemStack getHandOrCuriosItem(Player player, InteractionHand hand) {
        if (hand == null) {
            return MekanismCurios.getSlot(player);
        }
        return player.m_21120_(hand);
    }

    public static SlotResult getCuriosSlot(Player player, SlotContext slotContext) {
        Optional curiosInventory = CuriosApi.getCuriosInventory((LivingEntity)player).resolve();
        return curiosInventory.flatMap(iCuriosItemHandler -> iCuriosItemHandler.findCurio(slotContext.identifier(), slotContext.index())).orElse(null);
    }

    public static SlotContext getFirstCurios(Player player, Item item) {
        Optional curiosInventory = CuriosApi.getCuriosInventory((LivingEntity)player).resolve();
        Optional<SlotContext> firstCurios = curiosInventory.flatMap(iCuriosItemHandler -> iCuriosItemHandler.findFirstCurio(item));
        return firstCurios.map(SlotResult::slotContext).orElse(null);
    }
}

