/*
 * Decompiled with CFR 0.152.
 */
package dev.tonimatas.mekanismcurios.networking.packet;

import dev.tonimatas.mekanismcurios.util.CuriosSlots;
import java.util.function.Supplier;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.Coord4D;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.math.FloatingLong;
import mekanism.common.Mekanism;
import mekanism.common.content.teleporter.TeleporterFrequency;
import mekanism.common.item.ItemPortableTeleporter;
import mekanism.common.lib.frequency.Frequency;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.network.to_client.PacketPortalFX;
import mekanism.common.tile.TileEntityTeleporter;
import mekanism.common.util.StorageUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.server.ServerLifecycleHooks;

public class QuickTeleportActionPacket {
    public void encode(FriendlyByteBuf buf) {
    }

    public static QuickTeleportActionPacket decode(FriendlyByteBuf buf) {
        return new QuickTeleportActionPacket();
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            Item patt1976$temp;
            ServerPlayer player = context.getSender();
            if (player == null) {
                return;
            }
            ItemStack stack = CuriosSlots.TELEPORTER.getItemStack((Player)player);
            if (!stack.m_41619_() && (patt1976$temp = stack.m_41720_()) instanceof ItemPortableTeleporter) {
                ItemPortableTeleporter teleporterItem = (ItemPortableTeleporter)patt1976$temp;
                Frequency.FrequencyIdentity identity = teleporterItem.getFrequencyIdentity(stack);
                if (identity == null) {
                    player.m_213846_((Component)Component.m_237115_((String)"key.mekanismcurios.quickteleport.notconnected").m_130940_(ChatFormatting.RED));
                    return;
                }
                TeleporterFrequency found = (TeleporterFrequency)FrequencyType.TELEPORTER.getFrequency(teleporterItem.getFrequencyIdentity(stack), player.m_20148_());
                if (found == null) {
                    return;
                }
                Coord4D coords = found.getClosestCoords(new Coord4D((Entity)player));
                if (coords != null) {
                    ServerLevel teleWorld = ServerLifecycleHooks.getCurrentServer().m_129880_(coords.dimension);
                    TileEntityTeleporter teleporter = (TileEntityTeleporter)WorldUtils.getTileEntity(TileEntityTeleporter.class, (BlockGetter)teleWorld, (BlockPos)coords.getPos());
                    if (teleporter != null) {
                        if (!player.m_7500_()) {
                            FloatingLong energyCost = TileEntityTeleporter.calculateEnergyCost((Entity)player, (Level)teleWorld, (Coord4D)coords);
                            IEnergyContainer energyContainer = StorageUtils.getEnergyContainer((ItemStack)stack, (int)0);
                            if (energyContainer == null || energyContainer.extract(energyCost, Action.SIMULATE, AutomationType.MANUAL).smallerThan(energyCost)) {
                                player.m_213846_((Component)Component.m_237115_((String)"key.mekanismcurios.quickteleport.noenergy").m_130940_(ChatFormatting.RED));
                                return;
                            }
                            energyContainer.extract(energyCost, Action.EXECUTE, AutomationType.MANUAL);
                        }
                        try {
                            teleporter.didTeleport.add(player.m_20148_());
                            teleporter.teleDelay = 5;
                            player.f_8906_.f_9737_ = 0;
                            player.m_6915_();
                            Mekanism.packetHandler().sendToAllTracking((Object)new PacketPortalFX(player.m_20183_()), player.m_9236_(), coords.getPos());
                            if (player.m_20159_()) {
                                player.m_8127_();
                            }
                            double oldX = player.m_20185_();
                            double oldY = player.m_20186_();
                            double oldZ = player.m_20189_();
                            Level oldWorld = player.m_9236_();
                            BlockPos teleporterTargetPos = teleporter.getTeleporterTargetPos();
                            TileEntityTeleporter.teleportEntityTo((Entity)player, (Level)teleWorld, (BlockPos)teleporterTargetPos);
                            TileEntityTeleporter.alignPlayer((ServerPlayer)player, (BlockPos)teleporterTargetPos, (TileEntityTeleporter)teleporter);
                            if (player.m_9236_() != oldWorld || player.m_20275_(oldX, oldY, oldZ) >= 25.0) {
                                oldWorld.m_6263_(null, oldX, oldY, oldZ, SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, 1.0f);
                            }
                            player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, 1.0f);
                            teleporter.sendTeleportParticles();
                        }
                        catch (Exception exception) {}
                    }
                } else {
                    player.m_213846_((Component)Component.m_237115_((String)"key.mekanismcurios.quickteleport.notfound").m_130940_(ChatFormatting.RED));
                }
            } else {
                player.m_213846_((Component)Component.m_237115_((String)"key.mekanismcurios.quickteleport.empty").m_130940_(ChatFormatting.RED));
            }
        });
        return true;
    }
}

