/*
 * Decompiled with CFR 0.152.
 */
package tech.vvp.vvp;

import com.mojang.logging.LogUtils;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.NetworkDirection;
import org.slf4j.Logger;
import tech.vvp.vvp.config.server.ExplosionConfigVVP;
import tech.vvp.vvp.config.server.VehicleConfigVVP;
import tech.vvp.vvp.init.ModEntities;
import tech.vvp.vvp.init.ModItems;
import tech.vvp.vvp.init.ModSounds;
import tech.vvp.vvp.init.ModTabs;
import tech.vvp.vvp.init.ModVehicleItems;
import tech.vvp.vvp.network.VVPNetwork;
import tech.vvp.vvp.network.message.S2CRadarSyncPacket;

@Mod(value="vvp")
public class VVP {
    public static final String MOD_ID = "vvp";
    private static final Logger LOGGER = LogUtils.getLogger();

    public VVP() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModItems.register(modEventBus);
        ModEntities.register(modEventBus);
        ModVehicleItems.register(modEventBus);
        ModSounds.REGISTRY.register(modEventBus);
        ModTabs.TABS.register(modEventBus);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)VehicleConfigVVP.SPEC, "vvp-vehicle.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ExplosionConfigVVP.SPEC, "vvp-explosion.toml");
        modEventBus.addListener(this::setup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.addListener(this::onItemTooltip);
    }

    private void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            LOGGER.info("HELLO FROM COMMON SETUP");
            LOGGER.info("DIRT BLOCK >> {}", (Object)Blocks.f_50493_);
        });
        VVPNetwork.addNetworkMessage(S2CRadarSyncPacket.class, S2CRadarSyncPacket::buffer, S2CRadarSyncPacket::new, S2CRadarSyncPacket::handler, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
    }

    private void onItemTooltip(ItemTooltipEvent event) {
        String entityType;
        CompoundTag tag;
        if (event.getItemStack().m_41720_() instanceof BlockItem && event.getItemStack().m_41782_() && (tag = BlockItem.m_186336_((ItemStack)event.getItemStack())) != null && tag.m_128441_("EntityType") && (entityType = tag.m_128461_("EntityType")).startsWith("vvp:vdv_")) {
            event.getToolTip().add(Component.m_237115_((String)"tooltip.vvp.usage_restriction").m_130940_(ChatFormatting.RED));
        }
    }

    public static ResourceLocation loc(String path) {
        return new ResourceLocation(MOD_ID, path);
    }
}

