/*
 * Decompiled with CFR 0.152.
 */
package tech.vvp.vvp.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;

public class RadarHud {
    public static List<Vec3> radarTargets = new ArrayList<Vec3>();
    private static final ResourceLocation RADAR_BACKGROUND = new ResourceLocation("vvp", "textures/gui/radar_bg.png");
    private static final ResourceLocation RADAR_TARGET = new ResourceLocation("vvp", "textures/gui/radar_target.png");
    private static final ResourceLocation RADAR_SWEEP = new ResourceLocation("vvp", "textures/gui/radar_sweep.png");
    private static final List<String> SUPPORTED_HELICOPTERS = Arrays.asList("Mi24Entity", "CobraEntity", "F35Entity", "CobraSharkEntity", "Mi24ukrEntity", "Mi24polEntity");
    private static float sweepAngle = 0.0f;
    private static final float SWEEP_SPEED = 2.0f;
    private static final int TRAIL_LENGTH = 3;
    private static final Map<Vec3, Long> targetDetectionTime = new HashMap<Vec3, Long>();
    private static final long TARGET_VISIBILITY_TIME = 1000L;
    private static final long FADE_TIME = 1000L;
    public static final IGuiOverlay HUD_RADAR = (gui, guiGraphics, partialTick, screenWidth, screenHeight) -> {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null || !player.m_6084_() || mc.f_91073_ == null) {
            return;
        }
        Entity vehicle = player.m_20202_();
        if (vehicle != null && RadarHud.isRadarHelicopter(vehicle)) {
            int radarSize = 96;
            int radarX = 10;
            int radarY = 10;
            int radarCenterX = radarX + radarSize / 2;
            int radarCenterY = radarY + radarSize / 2;
            float radarDisplayRange = 300.0f;
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            guiGraphics.m_280163_(RADAR_BACKGROUND, radarX, radarY, 0.0f, 0.0f, radarSize, radarSize, radarSize, radarSize);
            sweepAngle = (sweepAngle + 2.0f * partialTick) % 360.0f;
            PoseStack poseStack = guiGraphics.m_280168_();
            poseStack.m_85836_();
            poseStack.m_252880_((float)radarCenterX, (float)radarCenterY, 0.0f);
            for (int i = 2; i >= 0; --i) {
                float trailAngle = sweepAngle - (float)(i * 20);
                float alpha = 0.15f - (float)i * 0.05f;
                poseStack.m_85836_();
                poseStack.m_252781_(Axis.f_252403_.m_252977_(trailAngle));
                RenderSystem.setShaderColor((float)0.0f, (float)1.0f, (float)0.0f, (float)alpha);
                guiGraphics.m_280163_(RADAR_SWEEP, -1, -47, 0.0f, 0.0f, 1, 47, 1, 47);
                poseStack.m_85849_();
            }
            poseStack.m_85836_();
            poseStack.m_252781_(Axis.f_252403_.m_252977_(sweepAngle));
            RenderSystem.setShaderColor((float)0.0f, (float)1.0f, (float)0.0f, (float)0.7f);
            guiGraphics.m_280163_(RADAR_SWEEP, -1, -47, 0.0f, 0.0f, 1, 47, 1, 47);
            poseStack.m_85849_();
            poseStack.m_85849_();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            long currentTime = System.currentTimeMillis();
            targetDetectionTime.entrySet().removeIf(entry -> currentTime - (Long)entry.getValue() > 2000L);
            for (Vec3 targetPos : radarTargets) {
                Vec3 relativePos = targetPos.m_82546_(player.m_20182_());
                double distance = Math.sqrt(relativePos.f_82479_ * relativePos.f_82479_ + relativePos.f_82481_ * relativePos.f_82481_);
                if (distance > 150.0) continue;
                float playerYaw = (player.m_5675_(1.0f) % 360.0f + 360.0f) % 360.0f;
                double angleToTarget = Math.toDegrees(Math.atan2(relativePos.f_82481_, relativePos.f_82479_)) - 90.0;
                double rotatedAngle = Math.toRadians(angleToTarget - (double)playerYaw - 90.0);
                double displayDist = distance / (double)radarDisplayRange * ((double)radarSize / 2.0 - 4.0);
                displayDist = Math.min(displayDist, (double)radarSize / 2.0 - 4.0);
                int targetX = radarCenterX + (int)(Math.cos(rotatedAngle) * displayDist);
                int targetY = radarCenterY + (int)(Math.sin(rotatedAngle) * displayDist);
                float targetAngle = (float)(Math.toDegrees(rotatedAngle) + 90.0) % 360.0f;
                float angleDiff = Math.abs(RadarHud.normalizeAngle(targetAngle - sweepAngle));
                if (angleDiff < 5.0f && !targetDetectionTime.containsKey(targetPos)) {
                    targetDetectionTime.put(targetPos, currentTime);
                }
                if (!targetDetectionTime.containsKey(targetPos)) continue;
                long detectionTime = targetDetectionTime.get(targetPos);
                long timeSinceDetection = currentTime - detectionTime;
                float alpha = 1.0f;
                if (timeSinceDetection < 1000L) {
                    alpha = 1.0f;
                    if (timeSinceDetection < 1000L) {
                        float pulse = (float)(Math.sin((double)timeSinceDetection * 0.01) * 0.3 + 0.7);
                        alpha *= pulse;
                    }
                } else {
                    if (timeSinceDetection >= 2000L) continue;
                    alpha = 1.0f - (float)(timeSinceDetection - 1000L) / 1000.0f;
                }
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                int targetSize = 3;
                guiGraphics.m_280163_(RADAR_TARGET, targetX - targetSize / 2, targetY - targetSize / 2, 0.0f, 0.0f, targetSize, targetSize, targetSize, targetSize);
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableBlend();
        }
    };

    private static float normalizeAngle(float angle) {
        if ((angle %= 360.0f) < 0.0f) {
            angle += 360.0f;
        }
        if (angle > 180.0f) {
            angle = 360.0f - angle;
        }
        return angle;
    }

    private static boolean isRadarHelicopter(Entity vehicle) {
        String vehicleClassName = vehicle.getClass().getSimpleName();
        return SUPPORTED_HELICOPTERS.contains(vehicleClassName);
    }
}

