/*
 * Decompiled with CFR 0.152.
 */
package tech.vvp.vvp.entity.vehicle;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.entity.OBBEntity;
import com.atsuishio.superbwarfare.entity.projectile.ProjectileEntity;
import com.atsuishio.superbwarfare.entity.projectile.SmallCannonShellEntity;
import com.atsuishio.superbwarfare.entity.projectile.WgMissileEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.ContainerMobileVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.LandArmorEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.ThirdPersonCameraPosition;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.WeaponVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.damage.DamageModifier;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.ProjectileWeapon;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.SmallCannonShellWeapon;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.VehicleWeapon;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.WgMissileWeapon;
import com.atsuishio.superbwarfare.event.ClientMouseHandler;
import com.atsuishio.superbwarfare.network.message.receive.ShakeClientMessage;
import com.atsuishio.superbwarfare.tools.Ammo;
import com.atsuishio.superbwarfare.tools.InventoryTool;
import com.atsuishio.superbwarfare.tools.OBB;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import com.atsuishio.superbwarfare.tools.VectorTool;
import com.mojang.math.Axis;
import java.util.Comparator;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.PlayMessages;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;
import tech.vvp.vvp.VVP;
import tech.vvp.vvp.config.server.ExplosionConfigVVP;
import tech.vvp.vvp.config.server.VehicleConfigVVP;
import tech.vvp.vvp.init.ModEntities;
import tech.vvp.vvp.init.ModItems;
import tech.vvp.vvp.init.ModSounds;

public class BradleyUkrEntity
extends ContainerMobileVehicleEntity
implements GeoEntity,
LandArmorEntity,
WeaponVehicleEntity,
OBBEntity {
    public static final EntityDataAccessor<Integer> LOADED_AP = SynchedEntityData.m_135353_(BradleyUkrEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> LOADED_MISSILE = SynchedEntityData.m_135353_(BradleyUkrEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> MISSILE_COUNT = SynchedEntityData.m_135353_(BradleyUkrEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> CURRENT_MISSILE = SynchedEntityData.m_135353_(BradleyUkrEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Boolean> HAS_MANGAL = SynchedEntityData.m_135353_(BradleyUkrEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> HAS_FOLIAGE = SynchedEntityData.m_135353_(BradleyUkrEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> HAS_FOLIAGE_BODY = SynchedEntityData.m_135353_(BradleyUkrEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> KOROBKI = SynchedEntityData.m_135353_(BradleyUkrEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> CAMOUFLAGE_TYPE = SynchedEntityData.m_135353_(BradleyUkrEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> MISSILE_FIRE_COOLDOWN = SynchedEntityData.m_135353_(BradleyUkrEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public OBB obb1;
    public OBB obb2;
    public OBB obb3;
    public OBB obb4;
    public OBB obbTurret;
    public OBB obbMangal;

    public BradleyUkrEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<BradleyUkrEntity>)((EntityType)ModEntities.BRADLEY_UKR.get()), world);
    }

    public BradleyUkrEntity(EntityType<BradleyUkrEntity> type, Level world) {
        super(type, world);
        this.m_274367_(1.5f);
        this.obb1 = new OBB(this.m_20182_().m_252839_(), new Vector3f(2.3125f, 0.625f, 3.09375f), new Quaternionf(), OBB.Part.BODY);
        this.obb2 = new OBB(this.m_20182_().m_252839_(), new Vector3f(2.3125f, 0.625f, 0.6875f), new Quaternionf(), OBB.Part.BODY);
        this.obb3 = new OBB(this.m_20182_().m_252839_(), new Vector3f(0.4375f, 0.625f, 3.21875f), new Quaternionf(), OBB.Part.WHEEL_LEFT);
        this.obb4 = new OBB(this.m_20182_().m_252839_(), new Vector3f(0.4375f, 0.625f, 3.21875f), new Quaternionf(), OBB.Part.WHEEL_RIGHT);
        this.obbTurret = new OBB(this.m_20182_().m_252839_(), new Vector3f(1.406f, 0.469f, 1.688f), new Quaternionf(), OBB.Part.TURRET);
        this.obbMangal = new OBB(this.m_20182_().m_252839_(), new Vector3f(1.906f, 0.094f, 1.594f), new Quaternionf(), OBB.Part.EMPTY);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 100.0).m_22268_(Attributes.f_22279_, 1.0).m_22268_(Attributes.f_22278_, 0.8).m_22268_(Attributes.f_22284_, 10.0).m_22268_(Attributes.f_22285_, 5.0);
    }

    public static BradleyUkrEntity clientSpawn(PlayMessages.SpawnEntity packet, Level world) {
        EntityType entityTypeFromPacket = (EntityType)BuiltInRegistries.f_256780_.m_7942_(packet.getTypeId());
        if (entityTypeFromPacket == null) {
            Mod.LOGGER.error("Failed to create entity from packet: Unknown entity type id: " + packet.getTypeId());
            return null;
        }
        if (!(entityTypeFromPacket instanceof EntityType)) {
            Mod.LOGGER.error("Retrieved EntityType is not an instance of EntityType<?> for id: " + packet.getTypeId());
            return null;
        }
        EntityType castedEntityType = entityTypeFromPacket;
        BradleyUkrEntity entity = new BradleyUkrEntity((EntityType<BradleyUkrEntity>)castedEntityType, world);
        return entity;
    }

    public VehicleWeapon[][] initWeapons() {
        return new VehicleWeapon[][]{{new SmallCannonShellWeapon().damage((float)((Integer)VehicleConfigVVP.BRADLEY_CANNON_DAMAGE.get()).intValue()).explosionDamage((float)((Integer)VehicleConfigVVP.BRADLEY_CANNON_EXPLOSION_DAMAGE.get()).intValue()).explosionRadius(((Double)VehicleConfigVVP.BRADLEY_CANNON_EXPLOSION_RADIUS.get()).floatValue()).sound((SoundEvent)com.atsuishio.superbwarfare.init.ModSounds.INTO_MISSILE.get()).icon(Mod.loc((String)"textures/screens/vehicle_weapon/cannon_30mm.png")).sound1p((SoundEvent)ModSounds.BUSHMASTER_1P.get()).sound3p((SoundEvent)ModSounds.BUSHMASTER_3P.get()).sound3pFar((SoundEvent)ModSounds.BUSHMASTER_FAR.get()).sound3pVeryFar((SoundEvent)ModSounds.BUSHMASTER_VERYFAR.get()), new ProjectileWeapon().damage(6.5f).headShot(2.0f).zoom(false).sound((SoundEvent)com.atsuishio.superbwarfare.init.ModSounds.INTO_CANNON.get()).icon(Mod.loc((String)"textures/screens/vehicle_weapon/gun_7_62mm.png")).sound1p((SoundEvent)com.atsuishio.superbwarfare.init.ModSounds.COAX_FIRE_1P.get()).sound3p((SoundEvent)com.atsuishio.superbwarfare.init.ModSounds.M_60_FIRE_3P.get()).sound3pFar((SoundEvent)com.atsuishio.superbwarfare.init.ModSounds.M_60_FAR.get()).sound3pVeryFar((SoundEvent)com.atsuishio.superbwarfare.init.ModSounds.M_60_VERYFAR.get()), new WgMissileWeapon().damage((float)((Integer)ExplosionConfigVVP.TOW_MISSILE_DAMAGE.get()).intValue()).explosionDamage((float)((Integer)ExplosionConfigVVP.TOW_MISSILE_EXPLOSION_DAMAGE.get()).intValue()).explosionRadius((float)((Integer)ExplosionConfigVVP.TOW_MISSILE_EXPLOSION_RADIUS.get()).intValue()).sound((SoundEvent)com.atsuishio.superbwarfare.init.ModSounds.INTO_MISSILE.get()).sound1p((SoundEvent)ModSounds.TOW_1P.get()).sound3p((SoundEvent)ModSounds.TOW_1P.get()).sound3pFar((SoundEvent)ModSounds.TOW_FAR.get())}};
    }

    public ThirdPersonCameraPosition getThirdPersonCameraPosition(int index) {
        return new ThirdPersonCameraPosition(2.75 + ClientMouseHandler.custom3pDistanceLerp, 1.0, 0.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(LOADED_AP, (Object)0);
        this.f_19804_.m_135372_(LOADED_MISSILE, (Object)0);
        this.f_19804_.m_135372_(MISSILE_COUNT, (Object)0);
        this.f_19804_.m_135372_(CURRENT_MISSILE, (Object)0);
        this.f_19804_.m_135372_(HAS_MANGAL, (Object)false);
        this.f_19804_.m_135372_(HAS_FOLIAGE, (Object)false);
        this.f_19804_.m_135372_(HAS_FOLIAGE_BODY, (Object)false);
        this.f_19804_.m_135372_(KOROBKI, (Object)false);
        this.f_19804_.m_135372_(CAMOUFLAGE_TYPE, (Object)0);
        this.f_19804_.m_135372_(MISSILE_FIRE_COOLDOWN, (Object)0);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("loaded_ap", ((Integer)this.f_19804_.m_135370_(LOADED_AP)).intValue());
        compound.m_128405_("LoadedMissile", ((Integer)this.f_19804_.m_135370_(LOADED_MISSILE)).intValue());
        compound.m_128379_("HasMangal", ((Boolean)this.f_19804_.m_135370_(HAS_MANGAL)).booleanValue());
        compound.m_128379_("HasFoliage", ((Boolean)this.f_19804_.m_135370_(HAS_FOLIAGE)).booleanValue());
        compound.m_128379_("HasFoliageBody", ((Boolean)this.f_19804_.m_135370_(HAS_FOLIAGE_BODY)).booleanValue());
        compound.m_128379_("Korobki", ((Boolean)this.f_19804_.m_135370_(KOROBKI)).booleanValue());
        compound.m_128405_("CamouflageType", ((Integer)this.f_19804_.m_135370_(CAMOUFLAGE_TYPE)).intValue());
        compound.m_128405_("MissileFireCooldown", ((Integer)this.f_19804_.m_135370_(MISSILE_FIRE_COOLDOWN)).intValue());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.f_19804_.m_135381_(LOADED_AP, (Object)compound.m_128451_("loaded_ap"));
        this.f_19804_.m_135381_(LOADED_MISSILE, (Object)compound.m_128451_("LoadedMissile"));
        this.f_19804_.m_135381_(HAS_MANGAL, (Object)compound.m_128471_("HasMangal"));
        this.f_19804_.m_135381_(HAS_FOLIAGE_BODY, (Object)compound.m_128471_("HasFoliageBody"));
        this.f_19804_.m_135381_(KOROBKI, (Object)compound.m_128471_("Korobki"));
        this.f_19804_.m_135381_(CAMOUFLAGE_TYPE, (Object)compound.m_128451_("CamouflageType"));
        this.f_19804_.m_135381_(MISSILE_FIRE_COOLDOWN, (Object)compound.m_128451_("MissileFireCooldown"));
    }

    @ParametersAreNonnullByDefault
    protected void m_7355_(BlockPos pPos, BlockState pState) {
        this.m_5496_((SoundEvent)com.atsuishio.superbwarfare.init.ModSounds.WHEEL_STEP.get(), (float)(this.m_20184_().m_82553_() * 0.3), this.f_19796_.m_188501_() * 0.15f + 1.05f);
    }

    public DamageModifier getDamageModifier() {
        return super.getDamageModifier().custom((source, damage) -> Float.valueOf(this.getSourceAngle((DamageSource)source, 0.25f) * damage.floatValue()));
    }

    public void m_6075_() {
        this.turretYRotO = this.getTurretYRot();
        this.turretXRotO = this.getTurretXRot();
        this.rudderRotO = this.getRudderRot();
        this.leftWheelRotO = this.getLeftWheelRot();
        this.rightWheelRotO = this.getRightWheelRot();
        super.m_6075_();
        this.updateOBB();
        if (this.m_9236_() instanceof ServerLevel) {
            int missileCooldown;
            if (this.reloadCoolDown > 0) {
                --this.reloadCoolDown;
            }
            if ((missileCooldown = ((Integer)this.f_19804_.m_135370_(MISSILE_FIRE_COOLDOWN)).intValue()) > 0) {
                this.f_19804_.m_135381_(MISSILE_FIRE_COOLDOWN, (Object)(missileCooldown - 1));
            }
            this.handleAmmo();
        }
        double fluidFloat = 0.052 * BradleyUkrEntity.getSubmergedHeight((Entity)this);
        this.m_20256_(this.m_20184_().m_82520_(0.0, fluidFloat, 0.0));
        if (this.m_20096_()) {
            float f0 = 0.54f + 0.25f * Mth.m_14154_((float)(90.0f - (float)BradleyUkrEntity.calculateAngle((Vec3)this.m_20184_(), (Vec3)this.m_20252_(1.0f)))) / 90.0f;
            this.m_20256_(this.m_20184_().m_82549_(this.m_20252_(1.0f).m_82541_().m_82490_(0.05 * this.m_20184_().m_82526_(this.m_20252_(1.0f)))));
            this.m_20256_(this.m_20184_().m_82542_((double)f0, 0.99, (double)f0));
        } else if (this.m_20069_()) {
            float f1 = 0.74f + 0.09f * Mth.m_14154_((float)(90.0f - (float)BradleyUkrEntity.calculateAngle((Vec3)this.m_20184_(), (Vec3)this.m_20252_(1.0f)))) / 90.0f;
            this.m_20256_(this.m_20184_().m_82549_(this.m_20252_(1.0f).m_82541_().m_82490_(0.04 * this.m_20184_().m_82526_(this.m_20252_(1.0f)))));
            this.m_20256_(this.m_20184_().m_82542_((double)f1, 0.85, (double)f1));
        } else {
            this.m_20256_(this.m_20184_().m_82542_(0.99, 0.99, 0.99));
        }
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.m_20069_() && this.m_20184_().m_82553_() > 0.1) {
                ParticleTool.sendParticle((ServerLevel)serverLevel, (ParticleOptions)ParticleTypes.f_123796_, (double)(this.m_20185_() + 0.5 * this.m_20184_().f_82479_), (double)(this.m_20186_() + BradleyUkrEntity.getSubmergedHeight((Entity)this) - 0.2), (double)(this.m_20189_() + 0.5 * this.m_20184_().f_82481_), (int)((int)(2.0 + 4.0 * this.m_20184_().m_82553_())), (double)0.65, (double)0.0, (double)0.65, (double)0.0, (boolean)true);
                ParticleTool.sendParticle((ServerLevel)serverLevel, (ParticleOptions)ParticleTypes.f_123774_, (double)(this.m_20185_() + 0.5 * this.m_20184_().f_82479_), (double)(this.m_20186_() + BradleyUkrEntity.getSubmergedHeight((Entity)this) - 0.2), (double)(this.m_20189_() + 0.5 * this.m_20184_().f_82481_), (int)((int)(2.0 + 10.0 * this.m_20184_().m_82553_())), (double)0.65, (double)0.0, (double)0.65, (double)0.0, (boolean)true);
            }
        }
        this.turretAngle(3.0f, 4.7f);
        this.lowHealthWarning();
        this.terrainCompact(2.7f, 3.61f);
        this.inertiaRotate(1.25f);
        this.releaseSmokeDecoy(this.getTurretVector(1.0f));
        this.m_6210_();
    }

    public boolean canCollideHardBlock() {
        return this.m_20184_().m_165924_() > 0.09 || (double)Mth.m_14154_((float)((Float)this.f_19804_.m_135370_(POWER)).floatValue()) > 0.15;
    }

    private void handleAmmo() {
        Entity entity = this.m_146895_();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        int ammoCount = this.m_213659_().stream().filter(stack -> {
            if (stack.m_150930_((Item)com.atsuishio.superbwarfare.init.ModItems.AMMO_BOX.get())) {
                return Ammo.RIFLE.get(stack) > 0;
            }
            return false;
        }).mapToInt(arg_0 -> ((Ammo)Ammo.RIFLE).get(arg_0)).sum() + this.m_18947_((Item)com.atsuishio.superbwarfare.init.ModItems.RIFLE_AMMO.get());
        if ((this.hasItem((Item)com.atsuishio.superbwarfare.init.ModItems.WIRE_GUIDE_MISSILE.get()) || InventoryTool.hasCreativeAmmoBox((Entity)player)) && this.reloadCoolDown <= 0 && (Integer)this.m_20088_().m_135370_(LOADED_MISSILE) < 2) {
            this.f_19804_.m_135381_(LOADED_MISSILE, (Object)((Integer)this.f_19804_.m_135370_(LOADED_MISSILE) + 1));
            this.reloadCoolDown = 160;
            if (!InventoryTool.hasCreativeAmmoBox((Entity)player)) {
                this.m_213659_().stream().filter(stack -> stack.m_150930_((Item)com.atsuishio.superbwarfare.init.ModItems.WIRE_GUIDE_MISSILE.get())).findFirst().ifPresent(stack -> stack.m_41774_(1));
            }
            this.m_9236_().m_6269_(null, (Entity)this, (SoundEvent)ModSounds.TOW_RELOAD.get(), this.m_5720_(), 1.0f, 1.0f);
        }
        if (this.getWeaponIndex(0) == 0) {
            this.f_19804_.m_135381_(AMMO, (Object)this.m_18947_((Item)com.atsuishio.superbwarfare.init.ModItems.SMALL_SHELL.get()));
        } else if (this.getWeaponIndex(0) == 1) {
            this.f_19804_.m_135381_(AMMO, (Object)ammoCount);
        } else if (this.getWeaponIndex(0) == 2) {
            this.f_19804_.m_135381_(AMMO, (Object)((Integer)this.m_20088_().m_135370_(LOADED_MISSILE)));
        }
        this.f_19804_.m_135381_(MISSILE_COUNT, (Object)this.m_18947_((Item)com.atsuishio.superbwarfare.init.ModItems.WIRE_GUIDE_MISSILE.get()));
    }

    public Vec3 getBarrelVector(float pPartialTicks) {
        Matrix4f transform = this.getBarrelTransform(pPartialTicks);
        Vector4f rootPosition = this.transformPosition(transform, 0.0f, 0.0f, 0.0f);
        Vector4f targetPosition = this.transformPosition(transform, 0.0f, 0.0f, 1.0f);
        return new Vec3((double)rootPosition.x, (double)rootPosition.y, (double)rootPosition.z).m_82505_(new Vec3((double)targetPosition.x, (double)targetPosition.y, (double)targetPosition.z));
    }

    public void vehicleShoot(Player player, int type) {
        boolean hasCreativeAmmo = false;
        for (int i = 0; i < this.getMaxPassengers() - 1; ++i) {
            Player pPlayer;
            Entity entity = this.getNthEntity(i);
            if (!(entity instanceof Player) || !InventoryTool.hasCreativeAmmoBox((Entity)(pPlayer = (Player)entity))) continue;
            hasCreativeAmmo = true;
        }
        Matrix4f transform = this.getBarrelTransform(1.0f);
        if (this.getWeaponIndex(0) == 0) {
            if (this.cannotFire) {
                return;
            }
            float x = -0.1f;
            float y = -0.5f;
            float z = 2.5f;
            Vector4f worldPosition = this.transformPosition(transform, x, y, z);
            SmallCannonShellEntity smallCannonShell = ((SmallCannonShellWeapon)this.getWeapon(0)).create((LivingEntity)player);
            smallCannonShell.m_6034_((double)worldPosition.x - 1.1 * this.m_20184_().f_82479_, (double)worldPosition.y, (double)worldPosition.z - 1.1 * this.m_20184_().f_82481_);
            Vec3 barrelVec = this.getBarrelVector(1.0f);
            smallCannonShell.m_6686_(barrelVec.f_82479_, barrelVec.f_82480_, barrelVec.f_82481_, 35.0f, 0.2f);
            this.m_9236_().m_7967_((Entity)smallCannonShell);
            ParticleTool.sendParticle((ServerLevel)((ServerLevel)this.m_9236_()), (ParticleOptions)ParticleTypes.f_123755_, (double)((double)worldPosition.x - 1.1 * this.m_20184_().f_82479_), (double)worldPosition.y, (double)((double)worldPosition.z - 1.1 * this.m_20184_().f_82481_), (int)1, (double)0.02, (double)0.02, (double)0.02, (double)0.0, (boolean)false);
            if (!player.m_9236_().f_46443_) {
                this.playShootSound3p(player, 0, 4, 12, 24);
            }
            Level level = player.m_9236_();
            Vec3 center = new Vec3(this.m_20185_(), this.m_20188_(), this.m_20189_());
            for (Entity target : level.m_45976_(Entity.class, new AABB(center, center).m_82400_(4.0)).stream().sorted(Comparator.comparingDouble(e -> e.m_20238_(center))).toList()) {
                if (!(target instanceof ServerPlayer)) continue;
                ServerPlayer serverPlayer = (ServerPlayer)target;
                Mod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new ShakeClientMessage(6.0, 5.0, 9.0, this.m_20185_(), this.m_20188_(), this.m_20189_()));
            }
            this.f_19804_.m_135381_(CANNON_RECOIL_TIME, (Object)40);
            this.f_19804_.m_135381_(YAW, (Object)Float.valueOf(this.getTurretYRot()));
            this.f_19804_.m_135381_(HEAT, (Object)((Integer)this.f_19804_.m_135370_(HEAT) + 2));
            this.f_19804_.m_135381_(FIRE_ANIM, (Object)3);
            if (hasCreativeAmmo) {
                return;
            }
            this.m_213659_().stream().filter(stack -> stack.m_150930_((Item)com.atsuishio.superbwarfare.init.ModItems.SMALL_SHELL.get())).findFirst().ifPresent(stack -> stack.m_41774_(1));
        } else if (this.getWeaponIndex(0) == 1) {
            if (this.cannotFireCoax) {
                return;
            }
            float x = -0.65f;
            float y = -0.4f;
            float z = 1.3f;
            Vector4f worldPosition = this.transformPosition(transform, x, y, z);
            if ((Integer)this.f_19804_.m_135370_(AMMO) > 0 || hasCreativeAmmo) {
                ProjectileEntity projectileRight = ((ProjectileWeapon)this.getWeapon(0)).create((LivingEntity)player).setGunItemId(this.m_6095_().m_20675_());
                projectileRight.bypassArmorRate(0.2f);
                projectileRight.m_6034_((double)worldPosition.x - 1.1 * this.m_20184_().f_82479_, (double)worldPosition.y, (double)worldPosition.z - 1.1 * this.m_20184_().f_82481_);
                projectileRight.shoot(player, this.getBarrelVector((float)1.0f).f_82479_, this.getBarrelVector((float)1.0f).f_82480_ + (double)0.002f, this.getBarrelVector((float)1.0f).f_82481_, 36.0f, 0.25f);
                this.m_9236_().m_7967_((Entity)projectileRight);
                if (!hasCreativeAmmo) {
                    ItemStack ammoBox = this.m_213659_().stream().filter(stack -> {
                        if (stack.m_150930_((Item)com.atsuishio.superbwarfare.init.ModItems.AMMO_BOX.get())) {
                            return Ammo.RIFLE.get(stack) > 0;
                        }
                        return false;
                    }).findFirst().orElse(ItemStack.f_41583_);
                    if (!ammoBox.m_41619_()) {
                        Ammo.RIFLE.add(ammoBox, -1);
                    } else {
                        this.m_213659_().stream().filter(stack -> stack.m_150930_((Item)com.atsuishio.superbwarfare.init.ModItems.RIFLE_AMMO.get())).findFirst().ifPresent(stack -> stack.m_41774_(1));
                    }
                }
            }
            this.f_19804_.m_135381_(COAX_HEAT, (Object)((Integer)this.f_19804_.m_135370_(COAX_HEAT) + 3));
            this.f_19804_.m_135381_(FIRE_ANIM, (Object)2);
            if (!player.m_9236_().f_46443_) {
                this.playShootSound3p(player, 0, 3, 6, 12);
            }
        } else if (this.getWeaponIndex(0) == 2 && (Integer)this.m_20088_().m_135370_(LOADED_MISSILE) > 0) {
            if ((Integer)this.f_19804_.m_135370_(MISSILE_FIRE_COOLDOWN) > 0) {
                return;
            }
            int currentMissile = (Integer)this.f_19804_.m_135370_(CURRENT_MISSILE);
            boolean isTopSide = currentMissile % 2 == 0;
            float x = 1.183f;
            float y = isTopSide ? 0.2f : 0.0f;
            float z = 0.448f;
            Matrix4f transformT = this.getBarrelTransform(1.0f);
            Vector4f worldPosition = this.transformPosition(transformT, x, y, z);
            WgMissileEntity wgMissileEntity = ((WgMissileWeapon)this.getWeapon(0)).create((LivingEntity)player);
            wgMissileEntity.m_6034_((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
            wgMissileEntity.m_6686_(this.getBarrelVector((float)1.0f).f_82479_, this.getBarrelVector((float)1.0f).f_82480_, this.getBarrelVector((float)1.0f).f_82481_, 2.0f, 0.0f);
            player.m_9236_().m_7967_((Entity)wgMissileEntity);
            if (!player.m_9236_().f_46443_) {
                this.playShootSound3p(player, 0, 6, 0, 0);
            }
            this.f_19804_.m_135381_(CURRENT_MISSILE, (Object)((currentMissile + 1) % 4));
            this.f_19804_.m_135381_(LOADED_MISSILE, (Object)((Integer)this.f_19804_.m_135370_(LOADED_MISSILE) - 1));
            this.f_19804_.m_135381_(MISSILE_FIRE_COOLDOWN, (Object)40);
            this.reloadCoolDown = 160;
        }
    }

    public void travel() {
        this.trackEngine(true, 0.052, (Integer)VehicleConfigVVP.BRADLEY_ENERGY_COST.get(), 0.55, 0.5, 1.9, 0.8, 0.21f, -0.16f, 0.0024f, 0.0024f, 0.1f);
    }

    public SoundEvent getEngineSound() {
        return (SoundEvent)com.atsuishio.superbwarfare.init.ModSounds.BMP_ENGINE.get();
    }

    public float getEngineSoundVolume() {
        return Mth.m_14154_((float)((Float)this.f_19804_.m_135370_(POWER)).floatValue()) * 8.0f;
    }

    public void m_19956_(@NotNull Entity passenger, @NotNull Entity.MoveFunction callback) {
        if (!this.m_20363_(passenger)) {
            return;
        }
        Matrix4f transform = this.getTurretTransform(1.0f);
        Matrix4f transformV = this.getVehicleTransform(1.0f);
        int i = this.getSeatIndex(passenger);
        Vector4f worldPosition = i == 0 ? this.transformPosition(transform, 0.0f, 0.0f, 0.0f) : this.transformPosition(transformV, 0.0f, 1.0f, 0.0f);
        passenger.m_6034_((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
        callback.m_20372_(passenger, (double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
        this.copyEntityData(passenger);
    }

    public void copyEntityData(Entity entity) {
        if (entity == this.getNthEntity(0)) {
            entity.m_5618_(this.getBarrelYRot(1.0f));
        }
    }

    public int getMaxPassengers() {
        return 7;
    }

    public Vec3 driverZoomPos(float ticks) {
        Matrix4f transform = this.getTurretTransform(ticks);
        Vector4f worldPosition = this.transformPosition(transform, 0.3f, 0.75f, 0.56f);
        return new Vec3((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
    }

    public Matrix4f getBarrelTransform(float ticks) {
        Matrix4f transformT = this.getTurretTransform(ticks);
        Matrix4f transform = new Matrix4f();
        Vector4f worldPosition = this.transformPosition(transform, 0.0234375f, 0.33795f, 0.825f);
        transformT.translate(worldPosition.x, worldPosition.y, worldPosition.z);
        float a = this.getTurretYaw(ticks);
        float r = (Mth.m_14154_((float)a) - 90.0f) / 90.0f;
        float r2 = Mth.m_14154_((float)a) <= 90.0f ? a / 90.0f : (a < 0.0f ? -(180.0f + a) / 90.0f : (180.0f - a) / 90.0f);
        float x = Mth.m_14179_((float)ticks, (float)this.turretXRotO, (float)this.getTurretXRot());
        float xV = Mth.m_14179_((float)ticks, (float)this.f_19860_, (float)this.m_146909_());
        float z = Mth.m_14179_((float)ticks, (float)this.prevRoll, (float)this.getRoll());
        transformT.rotate((Quaternionfc)Axis.f_252529_.m_252977_(x + r * xV + r2 * z));
        return transformT;
    }

    public Vec3 getTurretVector(float pPartialTicks) {
        Matrix4f transform = this.getTurretTransform(pPartialTicks);
        Vector4f rootPosition = this.transformPosition(transform, 0.0f, 0.0f, 0.0f);
        Vector4f targetPosition = this.transformPosition(transform, 0.0f, 0.0f, 1.0f);
        return new Vec3((double)rootPosition.x, (double)rootPosition.y, (double)rootPosition.z).m_82505_(new Vec3((double)targetPosition.x, (double)targetPosition.y, (double)targetPosition.z));
    }

    public Matrix4f getTurretTransform(float ticks) {
        Matrix4f transformV = this.getVehicleTransform(ticks);
        Matrix4f transform = new Matrix4f();
        Vector4f worldPosition = this.transformPosition(transform, -0.219f, 3.094f, -0.625f);
        transformV.translate(worldPosition.x, worldPosition.y, worldPosition.z);
        transformV.rotate((Quaternionfc)Axis.f_252436_.m_252977_(Mth.m_14179_((float)ticks, (float)this.turretYRotO, (float)this.getTurretYRot())));
        return transformV;
    }

    protected void clampRotation(Entity entity) {
        float a = this.getTurretYaw(1.0f);
        float r = (Mth.m_14154_((float)a) - 90.0f) / 90.0f;
        float r2 = Mth.m_14154_((float)a) <= 90.0f ? a / 90.0f : (a < 0.0f ? -(180.0f + a) / 90.0f : (180.0f - a) / 90.0f);
        float min = -32.5f - r * this.m_146909_() - r2 * this.getRoll();
        float max = 15.0f - r * this.m_146909_() - r2 * this.getRoll();
        float f = Mth.m_14177_((float)entity.m_146909_());
        float f1 = Mth.m_14036_((float)f, (float)min, (float)max);
        entity.f_19860_ += f1 - f;
        entity.m_146926_(entity.m_146909_() + f1 - f);
        entity.m_5618_(this.getBarrelYRot(1.0f));
    }

    public void m_7340_(@NotNull Entity entity) {
        this.clampRotation(entity);
    }

    private PlayState firePredicate(AnimationState<BradleyUkrEntity> event) {
        if ((Integer)this.f_19804_.m_135370_(FIRE_ANIM) > 1 && this.getWeaponIndex(0) == 0) {
            return event.setAndContinue(RawAnimation.begin().thenPlay("animation.lav.fire"));
        }
        if ((Integer)this.f_19804_.m_135370_(FIRE_ANIM) > 0 && this.getWeaponIndex(0) == 1) {
            return event.setAndContinue(RawAnimation.begin().thenPlay("animation.lav.fire2"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.lav.idle"));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "movement", 0, this::firePredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public int mainGunRpm(Player player) {
        if (this.getWeaponIndex(0) == 0) {
            return 235;
        }
        if (this.getWeaponIndex(0) == 1) {
            return 700;
        }
        return 235;
    }

    public boolean canShoot(Player player) {
        if (this.getWeaponIndex(0) == 0) {
            return ((Integer)this.f_19804_.m_135370_(AMMO) > 0 || InventoryTool.hasCreativeAmmoBox((Entity)player)) && !this.cannotFire;
        }
        if (this.getWeaponIndex(0) == 1) {
            return ((Integer)this.f_19804_.m_135370_(AMMO) > 0 || InventoryTool.hasCreativeAmmoBox((Entity)player)) && !this.cannotFireCoax;
        }
        if (this.getWeaponIndex(0) == 2) {
            return (Integer)this.f_19804_.m_135370_(LOADED_MISSILE) > 0 && (Integer)this.f_19804_.m_135370_(MISSILE_FIRE_COOLDOWN) <= 0;
        }
        return false;
    }

    public int getAmmoCount(Player player) {
        return (Integer)this.f_19804_.m_135370_(AMMO);
    }

    public boolean banHand(Player player) {
        return true;
    }

    public boolean hidePassenger(Entity entity) {
        return true;
    }

    public int zoomFov() {
        return 3;
    }

    public int getWeaponHeat(Player player) {
        if (this.getWeaponIndex(0) == 0) {
            return (Integer)this.f_19804_.m_135370_(HEAT);
        }
        if (this.getWeaponIndex(0) == 1) {
            return (Integer)this.f_19804_.m_135370_(COAX_HEAT);
        }
        return 0;
    }

    public ResourceLocation getVehicleIcon() {
        return VVP.loc("textures/vehicle_icon/bradley__icon.png");
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderFirstPersonOverlay(GuiGraphics guiGraphics, Font font, Player player, int screenWidth, int screenHeight, float scale) {
        super.renderFirstPersonOverlay(guiGraphics, font, player, screenWidth, screenHeight, scale);
        if (this.getWeaponIndex(0) == 0) {
            double heat = 1.0f - (float)((Integer)this.m_20088_().m_135370_(HEAT)).intValue() / 100.0f;
            guiGraphics.m_280614_(font, (Component)Component.m_237113_((String)("M242 25MM " + String.valueOf(InventoryTool.hasCreativeAmmoBox((Entity)player) ? "\u221e" : Integer.valueOf(this.getAmmoCount(player))))), screenWidth / 2 - 33, screenHeight - 65, Mth.m_14169_((float)((float)heat / 3.7453184f), (float)1.0f, (float)1.0f), false);
        } else if (this.getWeaponIndex(0) == 1) {
            double heat = 1.0f - (float)((Integer)this.m_20088_().m_135370_(COAX_HEAT)).intValue() / 100.0f;
            guiGraphics.m_280614_(font, (Component)Component.m_237113_((String)("7.62MM M240C " + String.valueOf(InventoryTool.hasCreativeAmmoBox((Entity)player) ? "\u221e" : Integer.valueOf(this.getAmmoCount(player))))), screenWidth / 2 - 33, screenHeight - 65, Mth.m_14169_((float)((float)heat / 3.7453184f), (float)1.0f, (float)1.0f), false);
        } else if (this.getWeaponIndex(0) == 2) {
            double heat = 1.0f - (float)((Integer)this.m_20088_().m_135370_(COAX_HEAT)).intValue() / 100.0f;
            guiGraphics.m_280614_(font, (Component)Component.m_237113_((String)("BGM-71 TOW " + String.valueOf(InventoryTool.hasCreativeAmmoBox((Entity)player) ? "\u221e" : Integer.valueOf(this.getAmmoCount(player))))), screenWidth / 2 - 33, screenHeight - 65, Mth.m_14169_((float)((float)heat / 3.7453184f), (float)1.0f, (float)1.0f), false);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderThirdPersonOverlay(GuiGraphics guiGraphics, Font font, Player player, int screenWidth, int screenHeight, float scale) {
        super.renderThirdPersonOverlay(guiGraphics, font, player, screenWidth, screenHeight, scale);
        if (this.getWeaponIndex(0) == 0) {
            double heat = (float)((Integer)this.m_20088_().m_135370_(HEAT)).intValue() / 100.0f;
            guiGraphics.m_280614_(font, (Component)Component.m_237113_((String)("M242 25MM " + String.valueOf(InventoryTool.hasCreativeAmmoBox((Entity)player) ? "\u221e" : Integer.valueOf(this.getAmmoCount(player))))), 30, -9, Mth.m_14169_((float)0.0f, (float)((float)heat), (float)1.0f), false);
        } else if (this.getWeaponIndex(0) == 1) {
            double heat2 = (float)((Integer)this.m_20088_().m_135370_(COAX_HEAT)).intValue() / 100.0f;
            guiGraphics.m_280614_(font, (Component)Component.m_237113_((String)("7.62MM M240C " + String.valueOf(InventoryTool.hasCreativeAmmoBox((Entity)player) ? "\u221e" : Integer.valueOf(this.getAmmoCount(player))))), 30, -9, Mth.m_14169_((float)0.0f, (float)((float)heat2), (float)1.0f), false);
        } else if (this.getWeaponIndex(0) == 2) {
            double heat2 = (float)((Integer)this.m_20088_().m_135370_(COAX_HEAT)).intValue() / 100.0f;
            guiGraphics.m_280614_(font, (Component)Component.m_237113_((String)("BGM-71 TOW " + String.valueOf(InventoryTool.hasCreativeAmmoBox((Entity)player) ? "\u221e" : Integer.valueOf(this.getAmmoCount(player))))), 30, -9, Mth.m_14169_((float)0.0f, (float)((float)heat2), (float)1.0f), false);
        }
    }

    public boolean hasDecoy() {
        return true;
    }

    public double getSensitivity(double original, boolean zoom, int seatIndex, boolean isOnGround) {
        return zoom ? 0.23 : 0.3;
    }

    public boolean isEnclosed(int index) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public Vec2 getCameraRotation(float partialTicks, Player player, boolean zoom, boolean isFirstPerson) {
        if (zoom || isFirstPerson) {
            if (this.getSeatIndex((Entity)player) == 0) {
                return new Vec2((float)(-BradleyUkrEntity.getYRotFromVector((Vec3)this.getBarrelVec(partialTicks))), (float)(-BradleyUkrEntity.getXRotFromVector((Vec3)this.getBarrelVec(partialTicks))));
            }
            return new Vec2(Mth.m_14179_((float)partialTicks, (float)player.f_20886_, (float)player.m_6080_()), Mth.m_14179_((float)partialTicks, (float)player.f_19860_, (float)player.m_146909_()));
        }
        return super.getCameraRotation(partialTicks, player, false, false);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vec3 getCameraPosition(float partialTicks, Player player, boolean zoom, boolean isFirstPerson) {
        if (zoom || isFirstPerson) {
            if (this.getSeatIndex((Entity)player) == 0) {
                if (zoom) {
                    return new Vec3(this.driverZoomPos((float)partialTicks).f_82479_, Mth.m_14139_((double)partialTicks, (double)(player.f_19855_ + (double)player.m_20192_()), (double)player.m_20188_()), this.driverZoomPos((float)partialTicks).f_82481_);
                }
                return new Vec3(Mth.m_14139_((double)partialTicks, (double)player.f_19854_, (double)player.m_20185_()), Mth.m_14139_((double)partialTicks, (double)(player.f_19855_ + (double)player.m_20192_()), (double)player.m_20188_()), Mth.m_14139_((double)partialTicks, (double)player.f_19856_, (double)player.m_20189_()));
            }
            return new Vec3(Mth.m_14139_((double)partialTicks, (double)player.f_19854_, (double)player.m_20185_()) - 6.0 * player.m_20252_((float)partialTicks).f_82479_, Mth.m_14139_((double)partialTicks, (double)(player.f_19855_ + (double)player.m_20192_() + 1.0), (double)(player.m_20188_() + 1.0)) - 6.0 * player.m_20252_((float)partialTicks).f_82480_, Mth.m_14139_((double)partialTicks, (double)player.f_19856_, (double)player.m_20189_()) - 6.0 * player.m_20252_((float)partialTicks).f_82481_);
        }
        return super.getCameraPosition(partialTicks, player, false, false);
    }

    @Nullable
    public ResourceLocation getVehicleItemIcon() {
        return Mod.loc((String)"textures/gui/vehicle/type/land.png");
    }

    public List<OBB> getOBBs() {
        if (((Boolean)this.f_19804_.m_135370_(HAS_MANGAL)).booleanValue()) {
            return List.of(this.obb1, this.obb2, this.obb3, this.obb4, this.obbTurret, this.obbMangal);
        }
        return List.of(this.obb1, this.obb2, this.obb3, this.obb4, this.obbTurret);
    }

    public void updateOBB() {
        Matrix4f transform = this.getVehicleTransform(1.0f);
        Vector4f worldPosition1 = this.transformPosition(transform, 0.0f, 1.9375f, -0.40625f);
        this.obb1.center().set((Vector3fc)new Vector3f(worldPosition1.x, worldPosition1.y, worldPosition1.z));
        this.obb1.setRotation(VectorTool.combineRotations((float)1.0f, (VehicleEntity)this));
        Vector4f worldPosition2 = this.transformPosition(transform, 0.0f, 1.9375f, 3.375f);
        this.obb2.center().set((Vector3fc)new Vector3f(worldPosition2.x, worldPosition2.y, worldPosition2.z));
        this.obb2.setRotation(VectorTool.combineRotations((float)1.0f, (VehicleEntity)this));
        Vector4f worldPosition3 = this.transformPosition(transform, 1.625f, 0.6875f, -0.21875f);
        this.obb3.center().set((Vector3fc)new Vector3f(worldPosition3.x, worldPosition3.y, worldPosition3.z));
        this.obb3.setRotation(VectorTool.combineRotations((float)1.0f, (VehicleEntity)this));
        Vector4f worldPosition4 = this.transformPosition(transform, -1.625f, 0.6875f, -0.21875f);
        this.obb4.center().set((Vector3fc)new Vector3f(worldPosition4.x, worldPosition4.y, worldPosition4.z));
        this.obb4.setRotation(VectorTool.combineRotations((float)1.0f, (VehicleEntity)this));
        Matrix4f transformT = this.getTurretTransform(1.0f);
        Vector4f worldPositionT = this.transformPosition(transformT, 0.0f, 0.0f, 0.0f);
        this.obbTurret.center().set((Vector3fc)new Vector3f(worldPositionT.x, worldPositionT.y, worldPositionT.z));
        this.obbTurret.setRotation(VectorTool.combineRotationsTurret((float)1.0f, (VehicleEntity)this));
        if (((Boolean)this.f_19804_.m_135370_(HAS_MANGAL)).booleanValue()) {
            Vector4f worldPositionMangal = this.transformPosition(transformT, 0.2f, 1.2f, -0.2f);
            this.obbMangal.center().set((Vector3fc)new Vector3f(worldPositionMangal.x, worldPositionMangal.y, worldPositionMangal.z));
            this.obbMangal.setRotation(VectorTool.combineRotationsTurret((float)1.0f, (VehicleEntity)this));
        }
    }

    @NotNull
    public InteractionResult m_6096_(Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_150930_((Item)ModItems.MANGAL_TURRET.get()) && !((Boolean)this.f_19804_.m_135370_(HAS_MANGAL)).booleanValue()) {
            return this.loadModule(player, stack, HAS_MANGAL, (Item)ModItems.MANGAL_TURRET.get());
        }
        if (stack.m_150930_((Item)ModItems.SETKA_TURRET.get()) && !((Boolean)this.f_19804_.m_135370_(HAS_FOLIAGE)).booleanValue()) {
            return this.loadModule(player, stack, HAS_FOLIAGE, (Item)ModItems.SETKA_TURRET.get());
        }
        if (stack.m_150930_((Item)ModItems.SETKA_BODY.get()) && !((Boolean)this.f_19804_.m_135370_(HAS_FOLIAGE_BODY)).booleanValue()) {
            return this.loadModule(player, stack, HAS_FOLIAGE_BODY, (Item)ModItems.SETKA_BODY.get());
        }
        if (stack.m_150930_((Item)ModItems.KOROBKI.get()) && !((Boolean)this.f_19804_.m_135370_(KOROBKI)).booleanValue()) {
            return this.loadModule(player, stack, KOROBKI, (Item)ModItems.KOROBKI.get());
        }
        if (stack.m_150930_((Item)ModItems.WRENCH.get())) {
            if (((Boolean)this.f_19804_.m_135370_(HAS_MANGAL)).booleanValue()) {
                return this.removeModule(player, HAS_MANGAL, (Item)ModItems.MANGAL_TURRET.get());
            }
            if (((Boolean)this.f_19804_.m_135370_(HAS_FOLIAGE)).booleanValue()) {
                return this.removeModule(player, HAS_FOLIAGE, (Item)ModItems.SETKA_TURRET.get());
            }
            if (((Boolean)this.f_19804_.m_135370_(HAS_FOLIAGE_BODY)).booleanValue()) {
                return this.removeModule(player, HAS_FOLIAGE_BODY, (Item)ModItems.SETKA_BODY.get());
            }
            if (((Boolean)this.f_19804_.m_135370_(KOROBKI)).booleanValue()) {
                return this.removeModule(player, KOROBKI, (Item)ModItems.KOROBKI.get());
            }
        }
        return super.m_6096_(player, hand);
    }

    private InteractionResult loadModule(Player player, ItemStack stack, EntityDataAccessor<Boolean> flag, Item returnItem) {
        if (!this.m_9236_().f_46443_) {
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            this.f_19804_.m_135381_(flag, (Object)true);
            this.m_9236_().m_6269_(null, (Entity)this, (SoundEvent)ModSounds.REMONT.get(), this.m_5720_(), 2.0f, 1.0f);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    private InteractionResult removeModule(Player player, EntityDataAccessor<Boolean> flag, Item returnItem) {
        if (!this.m_9236_().f_46443_) {
            this.f_19804_.m_135381_(flag, (Object)false);
            ItemStack returnedItem = new ItemStack((ItemLike)returnItem, 1);
            boolean addedToInventory = player.m_150109_().m_36054_(returnedItem);
            if (!addedToInventory) {
                ItemEntity droppedItem = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), returnedItem);
                this.m_9236_().m_7967_((Entity)droppedItem);
            }
            this.m_9236_().m_6269_(null, (Entity)this, (SoundEvent)ModSounds.REMONT.get(), this.m_5720_(), 2.0f, 1.0f);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    public float rotateYOffset() {
        return 3.5f;
    }
}

