/*
 * Decompiled with CFR 0.152.
 */
package tech.vvp.vvp.entity.vehicle;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.entity.OBBEntity;
import com.atsuishio.superbwarfare.entity.projectile.ProjectileEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.ArmedVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.ContainerMobileVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.LandArmorEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.ThirdPersonCameraPosition;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.WeaponVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.damage.DamageModifier;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.ProjectileWeapon;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.VehicleWeapon;
import com.atsuishio.superbwarfare.network.message.receive.ShakeClientMessage;
import com.atsuishio.superbwarfare.tools.Ammo;
import com.atsuishio.superbwarfare.tools.InventoryTool;
import com.atsuishio.superbwarfare.tools.OBB;
import com.atsuishio.superbwarfare.tools.VectorTool;
import com.mojang.math.Axis;
import java.util.Comparator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.PlayMessages;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;
import tech.vvp.vvp.VVP;
import tech.vvp.vvp.config.server.VehicleConfigVVP;
import tech.vvp.vvp.init.ModItems;
import tech.vvp.vvp.init.ModSounds;

public class HumveeEntity
extends ContainerMobileVehicleEntity
implements GeoEntity,
LandArmorEntity,
ArmedVehicleEntity,
WeaponVehicleEntity,
OBBEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public static final EntityDataAccessor<Integer> HEAVY_AMMO = SynchedEntityData.m_135353_(HumveeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> CANNON_FIRE_TIME = SynchedEntityData.m_135353_(HumveeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> LOADED_MISSILE = SynchedEntityData.m_135353_(HumveeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> MISSILE_COUNT = SynchedEntityData.m_135353_(HumveeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> SMOKE_DECOY = SynchedEntityData.m_135353_(HumveeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> GUN_FIRE_TIME = SynchedEntityData.m_135353_(HumveeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> MG_AMMO = SynchedEntityData.m_135353_(HumveeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> LOADED_AMMO_TYPE = SynchedEntityData.m_135353_(HumveeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Boolean> HAS_TENT_TURRET = SynchedEntityData.m_135353_(HumveeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> HAS_TENT_BODY = SynchedEntityData.m_135353_(HumveeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> CAMOUFLAGE_TYPE = SynchedEntityData.m_135353_(HumveeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private VehicleWeapon[][] weapons = this.initWeapons();
    private int reloadCoolDown;
    private int selectedSeat;
    public OBB obb;
    public OBB obb1;
    public OBB obb2;
    public OBB obb3;
    public OBB obb4;
    public OBB obb5;
    public OBB obb6;
    public OBB obb7;

    public HumveeEntity(EntityType<? extends HumveeEntity> type, Level world) {
        super(type, world);
        this.m_274367_(1.5f);
        this.obb = new OBB(this.m_20182_().m_252839_(), new Vector3f(1.438f, 0.875f, 1.219f), new Quaternionf(), OBB.Part.BODY);
        this.obb1 = new OBB(this.m_20182_().m_252839_(), new Vector3f(1.438f, 0.563f, 0.906f), new Quaternionf(), OBB.Part.BODY);
        this.obb2 = new OBB(this.m_20182_().m_252839_(), new Vector3f(1.438f, 0.25f, 0.906f), new Quaternionf(), OBB.Part.WHEEL_LEFT);
        this.obb3 = new OBB(this.m_20182_().m_252839_(), new Vector3f(0.844f, 0.375f, 1.344f), new Quaternionf(), OBB.Part.TURRET);
        this.obb4 = new OBB(this.m_20182_().m_252839_(), new Vector3f(0.25f, 0.344f, 0.375f), new Quaternionf(), OBB.Part.WHEEL_RIGHT);
        this.obb5 = new OBB(this.m_20182_().m_252839_(), new Vector3f(0.25f, 0.344f, 0.375f), new Quaternionf(), OBB.Part.WHEEL_RIGHT);
        this.obb6 = new OBB(this.m_20182_().m_252839_(), new Vector3f(0.25f, 0.344f, 0.375f), new Quaternionf(), OBB.Part.WHEEL_LEFT);
        this.obb7 = new OBB(this.m_20182_().m_252839_(), new Vector3f(0.25f, 0.344f, 0.375f), new Quaternionf(), OBB.Part.WHEEL_LEFT);
    }

    public static HumveeEntity clientSpawn(PlayMessages.SpawnEntity packet, Level world) {
        EntityType entityTypeFromPacket = (EntityType)BuiltInRegistries.f_256780_.m_7942_(packet.getTypeId());
        if (entityTypeFromPacket == null) {
            Mod.LOGGER.error("Failed to create entity from packet: Unknown entity type id: " + packet.getTypeId());
            return null;
        }
        if (!(entityTypeFromPacket instanceof EntityType)) {
            Mod.LOGGER.error("Retrieved EntityType is not an instance of EntityType<?> for id: " + packet.getTypeId());
            return null;
        }
        EntityType castedEntityType = entityTypeFromPacket;
        HumveeEntity entity = new HumveeEntity((EntityType<? extends HumveeEntity>)castedEntityType, world);
        return entity;
    }

    public VehicleWeapon[][] initWeapons() {
        return new VehicleWeapon[][]{new VehicleWeapon[0], {new ProjectileWeapon().damage((float)((Integer)VehicleConfigVVP.M2_GUN_DAMAGE.get()).intValue()).headShot(2.0f).zoom(false).bypassArmorRate(0.4f).ammo((Item)com.atsuishio.superbwarfare.init.ModItems.HEAVY_AMMO.get()).icon(Mod.loc((String)"textures/screens/vehicle_weapon/gun_12_7mm.png")).sound1p((SoundEvent)ModSounds.M2_1P.get()).sound3p((SoundEvent)ModSounds.M2_3P.get()).sound3pFar((SoundEvent)ModSounds.M2_FAR.get()).sound3pVeryFar((SoundEvent)ModSounds.M2_VERYFAR.get())}};
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "movement", 0, this::idlePredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public ResourceLocation getVehicleIcon() {
        return VVP.loc("textures/vehicle_icon/humvee_icon.png");
    }

    public ThirdPersonCameraPosition getThirdPersonCameraPosition(int index) {
        return new ThirdPersonCameraPosition(2.75, 1.0, 0.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(LOADED_AMMO_TYPE, (Object)0);
        this.f_19804_.m_135372_(MG_AMMO, (Object)0);
        this.f_19804_.m_135372_(HEAVY_AMMO, (Object)0);
        this.f_19804_.m_135372_(CANNON_FIRE_TIME, (Object)0);
        this.f_19804_.m_135372_(LOADED_MISSILE, (Object)0);
        this.f_19804_.m_135372_(MISSILE_COUNT, (Object)0);
        this.f_19804_.m_135372_(SMOKE_DECOY, (Object)2);
        this.f_19804_.m_135372_(GUN_FIRE_TIME, (Object)0);
        this.f_19804_.m_135372_(HAS_TENT_TURRET, (Object)false);
        this.f_19804_.m_135372_(HAS_TENT_BODY, (Object)false);
        this.f_19804_.m_135372_(CAMOUFLAGE_TYPE, (Object)0);
    }

    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("HasTentBody", ((Boolean)this.f_19804_.m_135370_(HAS_TENT_BODY)).booleanValue());
        compound.m_128379_("HasTentTurret", ((Boolean)this.f_19804_.m_135370_(HAS_TENT_TURRET)).booleanValue());
        compound.m_128405_("CamouflageType", ((Integer)this.f_19804_.m_135370_(CAMOUFLAGE_TYPE)).intValue());
    }

    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        this.f_19804_.m_135381_(HAS_TENT_BODY, (Object)compound.m_128471_("HasTentBody"));
        this.f_19804_.m_135381_(HAS_TENT_TURRET, (Object)compound.m_128471_("HasTentTurret"));
        this.f_19804_.m_135381_(CAMOUFLAGE_TYPE, (Object)compound.m_128451_("CamouflageType"));
    }

    protected void m_7355_(BlockPos pPos, BlockState pState) {
        this.m_5496_((SoundEvent)com.atsuishio.superbwarfare.init.ModSounds.WHEEL_STEP.get(), (float)(this.m_20184_().m_82553_() * 0.3), this.f_19796_.m_188501_() * 0.15f + 1.05f);
    }

    public DamageModifier getDamageModifier() {
        return super.getDamageModifier().custom((source, damage) -> Float.valueOf(this.getSourceAngle((DamageSource)source, 0.4f) * damage.floatValue()));
    }

    public void updateTurretRotation(Player player) {
        if (player == this.getNthEntity(1)) {
            float yaw = player.m_6080_();
            float pitch = player.m_146909_();
            this.setTurretYRot(Mth.m_14177_((float)(this.m_146908_() - yaw)));
            this.setTurretXRot(Mth.m_14036_((float)(-pitch), (float)-45.0f, (float)45.0f));
        }
    }

    public void m_6075_() {
        Entity gunner;
        this.turretYRotO = this.getTurretYRot();
        this.turretXRotO = this.getTurretXRot();
        this.rudderRotO = this.getRudderRot();
        this.leftWheelRotO = this.getLeftWheelRot();
        this.rightWheelRotO = this.getRightWheelRot();
        super.m_6075_();
        this.updateOBB();
        if ((Integer)this.f_19804_.m_135370_(GUN_FIRE_TIME) > 0) {
            this.f_19804_.m_135381_(GUN_FIRE_TIME, (Object)((Integer)this.f_19804_.m_135370_(GUN_FIRE_TIME) - 1));
        }
        if ((gunner = this.getNthEntity(1)) instanceof Player) {
            this.updateTurretRotation((Player)gunner);
        }
        if (this.m_20096_()) {
            float f0 = 0.54f + 0.25f * Mth.m_14154_((float)(90.0f - (float)HumveeEntity.calculateAngle((Vec3)this.m_20184_(), (Vec3)this.m_20252_(1.0f)))) / 90.0f;
            this.m_20256_(this.m_20184_().m_82549_(this.m_20252_(1.0f).m_82541_().m_82490_(0.05 * this.m_20184_().m_165924_())));
            this.m_20256_(this.m_20184_().m_82542_((double)f0, 0.85, (double)f0));
        } else {
            this.m_20256_(this.m_20184_().m_82542_(0.99, 0.95, 0.99));
        }
        if (this.m_9236_() instanceof ServerLevel) {
            boolean hasCreativeAmmo = false;
            for (Entity passenger : this.m_20197_()) {
                Player pPlayer;
                if (!(passenger instanceof Player) || !InventoryTool.hasCreativeAmmoBox((Entity)(pPlayer = (Player)passenger))) continue;
                hasCreativeAmmo = true;
                break;
            }
            this.handleAmmo();
        }
        this.releaseSmokeDecoy(this.getTurretVector(1.0f));
        this.lowHealthWarning();
        this.terrainCompact(2.7f, 3.61f);
        this.inertiaRotate(1.25f);
        this.m_6210_();
    }

    public boolean canCollideHardBlock() {
        return this.m_20184_().m_165924_() > 0.09 || (double)Mth.m_14154_((float)((Float)this.f_19804_.m_135370_(POWER)).floatValue()) > 0.15;
    }

    public void travel() {
        this.wheelEngine(true, 0.052, (Integer)VehicleConfigVVP.HUMVEE_ENERGY_COST.get(), 1.25, 1.5, 0.24f, -0.17f, 0.005f, 0.0024f, 0.3f);
    }

    public SoundEvent getEngineSound() {
        return (SoundEvent)ModSounds.HUMVEE_ENGINE.get();
    }

    public float getEngineSoundVolume() {
        return Math.max((float)Mth.m_14154_((float)((Float)this.f_19804_.m_135370_(POWER)).floatValue()), (float)Mth.m_14154_((float)(0.1f * ((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue()))) * 2.5f;
    }

    public void m_19956_(@NotNull Entity passenger, @NotNull Entity.MoveFunction callback) {
        if (!this.m_20363_(passenger)) {
            return;
        }
        Matrix4f transform = this.getVehicleTransform(1.0f);
        int i = this.getSeatIndex(passenger);
        Vector4f worldPosition = switch (i) {
            case 0 -> this.transformPosition(transform, 0.8f, 0.28f, 0.2f);
            case 1 -> this.transformPosition(transform, 0.0f, 1.5f, -0.3f);
            case 2 -> this.transformPosition(transform, 0.8f, 0.28f, -0.8f);
            case 3 -> this.transformPosition(transform, -0.8f, 0.28f, -0.8f);
            case 4 -> this.transformPosition(transform, -0.8f, 0.28f, 0.2f);
            default -> this.transformPosition(transform, 0.0f, 1.0f, 0.0f);
        };
        passenger.m_6034_((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
        callback.m_20372_(passenger, (double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
    }

    public int getMaxPassengers() {
        return 5;
    }

    public Matrix4f getTurretTransform(float ticks) {
        Matrix4f transformV = this.getVehicleTransform(ticks);
        Matrix4f transform = new Matrix4f();
        Vector4f worldPosition = this.transformPosition(transform, 0.044f, 2.571f, -0.098f);
        transformV.translate(worldPosition.x, worldPosition.y, worldPosition.z);
        transformV.rotate((Quaternionfc)Axis.f_252436_.m_252977_(Mth.m_14179_((float)ticks, (float)this.turretYRotO, (float)this.getTurretYRot())));
        return transformV;
    }

    public Vec3 getTurretVector(float pPartialTicks) {
        Matrix4f transform = this.getTurretTransform(pPartialTicks);
        Vector4f rootPosition = this.transformPosition(transform, 0.0f, 0.0f, 0.0f);
        Vector4f targetPosition = this.transformPosition(transform, 0.0f, 0.0f, 1.0f);
        return new Vec3((double)rootPosition.x, (double)rootPosition.y, (double)rootPosition.z).m_82505_(new Vec3((double)targetPosition.x, (double)targetPosition.y, (double)targetPosition.z));
    }

    public Matrix4f getBarrelTransform(float ticks) {
        Matrix4f transformT = this.getTurretTransform(ticks);
        Matrix4f transform = new Matrix4f();
        Vector4f worldPosition = this.transformPosition(transform, 0.3625f, 0.293125f, 1.18095f);
        transformT.translate(worldPosition.x, worldPosition.y, worldPosition.z);
        float a = this.getTurretYaw(ticks);
        float r = (Mth.m_14154_((float)a) - 90.0f) / 90.0f;
        float r2 = Mth.m_14154_((float)a) <= 90.0f ? a / 90.0f : (a < 0.0f ? -(180.0f + a) / 90.0f : (180.0f - a) / 90.0f);
        float x = Mth.m_14179_((float)ticks, (float)this.turretXRotO, (float)this.getTurretXRot());
        float xV = Mth.m_14179_((float)ticks, (float)this.f_19860_, (float)this.m_146909_());
        float z = Mth.m_14179_((float)ticks, (float)this.prevRoll, (float)this.getRoll());
        transformT.rotate((Quaternionfc)Axis.f_252529_.m_252977_(-(x + r * xV + r2 * z)));
        transformT.translate(0.3625f, 0.293125f, 1.18095f);
        return transformT;
    }

    public Vec3 getBarrelVector(float pPartialTicks) {
        Matrix4f transform = this.getBarrelTransform(pPartialTicks);
        Vector4f rootPosition = this.transformPosition(transform, 0.0f, 0.0f, 0.0f);
        Vector4f targetPosition = this.transformPosition(transform, 0.0f, 0.0f, 1.0f);
        return new Vec3((double)rootPosition.x, (double)rootPosition.y, (double)rootPosition.z).m_82505_(new Vec3((double)targetPosition.x, (double)targetPosition.y, (double)targetPosition.z));
    }

    public void m_7340_(Entity entity) {
        super.m_7340_(entity);
    }

    private PlayState idlePredicate(AnimationState<HumveeEntity> event) {
        if ((double)Mth.m_14154_((float)((float)this.m_20184_().m_165925_())) > 0.001 || (double)Mth.m_14154_((float)((Float)this.f_19804_.m_135370_(POWER)).floatValue()) > 0.05) {
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.lav.idle"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.lav.idle"));
    }

    private PlayState gunShootPredicate(AnimationState<HumveeEntity> event) {
        if ((Integer)this.f_19804_.m_135370_(GUN_FIRE_TIME) > 0) {
            return event.setAndContinue(RawAnimation.begin().thenPlayAndHold("animation.humvee.fire"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.humvee.idle"));
    }

    public int mainGunRpm(Player player) {
        return 470;
    }

    public boolean canShoot(Player player) {
        if (player == this.getNthEntity(1)) {
            return ((Integer)this.f_19804_.m_135370_(MG_AMMO) > 0 || InventoryTool.hasCreativeAmmoBox((Entity)player)) && !this.cannotFire;
        }
        return false;
    }

    public int getAmmoCount(Player player) {
        if (player == this.getNthEntity(1)) {
            return (Integer)this.f_19804_.m_135370_(MG_AMMO);
        }
        return 0;
    }

    public void vehicleShoot(Player player, int type) {
        boolean hasCreativeAmmo = false;
        for (int i = 0; i < this.getMaxPassengers() - 1; ++i) {
            Player pPlayer;
            Entity entity = this.getNthEntity(i);
            if (!(entity instanceof Player) || !InventoryTool.hasCreativeAmmoBox((Entity)(pPlayer = (Player)entity))) continue;
            hasCreativeAmmo = true;
        }
        if (type == 1) {
            if (this.cannotFire) {
                return;
            }
            Matrix4f transform = this.getBarrelTransform(1.0f);
            Vector4f worldPosition = this.transformPosition(transform, -0.8f, -0.5f, 0.1f);
            ProjectileWeapon projectile = (ProjectileWeapon)this.getWeapon(1);
            ProjectileEntity projectileEntity = projectile.create((LivingEntity)player).setGunItemId(this.m_6095_().m_20675_() + ".2");
            projectileEntity.m_6034_((double)worldPosition.x - 1.1 * this.m_20184_().f_82479_, (double)worldPosition.y, (double)worldPosition.z - 1.1 * this.m_20184_().f_82481_);
            projectileEntity.m_6686_(this.getBarrelVector((float)1.0f).f_82479_, this.getBarrelVector((float)1.0f).f_82480_ + (double)0.01f, this.getBarrelVector((float)1.0f).f_82481_, 20.0f, 0.3f);
            this.m_9236_().m_7967_((Entity)projectileEntity);
            if (!player.m_9236_().f_46443_) {
                this.playShootSound3p(player, 1, 4, 12, 24);
            }
            this.f_19804_.m_135381_(GUN_FIRE_TIME, (Object)2);
            this.f_19804_.m_135381_(HEAT, (Object)((Integer)this.f_19804_.m_135370_(HEAT) + 4));
            Level level = player.m_9236_();
            Vec3 center = new Vec3(this.m_20185_(), this.m_20188_(), this.m_20189_());
            for (Entity target : level.m_6443_(Entity.class, new AABB(center, center).m_82400_(4.0), e -> true).stream().sorted(Comparator.comparingDouble(e -> e.m_20238_(center))).toList()) {
                if (!(target instanceof ServerPlayer)) continue;
                ServerPlayer serverPlayer = (ServerPlayer)target;
                Mod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new ShakeClientMessage(6.0, 4.0, 6.0, this.m_20185_(), this.m_20188_(), this.m_20189_()));
            }
            if (hasCreativeAmmo) {
                return;
            }
            ItemStack ammoBox = this.m_213659_().stream().filter(stack -> {
                if (stack.m_150930_((Item)com.atsuishio.superbwarfare.init.ModItems.AMMO_BOX.get())) {
                    return Ammo.HEAVY.get(stack) > 0;
                }
                return false;
            }).findFirst().orElse(ItemStack.f_41583_);
            if (!ammoBox.m_41619_()) {
                Ammo.HEAVY.add(ammoBox, -1);
            } else {
                this.consumeItem(this.getWeapon((int)1).ammo, 1);
            }
        }
    }

    private void handleAmmo() {
        boolean hasCreativeAmmo = false;
        for (int i = 0; i < this.getMaxPassengers(); ++i) {
            Player pPlayer;
            Entity entity = this.getNthEntity(i);
            if (!(entity instanceof Player) || !InventoryTool.hasCreativeAmmoBox((Entity)(pPlayer = (Player)entity))) continue;
            hasCreativeAmmo = true;
        }
        if (hasCreativeAmmo) {
            this.f_19804_.m_135381_(MG_AMMO, (Object)9999);
        } else {
            int totalAmmo = 0;
            for (ItemStack stack : this.m_213659_()) {
                if (!stack.m_150930_((Item)com.atsuishio.superbwarfare.init.ModItems.AMMO_BOX.get())) continue;
                totalAmmo += Ammo.HEAVY.get(stack);
            }
            this.f_19804_.m_135381_(MG_AMMO, (Object)(totalAmmo += this.m_18947_((Item)com.atsuishio.superbwarfare.init.ModItems.HEAVY_AMMO.get())));
        }
    }

    public int zoomFov() {
        return 3;
    }

    public int getWeaponHeat(Player player) {
        return 0;
    }

    public boolean hidePassenger(Entity entity) {
        return false;
    }

    public boolean hasDecoy() {
        return true;
    }

    public double getSensitivity(double original, boolean zoom, int seatIndex, boolean isOnGround) {
        return 0.3;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public Vec2 getCameraRotation(float partialTicks, Player player, boolean zoom, boolean isFirstPerson) {
        if (isFirstPerson) {
            return new Vec2(Mth.m_14179_((float)partialTicks, (float)player.f_20886_, (float)player.m_6080_()), Mth.m_14179_((float)partialTicks, (float)player.f_19860_, (float)player.m_146909_()));
        }
        return super.getCameraRotation(partialTicks, player, false, false);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vec3 getCameraPosition(float partialTicks, Player player, boolean zoom, boolean isFirstPerson) {
        if (isFirstPerson) {
            return new Vec3(Mth.m_14139_((double)partialTicks, (double)player.f_19854_, (double)player.m_20185_()), Mth.m_14139_((double)partialTicks, (double)(player.f_19855_ + (double)player.m_20192_()), (double)player.m_20188_()), Mth.m_14139_((double)partialTicks, (double)player.f_19856_, (double)player.m_20189_()));
        }
        return super.getCameraPosition(partialTicks, player, false, false);
    }

    @Nullable
    public ResourceLocation getVehicleItemIcon() {
        return Mod.loc((String)"textures/gui/vehicle/type/land.png");
    }

    @NotNull
    public InteractionResult m_6096_(Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_150930_((Item)ModItems.TENT.get()) && !((Boolean)this.f_19804_.m_135370_(HAS_TENT_TURRET)).booleanValue()) {
            return this.loadModule(player, stack, HAS_TENT_TURRET, (Item)ModItems.TENT.get());
        }
        if (stack.m_150930_((Item)ModItems.TENT.get()) && !((Boolean)this.f_19804_.m_135370_(HAS_TENT_BODY)).booleanValue()) {
            return this.loadModule(player, stack, HAS_TENT_BODY, (Item)ModItems.TENT.get());
        }
        if (stack.m_150930_((Item)ModItems.WRENCH.get())) {
            if (((Boolean)this.f_19804_.m_135370_(HAS_TENT_TURRET)).booleanValue()) {
                return this.removeModule(player, HAS_TENT_TURRET, (Item)ModItems.TENT.get());
            }
            if (((Boolean)this.f_19804_.m_135370_(HAS_TENT_BODY)).booleanValue()) {
                return this.removeModule(player, HAS_TENT_BODY, (Item)ModItems.TENT.get());
            }
        }
        if (stack.m_150930_((Item)ModItems.SPRAY.get())) {
            if (!this.m_9236_().f_46443_) {
                int currentType = (Integer)this.f_19804_.m_135370_(CAMOUFLAGE_TYPE);
                int maxTypes = 3;
                int newType = (currentType + 1) % maxTypes;
                this.f_19804_.m_135381_(CAMOUFLAGE_TYPE, (Object)newType);
                this.m_9236_().m_6269_(null, (Entity)this, (SoundEvent)ModSounds.SPRAY.get(), this.m_5720_(), 1.0f, 1.0f);
                Level level = this.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123748_, this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), 10, 1.0, 1.0, 1.0, 0.1);
                }
                return InteractionResult.CONSUME;
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6096_(player, hand);
    }

    private InteractionResult loadModule(Player player, ItemStack stack, EntityDataAccessor<Boolean> flag, Item returnItem) {
        if (!this.m_9236_().f_46443_) {
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            this.f_19804_.m_135381_(flag, (Object)true);
            this.m_9236_().m_6269_(null, (Entity)this, (SoundEvent)ModSounds.REMONT.get(), this.m_5720_(), 2.0f, 1.0f);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    private InteractionResult removeModule(Player player, EntityDataAccessor<Boolean> flag, Item returnItem) {
        if (!this.m_9236_().f_46443_) {
            this.f_19804_.m_135381_(flag, (Object)false);
            ItemStack returnedItem = new ItemStack((ItemLike)returnItem, 1);
            boolean addedToInventory = player.m_150109_().m_36054_(returnedItem);
            if (!addedToInventory) {
                ItemEntity droppedItem = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), returnedItem);
                this.m_9236_().m_7967_((Entity)droppedItem);
            }
            this.m_9236_().m_6269_(null, (Entity)this, (SoundEvent)ModSounds.REMONT.get(), this.m_5720_(), 2.0f, 1.0f);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    public List<OBB> getOBBs() {
        if (((Boolean)this.f_19804_.m_135370_(HAS_TENT_BODY)).booleanValue()) {
            return List.of(this.obb, this.obb1, this.obb2, this.obb3, this.obb4, this.obb5, this.obb6, this.obb7);
        }
        return List.of(this.obb, this.obb2, this.obb3, this.obb4, this.obb5, this.obb6, this.obb7);
    }

    public void updateOBB() {
        Matrix4f transform = this.getVehicleTransform(1.0f);
        Vector4f worldPosition = this.transformPosition(transform, 0.0f, 1.375f, -0.031f);
        this.obb.center().set((Vector3fc)new Vector3f(worldPosition.x, worldPosition.y, worldPosition.z));
        this.obb.setRotation(VectorTool.combineRotations((float)1.0f, (VehicleEntity)this));
        if (((Boolean)this.f_19804_.m_135370_(HAS_TENT_BODY)).booleanValue()) {
            Vector4f worldPositionMangal = this.transformPosition(transform, 0.0f, 1.688f, -2.156f);
            this.obb1.center().set((Vector3fc)new Vector3f(worldPositionMangal.x, worldPositionMangal.y, worldPositionMangal.z));
            this.obb1.setRotation(VectorTool.combineRotations((float)1.0f, (VehicleEntity)this));
        }
        Vector4f worldPosition2 = this.transformPosition(transform, 0.0f, 1.375f, 2.094f);
        this.obb2.center().set((Vector3fc)new Vector3f(worldPosition2.x, worldPosition2.y, worldPosition2.z));
        this.obb2.setRotation(VectorTool.combineRotations((float)1.0f, (VehicleEntity)this));
        Matrix4f transformT = this.getVehicleTransform(1.0f);
        Vector4f worldPosition3 = this.transformPosition(transformT, 0.031f, 2.625f, -0.156f);
        this.obb3.center().set((Vector3fc)new Vector3f(worldPosition3.x, worldPosition3.y, worldPosition3.z));
        this.obb3.setRotation(VectorTool.combineRotationsTurret((float)1.0f, (VehicleEntity)this));
        Vector4f worldPosition4 = this.transformPosition(transform, 1.188f, 0.594f, 2.125f);
        this.obb4.center().set((Vector3fc)new Vector3f(worldPosition4.x, worldPosition4.y, worldPosition4.z));
        this.obb4.setRotation(VectorTool.combineRotations((float)1.0f, (VehicleEntity)this));
        Vector4f worldPosition5 = this.transformPosition(transform, 1.188f, 0.594f, -1.938f);
        this.obb5.center().set((Vector3fc)new Vector3f(worldPosition5.x, worldPosition5.y, worldPosition5.z));
        this.obb5.setRotation(VectorTool.combineRotations((float)1.0f, (VehicleEntity)this));
        Vector4f worldPosition6 = this.transformPosition(transform, -1.188f, 0.594f, 2.125f);
        this.obb6.center().set((Vector3fc)new Vector3f(worldPosition6.x, worldPosition6.y, worldPosition6.z));
        this.obb6.setRotation(VectorTool.combineRotations((float)1.0f, (VehicleEntity)this));
        Vector4f worldPosition7 = this.transformPosition(transform, -1.188f, 0.594f, -1.938f);
        this.obb7.center().set((Vector3fc)new Vector3f(worldPosition7.x, worldPosition7.y, worldPosition7.z));
        this.obb7.setRotation(VectorTool.combineRotations((float)1.0f, (VehicleEntity)this));
    }
}

