/*
 * Decompiled with CFR 0.152.
 */
package tech.vvp.vvp.entity.vehicle;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.client.RenderHelper;
import com.atsuishio.superbwarfare.config.server.VehicleConfig;
import com.atsuishio.superbwarfare.entity.OBBEntity;
import com.atsuishio.superbwarfare.entity.projectile.CannonShellEntity;
import com.atsuishio.superbwarfare.entity.projectile.ProjectileEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.ContainerMobileVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.LandArmorEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.ThirdPersonCameraPosition;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.WeaponVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.damage.DamageModifier;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.CannonShellWeapon;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.ProjectileWeapon;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.VehicleWeapon;
import com.atsuishio.superbwarfare.event.ClientMouseHandler;
import com.atsuishio.superbwarfare.tools.Ammo;
import com.atsuishio.superbwarfare.tools.InventoryTool;
import com.atsuishio.superbwarfare.tools.OBB;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import com.atsuishio.superbwarfare.tools.SoundTool;
import com.atsuishio.superbwarfare.tools.VectorTool;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.math.Axis;
import java.util.List;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundStopSoundPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.PlayMessages;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;
import tech.vvp.vvp.VVP;
import tech.vvp.vvp.config.server.VehicleConfigVVP;
import tech.vvp.vvp.init.ModEntities;
import tech.vvp.vvp.init.ModItems;
import tech.vvp.vvp.init.ModSounds;

public class M60Entity
extends ContainerMobileVehicleEntity
implements GeoEntity,
LandArmorEntity,
WeaponVehicleEntity,
OBBEntity {
    public static final EntityDataAccessor<Integer> MG_AMMO = SynchedEntityData.m_135353_(M60Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> LOADED_AP = SynchedEntityData.m_135353_(M60Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> LOADED_HE = SynchedEntityData.m_135353_(M60Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> LOADED_AMMO_TYPE = SynchedEntityData.m_135353_(M60Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> GUN_FIRE_TIME = SynchedEntityData.m_135353_(M60Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> LOADED_DRONE = SynchedEntityData.m_135353_(M60Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> CAMOUFLAGE_TYPE = SynchedEntityData.m_135353_(M60Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public int droneReloadCoolDown;
    public OBB obb = new OBB(this.m_20182_().m_252839_(), new Vector3f(1.141f, 0.688f, 2.156f), new Quaternionf(), OBB.Part.BODY);
    public OBB obb2 = new OBB(this.m_20182_().m_252839_(), new Vector3f(1.141f, 0.688f, 1.312f), new Quaternionf(), OBB.Part.ENGINE1);
    public OBB obb3 = new OBB(this.m_20182_().m_252839_(), new Vector3f(0.359f, 0.844f, 3.344f), new Quaternionf(), OBB.Part.WHEEL_LEFT);
    public OBB obb4 = new OBB(this.m_20182_().m_252839_(), new Vector3f(0.359f, 0.844f, 3.344f), new Quaternionf(), OBB.Part.WHEEL_RIGHT);
    public OBB obbTurret = new OBB(this.m_20182_().m_252839_(), new Vector3f(1.359f, 0.688f, 2.219f), new Quaternionf(), OBB.Part.TURRET);

    public M60Entity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<M60Entity>)((EntityType)ModEntities.M60.get()), world);
    }

    public M60Entity(EntityType<M60Entity> type, Level world) {
        super(type, world);
    }

    public static M60Entity clientSpawn(PlayMessages.SpawnEntity packet, Level world) {
        EntityType entityTypeFromPacket = (EntityType)BuiltInRegistries.f_256780_.m_7942_(packet.getTypeId());
        if (entityTypeFromPacket == null) {
            Mod.LOGGER.error("Failed to create entity from packet: Unknown entity type id: " + packet.getTypeId());
            return null;
        }
        if (!(entityTypeFromPacket instanceof EntityType)) {
            Mod.LOGGER.error("Retrieved EntityType is not an instance of EntityType<?> for id: " + packet.getTypeId());
            return null;
        }
        EntityType castedEntityType = entityTypeFromPacket;
        M60Entity entity = new M60Entity((EntityType<M60Entity>)castedEntityType, world);
        return entity;
    }

    public VehicleWeapon[][] initWeapons() {
        return new VehicleWeapon[][]{{new CannonShellWeapon().hitDamage((float)((Integer)VehicleConfigVVP.M60_CANNON_DAMAGE.get()).intValue()).explosionRadius(((Double)VehicleConfigVVP.M60_CANNON_EXPLOSION_RADIUS.get()).floatValue()).explosionDamage((float)((Integer)VehicleConfigVVP.M60_CANNON_EXPLOSION_DAMAGE.get()).intValue()).fireProbability(0.0f).fireTime(0).durability(100).velocity(40.0f).gravity(0.1f).sound((SoundEvent)com.atsuishio.superbwarfare.init.ModSounds.INTO_MISSILE.get()).ammo((Item)com.atsuishio.superbwarfare.init.ModItems.AP_5_INCHES.get()).icon(Mod.loc((String)"textures/screens/vehicle_weapon/ap_shell.png")).sound1p((SoundEvent)ModSounds.M1128_1P.get()).sound3p((SoundEvent)ModSounds.M1128_3P.get()).sound3pFar((SoundEvent)ModSounds.M1128_FAR.get()).sound3pVeryFar((SoundEvent)ModSounds.M1128_VERYFAR.get()), new ProjectileWeapon().damage(((Double)VehicleConfig.LAV_150_MACHINE_GUN_DAMAGE.get()).doubleValue()).headShot(2.0f).zoom(false).sound((SoundEvent)com.atsuishio.superbwarfare.init.ModSounds.INTO_CANNON.get()).icon(Mod.loc((String)"textures/screens/vehicle_weapon/gun_7_62mm.png")).sound1p((SoundEvent)com.atsuishio.superbwarfare.init.ModSounds.COAX_FIRE_1P.get()).sound3p((SoundEvent)com.atsuishio.superbwarfare.init.ModSounds.RPK_FIRE_3P.get()).sound3pFar((SoundEvent)com.atsuishio.superbwarfare.init.ModSounds.RPK_FAR.get()).sound3pVeryFar((SoundEvent)com.atsuishio.superbwarfare.init.ModSounds.RPK_VERYFAR.get())}};
    }

    public ThirdPersonCameraPosition getThirdPersonCameraPosition(int index) {
        return switch (index) {
            case 0 -> new ThirdPersonCameraPosition(5.0 + ClientMouseHandler.custom3pDistanceLerp, 1.5, -0.8669625);
            case 1 -> new ThirdPersonCameraPosition(-1.0 + 0.5 * ClientMouseHandler.custom3pDistanceLerp, 0.5, 0.0);
            default -> null;
        };
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(MG_AMMO, (Object)0);
        this.f_19804_.m_135372_(LOADED_AP, (Object)0);
        this.f_19804_.m_135372_(LOADED_HE, (Object)0);
        this.f_19804_.m_135372_(LOADED_DRONE, (Object)0);
        this.f_19804_.m_135372_(LOADED_AMMO_TYPE, (Object)0);
        this.f_19804_.m_135372_(GUN_FIRE_TIME, (Object)0);
        this.f_19804_.m_135372_(CAMOUFLAGE_TYPE, (Object)0);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("LoadedAP", ((Integer)this.f_19804_.m_135370_(LOADED_AP)).intValue());
        compound.m_128405_("LoadedHE", ((Integer)this.f_19804_.m_135370_(LOADED_HE)).intValue());
        compound.m_128405_("LoadedDrone", ((Integer)this.f_19804_.m_135370_(LOADED_DRONE)).intValue());
        compound.m_128405_("LoadedAmmoType", ((Integer)this.f_19804_.m_135370_(LOADED_AMMO_TYPE)).intValue());
        compound.m_128405_("WeaponType", this.getWeaponIndex(0));
        compound.m_128405_("PassengerWeaponType", this.getWeaponIndex(1));
        compound.m_128405_("ThirdPassengerWeaponType", this.getWeaponIndex(2));
        compound.m_128405_("CamouflageType", ((Integer)this.f_19804_.m_135370_(CAMOUFLAGE_TYPE)).intValue());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.f_19804_.m_135381_(LOADED_AP, (Object)compound.m_128451_("LoadedAP"));
        this.f_19804_.m_135381_(LOADED_HE, (Object)compound.m_128451_("LoadedHE"));
        this.f_19804_.m_135381_(LOADED_DRONE, (Object)compound.m_128451_("LoadedDrone"));
        this.f_19804_.m_135381_(LOADED_AMMO_TYPE, (Object)compound.m_128451_("LoadedAmmoType"));
        this.setWeaponIndex(0, compound.m_128451_("WeaponType"));
        this.setWeaponIndex(1, compound.m_128451_("PassengerWeaponType"));
        this.setWeaponIndex(2, compound.m_128451_("ThirdPassengerWeaponType"));
        this.f_19804_.m_135381_(CAMOUFLAGE_TYPE, (Object)compound.m_128451_("CamouflageType"));
    }

    public DamageModifier getDamageModifier() {
        return super.getDamageModifier().custom((source, damage) -> Float.valueOf(this.getSourceAngle((DamageSource)source, 0.5f) * damage.floatValue()));
    }

    protected void m_7355_(@NotNull BlockPos pPos, @NotNull BlockState pState) {
        this.m_5496_((SoundEvent)com.atsuishio.superbwarfare.init.ModSounds.WHEEL_STEP.get(), (float)(this.m_20184_().m_82553_() * 0.15), this.f_19796_.m_188501_() * 0.15f + 1.05f);
    }

    public void m_6075_() {
        Entity entity;
        super.m_6075_();
        this.updateOBB();
        if (this.getLeftTrack() < 0.0f) {
            this.setLeftTrack(80.0f);
        }
        if (this.getLeftTrack() > 80.0f) {
            this.setLeftTrack(0.0f);
        }
        if (this.getRightTrack() < 0.0f) {
            this.setRightTrack(80.0f);
        }
        if (this.getRightTrack() > 80.0f) {
            this.setRightTrack(0.0f);
        }
        if ((Integer)this.f_19804_.m_135370_(GUN_FIRE_TIME) > 0) {
            this.f_19804_.m_135381_(GUN_FIRE_TIME, (Object)((Integer)this.f_19804_.m_135370_(GUN_FIRE_TIME) - 1));
        }
        if (this.reloadCoolDown == 60 && (entity = this.m_146895_()) instanceof Player) {
            Player player = (Player)entity;
            SoundTool.playLocalSound((Player)player, (SoundEvent)((SoundEvent)ModSounds.M1128_RELOAD.get()));
        }
        if (this.m_9236_() instanceof ServerLevel) {
            boolean hasCreativeAmmo = false;
            for (int i = 0; i < this.getMaxPassengers(); ++i) {
                Player pPlayer;
                Entity entity2 = this.getNthEntity(i);
                if (!(entity2 instanceof Player) || !InventoryTool.hasCreativeAmmoBox((Entity)(pPlayer = (Player)entity2))) continue;
                hasCreativeAmmo = true;
            }
            if (this.reloadCoolDown > 0 && ((Integer)this.f_19804_.m_135370_(LOADED_AMMO_TYPE) == 0 && (hasCreativeAmmo || this.m_18947_((Item)com.atsuishio.superbwarfare.init.ModItems.AP_5_INCHES.get()) > 0) || (Integer)this.f_19804_.m_135370_(LOADED_AMMO_TYPE) == 1 && (hasCreativeAmmo || this.m_18947_((Item)com.atsuishio.superbwarfare.init.ModItems.HE_5_INCHES.get()) > 0))) {
                --this.reloadCoolDown;
            }
            this.handleAmmo();
        }
        if (this.m_20096_()) {
            float f0 = 0.54f + 0.25f * Mth.m_14154_((float)(90.0f - (float)M60Entity.calculateAngle((Vec3)this.m_20184_(), (Vec3)this.m_20252_(1.0f)))) / 90.0f;
            this.m_20256_(this.m_20184_().m_82549_(this.m_20252_(1.0f).m_82541_().m_82490_(0.05 * this.m_20184_().m_82526_(this.m_20252_(1.0f)))));
            this.m_20256_(this.m_20184_().m_82542_((double)f0, 0.99, (double)f0));
        } else {
            this.m_20256_(this.m_20184_().m_82542_(0.99, 0.99, 0.99));
        }
        if (this.m_20069_()) {
            float f1 = (float)((double)0.7f - (double)0.04f * Math.min((double)M60Entity.getSubmergedHeight((Entity)this), (double)this.m_20206_()) + (double)(0.08f * Mth.m_14154_((float)(90.0f - (float)M60Entity.calculateAngle((Vec3)this.m_20184_(), (Vec3)this.m_20252_(1.0f)))) / 90.0f));
            this.m_20256_(this.m_20184_().m_82549_(this.m_20252_(1.0f).m_82541_().m_82490_(0.04 * this.m_20184_().m_82526_(this.m_20252_(1.0f)))));
            this.m_20256_(this.m_20184_().m_82542_((double)f1, 0.85, (double)f1));
        }
        if ((entity = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)entity;
            if (this.m_20069_() && this.m_20184_().m_82553_() > 0.1) {
                ParticleTool.sendParticle((ServerLevel)serverLevel, (ParticleOptions)ParticleTypes.f_123796_, (double)(this.m_20185_() + 0.5 * this.m_20184_().f_82479_), (double)(this.m_20186_() + M60Entity.getSubmergedHeight((Entity)this) - 0.2), (double)(this.m_20189_() + 0.5 * this.m_20184_().f_82481_), (int)((int)(2.0 + 4.0 * this.m_20184_().m_82553_())), (double)0.65, (double)0.0, (double)0.65, (double)0.0, (boolean)true);
                ParticleTool.sendParticle((ServerLevel)serverLevel, (ParticleOptions)ParticleTypes.f_123774_, (double)(this.m_20185_() + 0.5 * this.m_20184_().f_82479_), (double)(this.m_20186_() + M60Entity.getSubmergedHeight((Entity)this) - 0.2), (double)(this.m_20189_() + 0.5 * this.m_20184_().f_82481_), (int)((int)(2.0 + 10.0 * this.m_20184_().m_82553_())), (double)0.65, (double)0.0, (double)0.65, (double)0.0, (boolean)true);
            }
        }
        this.turretAngle(3.0f, 3.0f);
        this.lowHealthWarning();
        this.terrainCompact(4.375f, 6.3125f);
        this.inertiaRotate(1.2f);
        this.releaseSmokeDecoy(this.getTurretVector(1.0f));
        this.m_6210_();
    }

    public boolean canCollideHardBlock() {
        return this.m_20184_().m_165924_() > 0.05 || (double)Mth.m_14154_((float)((Float)this.f_19804_.m_135370_(POWER)).floatValue()) > 0.1;
    }

    public boolean canCollideBlockBeastly() {
        return this.m_20184_().m_165924_() > 0.3;
    }

    private void handleAmmo() {
        Player pPlayer;
        boolean hasCreativeAmmo = false;
        Entity entity = this.m_146895_();
        if (entity instanceof Player && InventoryTool.hasCreativeAmmoBox((Entity)(pPlayer = (Player)entity))) {
            hasCreativeAmmo = true;
        }
        if (hasCreativeAmmo) {
            this.f_19804_.m_135381_(AMMO, (Object)9999);
        } else {
            int ammoCount = this.m_213659_().stream().filter(stack -> {
                if (stack.m_150930_((Item)com.atsuishio.superbwarfare.init.ModItems.AMMO_BOX.get())) {
                    return Ammo.RIFLE.get(stack) > 0;
                }
                return false;
            }).mapToInt(arg_0 -> ((Ammo)Ammo.RIFLE).get(arg_0)).sum() + this.m_18947_((Item)com.atsuishio.superbwarfare.init.ModItems.RIFLE_AMMO.get());
            this.f_19804_.m_135381_(AMMO, (Object)ammoCount);
        }
        if ((Integer)this.f_19804_.m_135370_(LOADED_AMMO_TYPE) == 0 && (Integer)this.f_19804_.m_135370_(LOADED_AP) == 0 && this.reloadCoolDown <= 0 && (hasCreativeAmmo || this.hasItem((Item)com.atsuishio.superbwarfare.init.ModItems.AP_5_INCHES.get()))) {
            this.f_19804_.m_135381_(LOADED_AP, (Object)1);
            if (!hasCreativeAmmo) {
                this.consumeItem((Item)com.atsuishio.superbwarfare.init.ModItems.AP_5_INCHES.get(), 1);
            }
        }
    }

    public void m_6478_(@NotNull MoverType movementType, @NotNull Vec3 movement) {
        super.m_6478_(movementType, movement);
        if (this.m_20069_() && this.f_19862_) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, 0.07, 0.0));
        }
    }

    public void vehicleShoot(Player player, int type) {
        Player pPlayer;
        Entity entity = this.m_146895_();
        boolean hasCreativeAmmo = entity instanceof Player && InventoryTool.hasCreativeAmmoBox((Entity)(pPlayer = (Player)entity));
        Matrix4f transform = this.getBarrelTransform(1.0f);
        if (this.getWeaponIndex(0) == 0) {
            if (this.cannotFire || (Integer)this.f_19804_.m_135370_(LOADED_AP) <= 0) {
                return;
            }
            float x = 0.0f;
            float y = -0.3f;
            float z = 4.0927625f;
            Vector4f worldPosition = this.transformPosition(transform, x, y, z);
            CannonShellEntity cannonShell = ((CannonShellWeapon)this.getWeapon(0)).create(player);
            cannonShell.m_6034_((double)worldPosition.x - 1.1 * this.m_20184_().f_82479_, (double)worldPosition.y, (double)worldPosition.z - 1.1 * this.m_20184_().f_82481_);
            cannonShell.m_6686_(this.getBarrelVector((float)1.0f).f_82479_, this.getBarrelVector((float)1.0f).f_82480_ + (double)0.005f, this.getBarrelVector((float)1.0f).f_82481_, 35.0f, 0.25f);
            this.m_9236_().m_7967_((Entity)cannonShell);
            this.f_19804_.m_135381_(LOADED_AP, (Object)0);
            this.reloadCoolDown = 80;
        } else if (this.getWeaponIndex(0) == 1) {
            if (this.cannotFireCoax) {
                return;
            }
            float x = -0.6f;
            float y = 0.65f;
            float z = 0.4f;
            Vector4f worldPosition = this.transformPosition(transform, x, y, z);
            if ((Integer)this.f_19804_.m_135370_(AMMO) > 0 || hasCreativeAmmo) {
                ProjectileEntity projectile = ((ProjectileWeapon)this.getWeapon(0)).create((LivingEntity)player).setGunItemId(this.m_6095_().m_20675_());
                projectile.bypassArmorRate(0.2f);
                projectile.m_6034_((double)worldPosition.x - 1.1 * this.m_20184_().f_82479_, (double)worldPosition.y, (double)worldPosition.z - 1.1 * this.m_20184_().f_82481_);
                projectile.shoot(player, this.getBarrelVector((float)1.0f).f_82479_, this.getBarrelVector((float)1.0f).f_82480_ + (double)0.002f, this.getBarrelVector((float)1.0f).f_82481_, 36.0f, 0.25f);
                this.m_9236_().m_7967_((Entity)projectile);
                if (!hasCreativeAmmo) {
                    ItemStack ammoBox = this.m_213659_().stream().filter(stack -> {
                        if (stack.m_150930_((Item)com.atsuishio.superbwarfare.init.ModItems.AMMO_BOX.get())) {
                            return Ammo.RIFLE.get(stack) > 0;
                        }
                        return false;
                    }).findFirst().orElse(ItemStack.f_41583_);
                    if (!ammoBox.m_41619_()) {
                        Ammo.RIFLE.add(ammoBox, -1);
                    } else {
                        this.m_213659_().stream().filter(stack -> stack.m_150930_((Item)com.atsuishio.superbwarfare.init.ModItems.RIFLE_AMMO.get())).findFirst().ifPresent(stack -> stack.m_41774_(1));
                    }
                }
            }
            this.f_19804_.m_135381_(COAX_HEAT, (Object)((Integer)this.f_19804_.m_135370_(COAX_HEAT) + 3));
            this.f_19804_.m_135381_(FIRE_ANIM, (Object)2);
            if (!player.m_9236_().f_46443_) {
                this.playShootSound3p(player, 0, 3, 6, 12);
            }
        }
    }

    public void travel() {
        this.trackEngine(false, 0.0, (Integer)VehicleConfigVVP.M60_ENERGY_COST.get(), 1.25, 0.75, 1.3, 0.6, 0.25f, -0.2f, 0.0026f, 0.002f, 0.1f);
    }

    public SoundEvent getEngineSound() {
        return (SoundEvent)com.atsuishio.superbwarfare.init.ModSounds.YX_100_ENGINE.get();
    }

    public float getEngineSoundVolume() {
        return Math.max((float)Mth.m_14154_((float)((Float)this.f_19804_.m_135370_(POWER)).floatValue()), (float)Mth.m_14154_((float)(0.1f * ((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue()))) * 2.5f;
    }

    public void m_19956_(@NotNull Entity passenger, @NotNull Entity.MoveFunction callback) {
        if (!this.m_20363_(passenger)) {
            return;
        }
        Matrix4f transform = this.getTurretTransform(1.0f);
        int i = this.getOrderedPassengers().indexOf(passenger);
        Vector4f worldPosition = switch (i) {
            case 0 -> this.transformPosition(transform, 0.0f, 0.0f, 0.0f);
            case 1 -> this.transformPosition(transform, -0.5f, 0.3f, -1.0f);
            case 2 -> this.transformPosition(transform, 0.6669625f, 0.07f, -1.0f);
            default -> throw new IllegalStateException("Unexpected value: " + i);
        };
        passenger.m_6034_((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
        callback.m_20372_(passenger, (double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
        this.copyEntityData(passenger);
    }

    public void copyEntityData(Entity entity) {
        if (entity == this.getNthEntity(0)) {
            entity.m_5618_(this.getBarrelYRot(1.0f));
        }
    }

    public Vec3 driverZoomPos(float ticks) {
        Matrix4f transform = this.getTurretTransform(ticks);
        Vector4f worldPosition = this.transformPosition(transform, 0.0f, 1.0f, 0.6076875f);
        return new Vec3((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
    }

    public int getMaxPassengers() {
        return 3;
    }

    public Vec3 getBarrelVector(float pPartialTicks) {
        Matrix4f transform = this.getBarrelTransform(pPartialTicks);
        Vector4f rootPosition = this.transformPosition(transform, 0.0f, 0.0f, 0.0f);
        Vector4f targetPosition = this.transformPosition(transform, 0.0f, 0.0f, 1.0f);
        return new Vec3((double)rootPosition.x, (double)rootPosition.y, (double)rootPosition.z).m_82505_(new Vec3((double)targetPosition.x, (double)targetPosition.y, (double)targetPosition.z));
    }

    public Vec3 getTurretVector(float pPartialTicks) {
        Matrix4f transform = this.getTurretTransform(pPartialTicks);
        Vector4f rootPosition = this.transformPosition(transform, 0.0f, 0.0f, 0.0f);
        Vector4f targetPosition = this.transformPosition(transform, 0.0f, 0.0f, 1.0f);
        return new Vec3((double)rootPosition.x, (double)rootPosition.y, (double)rootPosition.z).m_82505_(new Vec3((double)targetPosition.x, (double)targetPosition.y, (double)targetPosition.z));
    }

    public Vec3 getGunnerVector(float pPartialTicks) {
        Matrix4f transform = this.getGunnerBarrelTransform(pPartialTicks);
        Vector4f rootPosition = this.transformPosition(transform, 0.0f, 0.0f, 0.0f);
        Vector4f targetPosition = this.transformPosition(transform, 0.0f, 0.0f, 1.0f);
        return new Vec3((double)rootPosition.x, (double)rootPosition.y, (double)rootPosition.z).m_82505_(new Vec3((double)targetPosition.x, (double)targetPosition.y, (double)targetPosition.z));
    }

    public Matrix4f getBarrelTransform(float ticks) {
        Matrix4f transformT = this.getTurretTransform(ticks);
        Matrix4f transform = new Matrix4f();
        Vector4f worldPosition = this.transformPosition(transform, 0.0f, 0.56345f, 0.6477125f);
        transformT.translate(worldPosition.x, worldPosition.y, worldPosition.z);
        float a = this.getTurretYaw(ticks);
        float r = (Mth.m_14154_((float)a) - 90.0f) / 90.0f;
        float r2 = Mth.m_14154_((float)a) <= 90.0f ? a / 90.0f : (a < 0.0f ? -(180.0f + a) / 90.0f : (180.0f - a) / 90.0f);
        float x = Mth.m_14179_((float)ticks, (float)this.turretXRotO, (float)this.getTurretXRot());
        float xV = Mth.m_14179_((float)ticks, (float)this.f_19860_, (float)this.m_146909_());
        float z = Mth.m_14179_((float)ticks, (float)this.prevRoll, (float)this.getRoll());
        transformT.rotate((Quaternionfc)Axis.f_252529_.m_252977_(x + r * xV + r2 * z));
        return transformT;
    }

    public Matrix4f getTurretTransform(float ticks) {
        Matrix4f transformV = this.getVehicleTransform(ticks);
        Matrix4f transform = new Matrix4f();
        Vector4f worldPosition = this.transformPosition(transform, 0.0f, 1.703125f, 0.4375f);
        transformV.translate(worldPosition.x, worldPosition.y, worldPosition.z);
        transformV.rotate((Quaternionfc)Axis.f_252436_.m_252977_(Mth.m_14179_((float)ticks, (float)this.turretYRotO, (float)this.getTurretYRot())));
        return transformV;
    }

    public Matrix4f getGunTransform(float ticks) {
        Matrix4f transformT = this.getTurretTransform(ticks);
        Matrix4f transform = new Matrix4f();
        Vector4f worldPosition = this.transformPosition(transform, 0.577f, 4.616f, 0.56f);
        transformT.translate(worldPosition.x, worldPosition.y, worldPosition.z);
        transformT.rotate((Quaternionfc)Axis.f_252436_.m_252977_(Mth.m_14179_((float)ticks, (float)this.gunYRotO, (float)this.getGunYRot()) - Mth.m_14179_((float)ticks, (float)this.turretYRotO, (float)this.getTurretYRot())));
        return transformT;
    }

    public Matrix4f getGunnerBarrelTransform(float ticks) {
        Matrix4f transformG = this.getGunTransform(ticks);
        Matrix4f transform = new Matrix4f();
        Vector4f worldPosition = this.transformPosition(transform, 0.0f, 0.0f, 0.0f);
        transformG.translate(worldPosition.x, worldPosition.y, worldPosition.z);
        float a = this.getTurretYaw(ticks);
        float r = (Mth.m_14154_((float)a) - 90.0f) / 90.0f;
        float r2 = Mth.m_14154_((float)a) <= 90.0f ? a / 90.0f : (a < 0.0f ? -(180.0f + a) / 90.0f : (180.0f - a) / 90.0f);
        float x = Mth.m_14179_((float)ticks, (float)this.gunXRotO, (float)this.getGunXRot());
        float xV = Mth.m_14179_((float)ticks, (float)this.f_19860_, (float)this.m_146909_());
        float z = Mth.m_14179_((float)ticks, (float)this.prevRoll, (float)this.getRoll());
        transformG.rotate((Quaternionfc)Axis.f_252529_.m_252977_(x + r * xV + r2 * z));
        return transformG;
    }

    public float rotateYOffset() {
        return 3.5f;
    }

    protected void clampRotation(Entity entity) {
        Minecraft mc = Minecraft.m_91087_();
        if (entity.m_9236_().f_46443_ && entity == this.m_146895_()) {
            float a = this.getTurretYaw(1.0f);
            float r = (Mth.m_14154_((float)a) - 90.0f) / 90.0f;
            float r2 = Mth.m_14154_((float)a) <= 90.0f ? a / 90.0f : (a < 0.0f ? -(180.0f + a) / 90.0f : (180.0f - a) / 90.0f);
            float min = -11.0f - r * this.m_146909_() - r2 * this.getRoll();
            float max = 4.6f - r * this.m_146909_() - r2 * this.getRoll();
            float f = Mth.m_14177_((float)entity.m_146909_());
            float f1 = Mth.m_14036_((float)f, (float)min, (float)max);
            entity.f_19860_ += f1 - f;
            entity.m_146926_(entity.m_146909_() + f1 - f);
            if (mc.f_91066_.m_92176_() == CameraType.FIRST_PERSON) {
                float f2 = Mth.m_14177_((float)(entity.m_146908_() - this.getBarrelYRot(1.0f)));
                float f3 = Mth.m_14036_((float)f2, (float)-20.0f, (float)20.0f);
                entity.f_19859_ += f3 - f2;
                entity.m_146922_(entity.m_146908_() + f3 - f2);
                entity.m_5618_(this.getBarrelYRot(1.0f));
            }
        } else if (entity == this.getNthEntity(1)) {
            float a = this.getTurretYaw(1.0f);
            float r = (Mth.m_14154_((float)a) - 90.0f) / 90.0f;
            float r2 = Mth.m_14154_((float)a) <= 90.0f ? a / 90.0f : (a < 0.0f ? -(180.0f + a) / 90.0f : (180.0f - a) / 90.0f);
            float min = -60.0f - r * this.m_146909_() - r2 * this.getRoll();
            float max = 10.0f - r * this.m_146909_() - r2 * this.getRoll();
            float f = Mth.m_14177_((float)entity.m_146909_());
            float f1 = Mth.m_14036_((float)f, (float)min, (float)max);
            entity.f_19860_ += f1 - f;
            entity.m_146926_(entity.m_146909_() + f1 - f);
            if (mc.f_91066_.m_92176_() == CameraType.FIRST_PERSON) {
                float f2 = Mth.m_14177_((float)(entity.m_146908_() - this.getGunYRot(1.0f)));
                float f3 = Mth.m_14036_((float)f2, (float)-150.0f, (float)150.0f);
                entity.f_19859_ += f3 - f2;
                entity.m_146922_(entity.m_146908_() + f3 - f2);
                entity.m_5618_(entity.m_146908_());
            }
        }
    }

    public void m_7340_(@NotNull Entity entity) {
        this.clampRotation(entity);
    }

    private PlayState cannonShootPredicate(AnimationState<M60Entity> event) {
        if ((Integer)this.f_19804_.m_135370_(CANNON_RECOIL_TIME) > 0) {
            return event.setAndContinue(RawAnimation.begin().thenPlayAndHold("animation.yx100.fire"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.yx100.idle"));
    }

    private PlayState coaxShootPredicate(AnimationState<M60Entity> event) {
        if ((Integer)this.f_19804_.m_135370_(FIRE_ANIM) > 0) {
            return event.setAndContinue(RawAnimation.begin().thenPlayAndHold("animation.yx100.fire_coax"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.yx100.idle_coax"));
    }

    private PlayState gunShootPredicate(AnimationState<M60Entity> event) {
        if ((Integer)this.f_19804_.m_135370_(GUN_FIRE_TIME) > 0) {
            return event.setAndContinue(RawAnimation.begin().thenPlayAndHold("animation.yx100.fire2"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.yx100.idle2"));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "cannon", 0, this::cannonShootPredicate)});
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "coax", 0, this::coaxShootPredicate)});
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "gun", 0, this::gunShootPredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public int mainGunRpm(Player player) {
        if (this.getWeaponIndex(0) == 0) {
            return 15;
        }
        if (this.getWeaponIndex(0) == 1) {
            return 600;
        }
        return 300;
    }

    public boolean canShoot(Player player) {
        if (this.getWeaponIndex(0) == 0) {
            return (Integer)this.f_19804_.m_135370_(LOADED_AP) > 0 && !this.cannotFire;
        }
        if (this.getWeaponIndex(0) == 1) {
            Player pPlayer;
            Entity entity = this.m_146895_();
            boolean hasCreativeAmmo = entity instanceof Player && InventoryTool.hasCreativeAmmoBox((Entity)(pPlayer = (Player)entity));
            return ((Integer)this.f_19804_.m_135370_(AMMO) > 0 || hasCreativeAmmo) && !this.cannotFireCoax;
        }
        return false;
    }

    public int getAmmoCount(Player player) {
        if (this.getWeaponIndex(0) == 0) {
            return (Integer)this.f_19804_.m_135370_(LOADED_AP);
        }
        return (Integer)this.f_19804_.m_135370_(AMMO);
    }

    public boolean banHand(Player player) {
        if (player == this.getNthEntity(0) || player == this.getNthEntity(1)) {
            return true;
        }
        return player == this.getNthEntity(2) && !player.m_6144_();
    }

    public boolean hidePassenger(Entity entity) {
        return entity == this.getNthEntity(0) || entity == this.getNthEntity(1);
    }

    public int zoomFov() {
        return 3;
    }

    public boolean hasTracks() {
        return true;
    }

    public int getWeaponHeat(Player player) {
        if (this.getWeaponIndex(0) == 0) {
            return (Integer)this.f_19804_.m_135370_(HEAT);
        }
        if (this.getWeaponIndex(0) == 1) {
            return (Integer)this.f_19804_.m_135370_(COAX_HEAT);
        }
        return 0;
    }

    public void changeWeapon(int index, int value, boolean isScroll) {
        ServerPlayer player;
        Entity entity;
        int typeIndex;
        if (index != 0) {
            return;
        }
        List weapons = this.getAvailableWeapons(index);
        if (weapons.isEmpty()) {
            return;
        }
        int n = typeIndex = isScroll ? (value + this.getWeaponIndex(index) + weapons.size()) % weapons.size() : value;
        if (this.getWeaponIndex(0) == 0 && (Integer)this.f_19804_.m_135370_(LOADED_AP) > 0 && typeIndex != 0) {
            entity = this.m_146895_();
            if (entity instanceof Player && !InventoryTool.hasCreativeAmmoBox((Entity)(player = (Player)entity))) {
                this.insertItem((Item)com.atsuishio.superbwarfare.init.ModItems.AP_5_INCHES.get(), 1);
            }
            this.f_19804_.m_135381_(LOADED_AP, (Object)0);
        }
        if (typeIndex == 0 && (Integer)this.f_19804_.m_135370_(LOADED_AMMO_TYPE) != 0 && (Integer)this.f_19804_.m_135370_(LOADED_AP) == 0) {
            this.reloadCoolDown = 80;
        }
        this.f_19804_.m_135381_(LOADED_AMMO_TYPE, (Object)typeIndex);
        entity = this.m_146895_();
        if (entity instanceof ServerPlayer) {
            player = (ServerPlayer)entity;
            ClientboundStopSoundPacket stopSoundPacket = new ClientboundStopSoundPacket(((SoundEvent)ModSounds.M1128_RELOAD.get()).m_11660_(), SoundSource.PLAYERS);
            player.f_8906_.m_9829_((Packet)stopSoundPacket);
        }
        super.changeWeapon(index, value, isScroll);
    }

    public Vec3 getGunVec(float ticks) {
        return this.getGunnerVector(ticks);
    }

    public ResourceLocation getVehicleIcon() {
        return VVP.loc("textures/vehicle_icon/m60_icon.png");
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderFirstPersonOverlay(GuiGraphics guiGraphics, Font font, Player player, int screenWidth, int screenHeight, float scale) {
        float minWH = Math.min((int)screenWidth, (int)screenHeight);
        float scaledMinWH = Mth.m_14143_((float)(minWH * scale));
        float centerW = ((float)screenWidth - scaledMinWH) / 2.0f;
        float centerH = ((float)screenHeight - scaledMinWH) / 2.0f;
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.getWeaponIndex(0) == 0) {
            RenderHelper.preciseBlit((GuiGraphics)guiGraphics, (ResourceLocation)Mod.loc((String)"textures/screens/land/tank_cannon_cross.png"), (float)centerW, (float)centerH, (float)0.0f, (float)0.0f, (float)scaledMinWH, (float)scaledMinWH, (float)scaledMinWH, (float)scaledMinWH);
        } else if (this.getWeaponIndex(0) == 1) {
            RenderHelper.preciseBlit((GuiGraphics)guiGraphics, (ResourceLocation)Mod.loc((String)"textures/screens/land/lav_gun_cross.png"), (float)centerW, (float)centerH, (float)0.0f, (float)0.0f, (float)scaledMinWH, (float)scaledMinWH, (float)scaledMinWH, (float)scaledMinWH);
        }
        if (this.getWeaponIndex(0) == 0) {
            double heat = 1.0f - (float)((Integer)this.f_19804_.m_135370_(HEAT)).intValue() / 100.0f;
            guiGraphics.m_280614_(font, (Component)Component.m_237113_((String)("      M68    " + String.valueOf(InventoryTool.hasCreativeAmmoBox((Entity)player) ? "\u221e" : Integer.valueOf(this.getAmmoCount(player))))), screenWidth / 2 - 33, screenHeight - 65, Mth.m_14169_((float)((float)heat / 3.7453184f), (float)1.0f, (float)1.0f), false);
        } else {
            double heat = 1.0f - (float)((Integer)this.f_19804_.m_135370_(COAX_HEAT)).intValue() / 100.0f;
            guiGraphics.m_280614_(font, (Component)Component.m_237113_((String)("7.62MM M73 " + String.valueOf(InventoryTool.hasCreativeAmmoBox((Entity)player) ? "\u221e" : Integer.valueOf(this.getAmmoCount(player))))), screenWidth / 2 - 33, screenHeight - 65, Mth.m_14169_((float)((float)heat / 3.7453184f), (float)1.0f, (float)1.0f), false);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderThirdPersonOverlay(GuiGraphics guiGraphics, Font font, Player player, int screenWidth, int screenHeight, float scale) {
        super.renderThirdPersonOverlay(guiGraphics, font, player, screenWidth, screenHeight, scale);
        if (this.getWeaponIndex(0) == 0) {
            double heat = (float)((Integer)this.f_19804_.m_135370_(HEAT)).intValue() / 100.0f;
            guiGraphics.m_280614_(font, (Component)Component.m_237113_((String)("M68 " + String.valueOf(InventoryTool.hasCreativeAmmoBox((Entity)player) ? "\u221e" : Integer.valueOf(this.getAmmoCount(player))))), 30, -9, Mth.m_14169_((float)0.0f, (float)((float)heat), (float)1.0f), false);
        } else {
            double heat2 = (float)((Integer)this.f_19804_.m_135370_(COAX_HEAT)).intValue() / 100.0f;
            guiGraphics.m_280614_(font, (Component)Component.m_237113_((String)("7.62MM M73 " + String.valueOf(InventoryTool.hasCreativeAmmoBox((Entity)player) ? "\u221e" : Integer.valueOf(this.getAmmoCount(player))))), 30, -9, Mth.m_14169_((float)0.0f, (float)((float)heat2), (float)1.0f), false);
        }
    }

    public boolean hasDecoy() {
        return true;
    }

    public double getSensitivity(double original, boolean zoom, int seatIndex, boolean isOnGround) {
        if (seatIndex == 0) {
            return zoom ? 0.14 : (Minecraft.m_91087_().f_91066_.m_92176_().m_90612_() ? 0.18 : 0.3);
        }
        if (seatIndex == 1) {
            return zoom ? 0.25 : (Minecraft.m_91087_().f_91066_.m_92176_().m_90612_() ? 0.35 : 0.4);
        }
        return original;
    }

    public boolean isEnclosed(int index) {
        return index != 2;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public Vec2 getCameraRotation(float partialTicks, Player player, boolean zoom, boolean isFirstPerson) {
        if (zoom || isFirstPerson) {
            if (this.getSeatIndex((Entity)player) == 0) {
                return new Vec2((float)(-M60Entity.getYRotFromVector((Vec3)this.getBarrelVec(partialTicks))), (float)(-M60Entity.getXRotFromVector((Vec3)this.getBarrelVec(partialTicks))));
            }
            if (this.getSeatIndex((Entity)player) == 1) {
                return new Vec2((float)(-M60Entity.getYRotFromVector((Vec3)this.getGunnerVector(partialTicks))), (float)(-M60Entity.getXRotFromVector((Vec3)this.getGunnerVector(partialTicks))));
            }
        }
        return super.getCameraRotation(partialTicks, player, false, false);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vec3 getCameraPosition(float partialTicks, Player player, boolean zoom, boolean isFirstPerson) {
        if (zoom || isFirstPerson) {
            if (this.getSeatIndex((Entity)player) == 0) {
                if (zoom) {
                    return new Vec3(this.driverZoomPos((float)partialTicks).f_82479_, this.driverZoomPos((float)partialTicks).f_82480_, this.driverZoomPos((float)partialTicks).f_82481_);
                }
                return new Vec3(Mth.m_14139_((double)partialTicks, (double)player.f_19854_, (double)player.m_20185_()), Mth.m_14139_((double)partialTicks, (double)(player.f_19855_ + (double)player.m_20192_()), (double)player.m_20188_()), Mth.m_14139_((double)partialTicks, (double)player.f_19856_, (double)player.m_20189_()));
            }
            if (this.getSeatIndex((Entity)player) == 1) {
                return new Vec3(Mth.m_14139_((double)partialTicks, (double)player.f_19854_, (double)player.m_20185_()), Mth.m_14139_((double)partialTicks, (double)(player.f_19855_ + (double)player.m_20192_()), (double)player.m_20188_()), Mth.m_14139_((double)partialTicks, (double)player.f_19856_, (double)player.m_20189_()));
            }
        }
        return super.getCameraPosition(partialTicks, player, false, false);
    }

    @Nullable
    public ResourceLocation getVehicleItemIcon() {
        return Mod.loc((String)"textures/gui/vehicle/type/land.png");
    }

    public float getTurretMaxHealth() {
        return 100.0f;
    }

    public float getWheelMaxHealth() {
        return 100.0f;
    }

    public float getEngineMaxHealth() {
        return 150.0f;
    }

    public List<OBB> getOBBs() {
        return List.of(this.obb, this.obb2, this.obb3, this.obb4, this.obbTurret);
    }

    public void updateOBB() {
        Matrix4f transform = this.getVehicleTransform(1.0f);
        Vector4f worldPosition = this.transformPosition(transform, 0.016f, 1.125f, 1.344f);
        this.obb.center().set((Vector3fc)new Vector3f(worldPosition.x, worldPosition.y, worldPosition.z));
        this.obb.setRotation(VectorTool.combineRotations((float)1.0f, (VehicleEntity)this));
        Vector4f worldPosition2 = this.transformPosition(transform, 0.016f, 1.125f, -2.125f);
        this.obb2.center().set((Vector3fc)new Vector3f(worldPosition2.x, worldPosition2.y, worldPosition2.z));
        this.obb2.setRotation(VectorTool.combineRotations((float)1.0f, (VehicleEntity)this));
        Vector4f worldPosition3 = this.transformPosition(transform, 1.531f, 0.875f, 0.031f);
        this.obb3.center().set((Vector3fc)new Vector3f(worldPosition3.x, worldPosition3.y, worldPosition3.z));
        this.obb3.setRotation(VectorTool.combineRotations((float)1.0f, (VehicleEntity)this));
        Vector4f worldPosition4 = this.transformPosition(transform, -1.531f, 0.875f, 0.031f);
        this.obb4.center().set((Vector3fc)new Vector3f(worldPosition4.x, worldPosition4.y, worldPosition4.z));
        this.obb4.setRotation(VectorTool.combineRotations((float)1.0f, (VehicleEntity)this));
        Matrix4f transformT = this.getTurretTransform(1.0f);
        Vector4f worldPositionT = this.transformPosition(transformT, 0.0f, 0.735f, 0.0f);
        this.obbTurret.center().set((Vector3fc)new Vector3f(worldPositionT.x, worldPositionT.y, worldPositionT.z));
        this.obbTurret.setRotation(VectorTool.combineRotationsTurret((float)1.0f, (VehicleEntity)this));
    }

    @NotNull
    public InteractionResult m_6096_(Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_150930_((Item)ModItems.SPRAY.get())) {
            if (!this.m_9236_().f_46443_) {
                int currentType = (Integer)this.f_19804_.m_135370_(CAMOUFLAGE_TYPE);
                int maxTypes = 2;
                int newType = (currentType + 1) % maxTypes;
                this.f_19804_.m_135381_(CAMOUFLAGE_TYPE, (Object)newType);
                this.m_9236_().m_6269_(null, (Entity)this, (SoundEvent)ModSounds.SPRAY.get(), this.m_5720_(), 1.0f, 1.0f);
                Level level = this.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123748_, this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), 10, 1.0, 1.0, 1.0, 0.1);
                }
                return InteractionResult.CONSUME;
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6096_(player, hand);
    }
}

