/*
 * Decompiled with CFR 0.152.
 */
package tech.vvp.vvp.entity.vehicle;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.entity.OBBEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.ContainerMobileVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.HelicopterEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.ThirdPersonCameraPosition;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.WeaponVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.damage.DamageModifier;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.VehicleWeapon;
import com.atsuishio.superbwarfare.event.ClientMouseHandler;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.tools.CameraTool;
import com.atsuishio.superbwarfare.tools.OBB;
import com.atsuishio.superbwarfare.tools.VectorTool;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.Pair;
import java.util.List;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.PlayMessages;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;
import tech.vvp.vvp.VVP;
import tech.vvp.vvp.config.server.VehicleConfigVVP;
import tech.vvp.vvp.init.ModEntities;
import tech.vvp.vvp.init.ModItems;
import tech.vvp.vvp.init.ModSounds;
import tech.vvp.vvp.init.ModTags;

public class Uh60Entity
extends ContainerMobileVehicleEntity
implements GeoEntity,
HelicopterEntity,
WeaponVehicleEntity,
OBBEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public static final EntityDataAccessor<Float> PROPELLER_ROT = SynchedEntityData.m_135353_(Uh60Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Integer> LOADED_ROCKET = SynchedEntityData.m_135353_(Uh60Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> LOADED_MISSILE = SynchedEntityData.m_135353_(Uh60Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Boolean> DOOR_RIGHT_OPEN = SynchedEntityData.m_135353_(Uh60Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> DOOR_LEFT_OPEN = SynchedEntityData.m_135353_(Uh60Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> CAMOUFLAGE_TYPE = SynchedEntityData.m_135353_(Uh60Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final int RADAR_RANGE = 200;
    public boolean engineStart;
    public boolean engineStartOver;
    public int reloadCoolDownMissile;
    public double velocity;
    public int fireIndex;
    public int holdTick;
    public int holdPowerTick;
    public float destroyRot;
    public int lockTime;
    public boolean locked;
    public String lockingTargetO = "none";
    public String lockingTarget = "none";
    public float delta_x;
    public float delta_y;
    public OBB obbNos;
    public OBB obbCabina;
    public OBB obbTelo;
    public OBB obbWing1;
    public OBB obbXvost;
    public OBB obbWing2;
    public OBB obbDoorRight;
    public OBB obbDoorLeft;

    public Uh60Entity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<Uh60Entity>)((EntityType)ModEntities.UH60.get()), world);
    }

    public Uh60Entity(EntityType<Uh60Entity> type, Level world) {
        super(type, world);
        this.m_274367_(1.5f);
        this.obbNos = new OBB(this.m_20182_().m_252839_(), new Vector3f(1.563f, 0.969f, 0.719f), new Quaternionf(), OBB.Part.BODY);
        this.obbCabina = new OBB(this.m_20182_().m_252839_(), new Vector3f(1.563f, 1.406f, 0.531f), new Quaternionf(), OBB.Part.BODY);
        this.obbTelo = new OBB(this.m_20182_().m_252839_(), new Vector3f(1.313f, 1.406f, 3.75f), new Quaternionf(), OBB.Part.BODY);
        this.obbWing1 = new OBB(this.m_20182_().m_252839_(), new Vector3f(0.656f, 0.969f, 2.656f), new Quaternionf(), OBB.Part.ENGINE1);
        this.obbXvost = new OBB(this.m_20182_().m_252839_(), new Vector3f(0.5f, 0.531f, 0.469f), new Quaternionf(), OBB.Part.BODY);
        this.obbWing2 = new OBB(this.m_20182_().m_252839_(), new Vector3f(0.563f, 1.563f, 0.969f), new Quaternionf(), OBB.Part.ENGINE2);
        this.obbDoorRight = new OBB(this.m_20182_().m_252839_(), new Vector3f(0.188f, 0.875f, 1.063f), new Quaternionf(), OBB.Part.INTERACTIVE);
        this.obbDoorLeft = new OBB(this.m_20182_().m_252839_(), new Vector3f(0.188f, 0.875f, 1.063f), new Quaternionf(), OBB.Part.INTERACTIVE);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 100.0).m_22268_(Attributes.f_22279_, 1.0).m_22268_(Attributes.f_22278_, 0.8).m_22268_(Attributes.f_22284_, 10.0).m_22268_(Attributes.f_22285_, 5.0);
    }

    public static Uh60Entity clientSpawn(PlayMessages.SpawnEntity packet, Level world) {
        EntityType entityTypeFromPacket = (EntityType)BuiltInRegistries.f_256780_.m_7942_(packet.getTypeId());
        if (entityTypeFromPacket == null) {
            Mod.LOGGER.error("Failed to create entity from packet: Unknown entity type id: " + packet.getTypeId());
            return null;
        }
        if (!(entityTypeFromPacket instanceof EntityType)) {
            Mod.LOGGER.error("Retrieved EntityType is not an instance of EntityType<?> for id: " + packet.getTypeId());
            return null;
        }
        EntityType castedEntityType = entityTypeFromPacket;
        Uh60Entity entity = new Uh60Entity((EntityType<Uh60Entity>)castedEntityType, world);
        return entity;
    }

    public VehicleWeapon[][] initWeapons() {
        return new VehicleWeapon[][]{new VehicleWeapon[0]};
    }

    public ThirdPersonCameraPosition getThirdPersonCameraPosition(int index) {
        return new ThirdPersonCameraPosition(16.0, 1.5, 0.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(PROPELLER_ROT, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(LOADED_ROCKET, (Object)0);
        this.f_19804_.m_135372_(LOADED_MISSILE, (Object)0);
        this.f_19804_.m_135372_(DOOR_RIGHT_OPEN, (Object)false);
        this.f_19804_.m_135372_(DOOR_LEFT_OPEN, (Object)false);
        this.f_19804_.m_135372_(CAMOUFLAGE_TYPE, (Object)0);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("LoadedRocket", ((Integer)this.f_19804_.m_135370_(LOADED_ROCKET)).intValue());
        compound.m_128350_("PropellerRot", ((Float)this.f_19804_.m_135370_(PROPELLER_ROT)).floatValue());
        compound.m_128405_("LoadedMissile", ((Integer)this.f_19804_.m_135370_(LOADED_MISSILE)).intValue());
        compound.m_128379_("DoorRightOpen", ((Boolean)this.f_19804_.m_135370_(DOOR_RIGHT_OPEN)).booleanValue());
        compound.m_128379_("DoorLeftOpen", ((Boolean)this.f_19804_.m_135370_(DOOR_LEFT_OPEN)).booleanValue());
        compound.m_128405_("CamouflageType", ((Integer)this.f_19804_.m_135370_(CAMOUFLAGE_TYPE)).intValue());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.f_19804_.m_135381_(LOADED_ROCKET, (Object)compound.m_128451_("LoadedRocket"));
        this.f_19804_.m_135381_(PROPELLER_ROT, (Object)Float.valueOf(compound.m_128457_("PropellerRot")));
        this.f_19804_.m_135381_(LOADED_MISSILE, (Object)compound.m_128451_("LoadedMissile"));
        this.f_19804_.m_135381_(DOOR_RIGHT_OPEN, (Object)compound.m_128471_("DoorRightOpen"));
        this.f_19804_.m_135381_(DOOR_LEFT_OPEN, (Object)compound.m_128471_("DoorLeftOpen"));
        this.f_19804_.m_135381_(CAMOUFLAGE_TYPE, (Object)compound.m_128451_("CamouflageType"));
    }

    public DamageModifier getDamageModifier() {
        return super.getDamageModifier().custom((source, damage) -> {
            Entity entity = source.m_7640_();
            if (entity != null && entity.m_6095_().m_204039_(ModTags.EntityTypes.AERIAL_BOMB)) {
                damage = Float.valueOf(damage.floatValue() * 2.0f);
            }
            damage = Float.valueOf(damage.floatValue() * (this.getHealth() > 0.1f ? 0.7f : 0.05f));
            return damage;
        });
    }

    @NotNull
    public InteractionResult m_6096_(Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21205_();
        OBB lookingObb = OBB.getLookingObb((Player)player, (double)player.getEntityReach());
        if (lookingObb == this.obbDoorRight && stack.m_41619_()) {
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                boolean isOpen = (Boolean)this.f_19804_.m_135370_(DOOR_RIGHT_OPEN);
                this.f_19804_.m_135381_(DOOR_RIGHT_OPEN, (Object)(!isOpen ? 1 : 0));
                Vec3 doorPos = new Vec3(this.obbDoorRight.center());
                serverLevel.m_6263_(null, doorPos.f_82479_, doorPos.f_82480_, doorPos.f_82481_, isOpen ? (SoundEvent)ModSounds.DOOR.get() : (SoundEvent)ModSounds.DOOR.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            player.m_6674_(hand);
            return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        }
        if (lookingObb == this.obbDoorLeft && stack.m_41619_()) {
            Level isOpen = this.m_9236_();
            if (isOpen instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)isOpen;
                boolean isOpen2 = (Boolean)this.f_19804_.m_135370_(DOOR_LEFT_OPEN);
                this.f_19804_.m_135381_(DOOR_LEFT_OPEN, (Object)(!isOpen2 ? 1 : 0));
                Vec3 doorPos = new Vec3(this.obbDoorLeft.center());
                serverLevel.m_6263_(null, doorPos.f_82479_, doorPos.f_82480_, doorPos.f_82481_, isOpen2 ? (SoundEvent)ModSounds.DOOR.get() : (SoundEvent)ModSounds.DOOR.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            player.m_6674_(hand);
            return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        }
        if (stack.m_41720_() == com.atsuishio.superbwarfare.init.ModItems.SMALL_ROCKET.get() && (Integer)this.f_19804_.m_135370_(LOADED_ROCKET) < 25) {
            this.f_19804_.m_135381_(LOADED_ROCKET, (Object)((Integer)this.f_19804_.m_135370_(LOADED_ROCKET) + 1));
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            this.m_9236_().m_6269_(null, (Entity)this, (SoundEvent)com.atsuishio.superbwarfare.init.ModSounds.MISSILE_RELOAD.get(), this.m_5720_(), 2.0f, 1.0f);
            return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        }
        if (stack.m_150930_((Item)ModItems.SPRAY.get())) {
            if (!this.m_9236_().f_46443_) {
                int currentType = (Integer)this.f_19804_.m_135370_(CAMOUFLAGE_TYPE);
                int maxTypes = 3;
                int newType = (currentType + 1) % maxTypes;
                this.f_19804_.m_135381_(CAMOUFLAGE_TYPE, (Object)newType);
                this.m_9236_().m_6269_(null, (Entity)this, (SoundEvent)ModSounds.SPRAY.get(), this.m_5720_(), 1.0f, 1.0f);
                Level level = this.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123748_, this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), 10, 1.0, 1.0, 1.0, 0.1);
                }
                return InteractionResult.CONSUME;
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6096_(player, hand);
    }

    public void m_6075_() {
        super.m_6075_();
        this.updateOBB();
        if (this.m_9236_() instanceof ServerLevel) {
            if (this.reloadCoolDown > 0) {
                --this.reloadCoolDown;
            }
            this.handleAmmo();
        }
        if (this.m_20096_()) {
            this.m_20256_(this.m_20184_().m_82542_(0.8, 1.0, 0.8));
        } else {
            this.setZRot(this.getRoll() * (this.backInputDown ? 0.9f : 0.99f));
            float f = (float)Mth.m_14008_((double)((double)0.95f - 0.015 * this.m_20184_().m_82553_() + (double)(0.02f * Mth.m_14154_((float)(90.0f - (float)Uh60Entity.calculateAngle((Vec3)this.m_20184_(), (Vec3)this.m_20252_(1.0f)))) / 90.0f)), (double)0.01, (double)0.99);
            this.m_20256_(this.m_20184_().m_82549_(this.m_20252_(1.0f).m_82490_((this.m_146909_() < 0.0f ? -0.035 : (this.m_146909_() > 0.0f ? 0.035 : 0.0)) * this.m_20184_().m_82553_())));
            this.m_20256_(this.m_20184_().m_82542_((double)f, 0.95, (double)f));
        }
        if (this.m_20069_() && this.f_19797_ % 4 == 0 && Uh60Entity.getSubmergedHeight((Entity)this) > 0.5 * (double)this.m_20206_()) {
            this.m_20256_(this.m_20184_().m_82542_(0.6, 0.6, 0.6));
            this.m_6469_(ModDamageTypes.causeVehicleStrikeDamage((RegistryAccess)this.m_9236_().m_9598_(), (Entity)this, (Entity)(this.m_146895_() == null ? this : this.m_146895_())), 6.0f + (float)(20.0 * ((this.lastTickSpeed - 0.4) * (this.lastTickSpeed - 0.4))));
        }
        if (this.reloadCoolDownMissile > 0) {
            --this.reloadCoolDownMissile;
        }
        this.releaseDecoy();
        this.lowHealthWarning();
        this.terrainCompact(2.7f, 2.7f);
        this.m_6210_();
    }

    private void handleAmmo() {
    }

    public void travel() {
        Entity passenger = this.m_146895_();
        Entity passenger2 = this.getNthEntity(1);
        if (this.getHealth() > 0.1f * this.getMaxHealth()) {
            if (passenger == null) {
                this.leftInputDown = false;
                this.rightInputDown = false;
                this.forwardInputDown = false;
                this.backInputDown = false;
                this.upInputDown = false;
                this.downInputDown = false;
                this.setZRot(this.roll * 0.98f);
                this.m_146926_(this.m_146909_() * 0.98f);
                if (passenger2 == null) {
                    this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(POWER)).floatValue() * 0.99f));
                }
            } else if (passenger instanceof Player) {
                if (this.rightInputDown) {
                    ++this.holdTick;
                    this.f_19804_.m_135381_(DELTA_ROT, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue() - 2.0f * (float)Math.min((int)this.holdTick, (int)7) * ((Float)this.f_19804_.m_135370_(POWER)).floatValue()));
                } else if (this.leftInputDown) {
                    ++this.holdTick;
                    this.f_19804_.m_135381_(DELTA_ROT, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue() + 2.0f * (float)Math.min((int)this.holdTick, (int)7) * ((Float)this.f_19804_.m_135370_(POWER)).floatValue()));
                } else {
                    this.holdTick = 0;
                }
                this.delta_x = (this.m_20096_() ? 0.0f : 1.5f) * ((Float)this.f_19804_.m_135370_(MOUSE_SPEED_Y)).floatValue() * ((Float)this.f_19804_.m_135370_(PROPELLER_ROT)).floatValue();
                this.delta_y = Mth.m_14036_((float)((this.m_20096_() ? 0.1f : 2.0f) * ((Float)this.f_19804_.m_135370_(MOUSE_SPEED_X)).floatValue() * ((Float)this.f_19804_.m_135370_(PROPELLER_ROT)).floatValue()), (float)-10.0f, (float)10.0f);
                this.m_146922_(this.m_146908_() + this.delta_y);
                this.m_146926_(this.m_146909_() + this.delta_x);
                this.setZRot(this.getRoll() - ((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue() + (this.m_20096_() ? 0.0f : 0.25f) * ((Float)this.f_19804_.m_135370_(MOUSE_SPEED_X)).floatValue() * ((Float)this.f_19804_.m_135370_(PROPELLER_ROT)).floatValue());
            }
            if (this.m_9236_() instanceof ServerLevel) {
                if (this.getEnergy() > 0) {
                    boolean up = this.upInputDown || this.forwardInputDown;
                    boolean down = this.downInputDown;
                    if (!this.engineStart && up) {
                        this.engineStart = true;
                        this.m_9236_().m_6269_(null, (Entity)this, (SoundEvent)com.atsuishio.superbwarfare.init.ModSounds.HELICOPTER_ENGINE_START.get(), this.m_5720_(), 3.0f, 1.0f);
                    }
                    if (up && this.engineStartOver) {
                        ++this.holdPowerTick;
                        this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(Math.min((float)(((Float)this.f_19804_.m_135370_(POWER)).floatValue() + 7.0E-4f * (float)Math.min((int)this.holdPowerTick, (int)10)), (float)0.12f)));
                    }
                    if (this.engineStartOver) {
                        if (down) {
                            ++this.holdPowerTick;
                            this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(Math.max((float)(((Float)this.f_19804_.m_135370_(POWER)).floatValue() - 0.001f * (float)Math.min((int)this.holdPowerTick, (int)5)), (float)(this.m_20096_() ? 0.0f : 0.025f))));
                        } else if (this.backInputDown) {
                            ++this.holdPowerTick;
                            this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(Math.max((float)(((Float)this.f_19804_.m_135370_(POWER)).floatValue() - 0.001f * (float)Math.min((int)this.holdPowerTick, (int)5)), (float)(this.m_20096_() ? 0.0f : 0.052f))));
                            if (passenger != null) {
                                passenger.m_146926_(0.8f * passenger.m_146909_());
                            }
                        }
                    }
                    if (this.engineStart && !this.engineStartOver) {
                        this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(Math.min((float)(((Float)this.f_19804_.m_135370_(POWER)).floatValue() + 0.0012f), (float)0.045f)));
                    }
                    if (!up && !down && !this.backInputDown && this.engineStartOver) {
                        if (this.m_20184_().m_7098_() < 0.0) {
                            this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(Math.min((float)(((Float)this.f_19804_.m_135370_(POWER)).floatValue() + 2.0E-4f), (float)0.12f)));
                        } else {
                            this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(Math.max((float)(((Float)this.f_19804_.m_135370_(POWER)).floatValue() - (this.m_20096_() ? 5.0E-5f : 2.0E-4f)), (float)0.0f)));
                        }
                        this.holdPowerTick = 0;
                    }
                } else {
                    this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(Math.max((float)(((Float)this.f_19804_.m_135370_(POWER)).floatValue() - 1.0E-4f), (float)0.0f)));
                    this.forwardInputDown = false;
                    this.backInputDown = false;
                    this.engineStart = false;
                    this.engineStartOver = false;
                }
            }
        } else if (!this.m_20096_() && this.engineStartOver) {
            this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(Math.max((float)(((Float)this.f_19804_.m_135370_(POWER)).floatValue() - 3.0E-4f), (float)0.01f)));
            this.destroyRot += 0.08f;
            float diffX = 45.0f - this.m_146909_();
            float diffZ = -20.0f - this.getRoll();
            this.m_146926_(this.m_146909_() + diffX * 0.05f * ((Float)this.f_19804_.m_135370_(PROPELLER_ROT)).floatValue());
            this.m_146922_(this.m_146908_() + this.destroyRot);
            this.setZRot(this.getRoll() + diffZ * 0.1f * ((Float)this.f_19804_.m_135370_(PROPELLER_ROT)).floatValue());
            this.m_20256_(this.m_20184_().m_82520_(0.0, (double)(-this.destroyRot) * 0.004, 0.0));
        }
        this.f_19804_.m_135381_(DELTA_ROT, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue() * 0.9f));
        this.f_19804_.m_135381_(PROPELLER_ROT, (Object)Float.valueOf(Mth.m_14179_((float)0.18f, (float)((Float)this.f_19804_.m_135370_(PROPELLER_ROT)).floatValue(), (float)((Float)this.f_19804_.m_135370_(POWER)).floatValue())));
        this.setPropellerRot(this.getPropellerRot() + 30.0f * ((Float)this.f_19804_.m_135370_(PROPELLER_ROT)).floatValue());
        this.f_19804_.m_135381_(PROPELLER_ROT, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(PROPELLER_ROT)).floatValue() * 0.9995f));
        if (this.engineStart) {
            this.consumeEnergy((int)((double)((Integer)VehicleConfigVVP.BLACKHAWK_MIN_ENERGY_COST.get()).intValue() + (double)((Float)this.f_19804_.m_135370_(POWER)).floatValue() * ((double)((Integer)VehicleConfigVVP.BLACKHAWK_MIN_ENERGY_COST.get() - (Integer)VehicleConfigVVP.BLACKHAWK_MIN_ENERGY_COST.get()) / 0.12)));
        }
        if (((Boolean)this.f_19804_.m_135370_(ENGINE1_DAMAGED)).booleanValue()) {
            this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(POWER)).floatValue() * 0.98f));
        }
        Matrix4f transform = this.getVehicleTransform(1.0f);
        Vector4f force0 = this.transformPosition(transform, 0.0f, 0.0f, 0.0f);
        Vector4f force1 = this.transformPosition(transform, 0.0f, 1.0f, 0.0f);
        Vec3 force = new Vec3((double)force0.x, (double)force0.y, (double)force0.z).m_82505_(new Vec3((double)force1.x, (double)force1.y, (double)force1.z));
        this.m_20256_(this.m_20184_().m_82549_(force.m_82490_((double)((Float)this.f_19804_.m_135370_(POWER)).floatValue())));
        if (((Float)this.f_19804_.m_135370_(POWER)).floatValue() > 0.04f) {
            this.engineStartOver = true;
        }
        if (((Float)this.f_19804_.m_135370_(POWER)).floatValue() < 4.0E-4f) {
            this.engineStart = false;
            this.engineStartOver = false;
        }
    }

    public void setTargetUuid(String uuid) {
        this.lockingTarget = uuid;
    }

    public String getTargetUuid() {
        return this.lockingTarget;
    }

    public SoundEvent getEngineSound() {
        return (SoundEvent)com.atsuishio.superbwarfare.init.ModSounds.HELICOPTER_ENGINE.get();
    }

    public float getEngineSoundVolume() {
        return ((Float)this.f_19804_.m_135370_(PROPELLER_ROT)).floatValue() * 2.0f;
    }

    protected void clampRotation(Entity entity) {
        if (entity == this.getNthEntity(0)) {
            float f2 = Mth.m_14177_((float)(entity.m_146908_() - this.m_146908_()));
            float f3 = Mth.m_14036_((float)f2, (float)-80.0f, (float)80.0f);
            entity.f_19859_ += f3 - f2;
            entity.m_146922_(entity.m_146908_() + f3 - f2);
            entity.m_5618_(this.m_146908_());
        } else if (entity == this.getNthEntity(1)) {
            float f = Mth.m_14177_((float)entity.m_146909_());
            float f1 = Mth.m_14036_((float)f, (float)-80.0f, (float)80.0f);
            entity.f_19860_ += f1 - f;
            entity.m_146926_(entity.m_146909_() + f1 - f);
            float f2 = Mth.m_14177_((float)(entity.m_146908_() - this.m_146908_()));
            float f3 = Mth.m_14036_((float)f2, (float)-80.0f, (float)80.0f);
            entity.f_19859_ += f3 - f2;
            entity.m_146922_(entity.m_146908_() + f3 - f2);
            entity.m_5618_(this.m_146908_());
        }
    }

    public void m_7340_(@NotNull Entity entity) {
        this.clampRotation(entity);
    }

    public void m_19956_(@NotNull Entity passenger, @NotNull Entity.MoveFunction callback) {
        float y;
        float x;
        if (!this.m_20363_(passenger)) {
            return;
        }
        Matrix4f transform = this.getVehicleTransform(1.0f);
        int i = this.getOrderedPassengers().indexOf(passenger);
        float riderOffset = (float)passenger.m_6049_();
        Vector4f worldPosition = this.transformPosition(transform, x, y + riderOffset, switch (i) {
            case 0 -> {
                x = 0.734f;
                y = -0.25f;
                yield 3.25f;
            }
            case 1 -> {
                x = -0.703f;
                y = -0.25f;
                yield 3.25f;
            }
            case 2 -> {
                x = 0.844f;
                y = -0.25f;
                yield 0.188f;
            }
            case 3 -> {
                x = 0.281f;
                y = -0.25f;
                yield 0.188f;
            }
            case 4 -> {
                x = -0.344f;
                y = -0.25f;
                yield 0.188f;
            }
            case 5 -> {
                x = -0.906f;
                y = -0.25f;
                yield 0.188f;
            }
            case 6 -> {
                x = 0.844f;
                y = -0.25f;
                yield -1.375f;
            }
            case 7 -> {
                x = 0.281f;
                y = -0.25f;
                yield -1.375f;
            }
            case 8 -> {
                x = -0.344f;
                y = -0.25f;
                yield -1.375f;
            }
            default -> {
                x = 0.0f;
                y = 2.0f;
                yield 0.0f;
            }
        });
        passenger.m_6034_((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
        callback.m_20372_(passenger, (double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
        this.copyEntityData(passenger);
    }

    public void copyEntityData(Entity entity) {
        if (entity == this.getNthEntity(0)) {
            entity.m_5616_(entity.m_6080_() + this.delta_y);
            entity.m_146922_(entity.m_146908_() + this.delta_y);
            entity.m_5618_(this.m_146908_());
        } else if (entity == this.getNthEntity(1)) {
            float f = Mth.m_14177_((float)(entity.m_146908_() - this.m_146908_()));
            float g = Mth.m_14036_((float)f, (float)-105.0f, (float)105.0f);
            entity.f_19859_ += g - f;
            entity.m_146922_(entity.m_146908_() + g - f + 0.9f * this.destroyRot);
            entity.m_5616_(entity.m_146908_());
            entity.m_5618_(this.m_146908_());
        }
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public Vec3 shootPos(float tickDelta) {
        Matrix4f transform = this.getVehicleTransform(tickDelta);
        Vector4f worldPosition = this.transformPosition(transform, 0.0f, -0.8f, 3.0f);
        return new Vec3((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
    }

    public Vec3 shootVec(float tickDelta) {
        Matrix4f transform = this.getVehicleTransform(tickDelta);
        Vector4f worldPosition = this.transformPosition(transform, 0.0f, 0.0f, 0.0f);
        Vector4f worldPosition2 = this.transformPosition(transform, 0.0f, 0.01f, 1.0f);
        return new Vec3((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z).m_82505_(new Vec3((double)worldPosition2.x, (double)worldPosition2.y, (double)worldPosition2.z)).m_82541_();
    }

    public void vehicleShoot(Player player, int type) {
    }

    public int mainGunRpm(Player player) {
        return 0;
    }

    public boolean canShoot(Player player) {
        return false;
    }

    public int getAmmoCount(Player player) {
        return 0;
    }

    public boolean hidePassenger(Entity entity) {
        return false;
    }

    public int zoomFov() {
        return 0;
    }

    public int getWeaponHeat(Player player) {
        return 0;
    }

    public float getRotX(float tickDelta) {
        return this.getPitch(tickDelta);
    }

    public float getRotY(float tickDelta) {
        return this.getYaw(tickDelta);
    }

    public float getRotZ(float tickDelta) {
        return this.getRoll(tickDelta);
    }

    public float getPower() {
        return ((Float)this.f_19804_.m_135370_(POWER)).floatValue();
    }

    public int getDecoy() {
        return (Integer)this.f_19804_.m_135370_(DECOY_COUNT);
    }

    public int getMaxPassengers() {
        return 9;
    }

    public ResourceLocation getVehicleIcon() {
        return VVP.loc("textures/vehicle_icon/uh60_icon.png");
    }

    public double getSensitivity(double original, boolean zoom, int seatIndex, boolean isOnGround) {
        return seatIndex == 0 ? 0.0 : original;
    }

    public double getMouseSensitivity() {
        return 0.15;
    }

    public double getMouseSpeedX() {
        return 0.35;
    }

    public double getMouseSpeedY() {
        return 0.2;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public Pair<Quaternionf, Quaternionf> getPassengerRotation(Entity entity, float tickDelta) {
        return Pair.of((Object)Axis.f_252529_.m_252977_(-this.m_5686_(tickDelta)), (Object)Axis.f_252403_.m_252977_(-this.getRoll(tickDelta)));
    }

    public Matrix4f getClientVehicleTransform(float ticks) {
        Matrix4f transform = new Matrix4f();
        transform.translate((float)Mth.m_14139_((double)ticks, (double)this.f_19854_, (double)this.m_20185_()), (float)Mth.m_14139_((double)ticks, (double)(this.f_19855_ + (double)1.45f), (double)(this.m_20186_() + (double)1.45f)), (float)Mth.m_14139_((double)ticks, (double)this.f_19856_, (double)this.m_20189_()));
        transform.rotate((Quaternionfc)Axis.f_252436_.m_252977_((float)((double)(-Mth.m_14179_((float)ticks, (float)this.f_19859_, (float)this.m_146908_())) + ClientMouseHandler.freeCameraYaw)));
        transform.rotate((Quaternionfc)Axis.f_252529_.m_252977_((float)((double)Mth.m_14179_((float)ticks, (float)this.f_19860_, (float)this.m_146909_()) + ClientMouseHandler.freeCameraPitch)));
        transform.rotate((Quaternionfc)Axis.f_252403_.m_252977_(Mth.m_14179_((float)ticks, (float)this.prevRoll, (float)this.getRoll())));
        return transform;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public Vec2 getCameraRotation(float partialTicks, Player player, boolean zoom, boolean isFirstPerson) {
        if (this.getSeatIndex((Entity)player) == 0) {
            return new Vec2((float)((double)this.getRotY(partialTicks) - ClientMouseHandler.freeCameraYaw), (float)((double)this.getRotX(partialTicks) + ClientMouseHandler.freeCameraPitch));
        }
        return super.getCameraRotation(partialTicks, player, false, false);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vec3 getCameraPosition(float partialTicks, Player player, boolean zoom, boolean isFirstPerson) {
        if (this.getSeatIndex((Entity)player) == 0) {
            Matrix4f transform = this.getClientVehicleTransform(partialTicks);
            Vector4f maxCameraPosition = this.transformPosition(transform, -2.1f, 1.0f, -10.0f - (float)ClientMouseHandler.custom3pDistanceLerp);
            Vec3 finalPos = CameraTool.getMaxZoom((Matrix4f)transform, (Vector4f)maxCameraPosition);
            if (isFirstPerson) {
                return new Vec3(Mth.m_14139_((double)partialTicks, (double)player.f_19854_, (double)player.m_20185_()), Mth.m_14139_((double)partialTicks, (double)(player.f_19855_ + (double)player.m_20192_()), (double)player.m_20188_()), Mth.m_14139_((double)partialTicks, (double)player.f_19856_, (double)player.m_20189_()));
            }
            return finalPos;
        }
        return super.getCameraPosition(partialTicks, player, false, false);
    }

    @Nullable
    public ResourceLocation getVehicleItemIcon() {
        return Mod.loc((String)"textures/gui/vehicle/type/aircraft.png");
    }

    public List<OBB> getOBBs() {
        return List.of(this.obbNos, this.obbCabina, this.obbTelo, this.obbWing1, this.obbXvost, this.obbWing2, this.obbDoorRight, this.obbDoorLeft);
    }

    public void updateOBB() {
        Matrix4f transform = this.getVehicleTransform(1.0f);
        Vector4f worldPosition = this.transformPosition(transform, 0.0f, 0.5f, 4.734f);
        this.obbNos.center().set((Vector3fc)new Vector3f(worldPosition.x, worldPosition.y, worldPosition.z));
        this.obbNos.setRotation(VectorTool.combineRotations((float)1.0f, (VehicleEntity)this));
        Vector4f worldPosition2 = this.transformPosition(transform, 0.0f, 0.5f, 3.469f);
        this.obbCabina.center().set((Vector3fc)new Vector3f(worldPosition2.x, worldPosition2.y, worldPosition2.z));
        this.obbCabina.setRotation(VectorTool.combineRotations((float)1.0f, (VehicleEntity)this));
        Vector4f worldPosition3 = this.transformPosition(transform, 0.0f, 0.5f, -0.813f);
        this.obbTelo.center().set((Vector3fc)new Vector3f(worldPosition3.x, worldPosition3.y, worldPosition3.z));
        this.obbTelo.setRotation(VectorTool.combineRotations((float)1.0f, (VehicleEntity)this));
        Vector4f worldPosition6 = this.transformPosition(transform, 0.0f, 0.5f, -7.219f);
        this.obbWing1.center().set((Vector3fc)new Vector3f(worldPosition6.x, worldPosition6.y, worldPosition6.z));
        this.obbWing1.setRotation(VectorTool.combineRotations((float)1.0f, (VehicleEntity)this));
        Vector4f worldPosition8 = this.transformPosition(transform, 0.0f, 2.5f, -0.156f);
        this.obbXvost.center().set((Vector3fc)new Vector3f(worldPosition8.x, worldPosition8.y, worldPosition8.z));
        this.obbXvost.setRotation(VectorTool.combineRotations((float)1.0f, (VehicleEntity)this));
        Vector4f worldPosition7 = this.transformPosition(transform, 0.063f, 0.75f, -10.844f);
        this.obbWing2.center().set((Vector3fc)new Vector3f(worldPosition7.x, worldPosition7.y, worldPosition7.z));
        this.obbWing2.setRotation(VectorTool.combineRotations((float)1.0f, (VehicleEntity)this));
        float doorOffsetZRight = (Boolean)this.f_19804_.m_135370_(DOOR_RIGHT_OPEN) != false ? Mth.m_14179_((float)0.1f, (float)0.0f, (float)-20.0f) : 0.0f;
        Vector4f worldPositionR = this.transformPosition(transform, -1.422f, 0.5f, doorOffsetZRight);
        this.obbDoorRight.center().set((Vector3fc)new Vector3f(worldPositionR.x, worldPositionR.y, worldPositionR.z));
        this.obbDoorRight.setRotation(VectorTool.combineRotations((float)1.0f, (VehicleEntity)this));
        float doorOffsetZLeft = (Boolean)this.f_19804_.m_135370_(DOOR_LEFT_OPEN) != false ? Mth.m_14179_((float)0.1f, (float)0.0f, (float)-20.0f) : 0.0f;
        Vector4f worldPositionL = this.transformPosition(transform, 1.422f, 0.5f, doorOffsetZLeft);
        this.obbDoorLeft.center().set((Vector3fc)new Vector3f(worldPositionL.x, worldPositionL.y, worldPositionL.z));
        this.obbDoorLeft.setRotation(VectorTool.combineRotations((float)1.0f, (VehicleEntity)this));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "door_right_controller", 0, this::doorRightAnimController)});
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "door_left_controller", 0, this::doorLeftAnimController)});
    }

    private PlayState doorRightAnimController(AnimationState<Uh60Entity> state) {
        if (((Boolean)this.f_19804_.m_135370_(DOOR_RIGHT_OPEN)).booleanValue()) {
            state.getController().setAnimation(RawAnimation.begin().thenPlay("animation.uh60.door_right.open"));
        } else {
            state.getController().setAnimation(RawAnimation.begin().thenPlay("animation.uh60.door_right.close"));
        }
        return PlayState.CONTINUE;
    }

    private PlayState doorLeftAnimController(AnimationState<Uh60Entity> state) {
        if (((Boolean)this.f_19804_.m_135370_(DOOR_LEFT_OPEN)).booleanValue()) {
            state.getController().setAnimation(RawAnimation.begin().thenPlay("animation.uh60.door_left.open"));
        } else {
            state.getController().setAnimation(RawAnimation.begin().thenPlay("animation.uh60.door_left.close"));
        }
        return PlayState.CONTINUE;
    }

    public Matrix4f getVehicleTransform(float ticks) {
        Matrix4f transform = new Matrix4f();
        transform.translate((float)Mth.m_14139_((double)ticks, (double)this.f_19854_, (double)this.m_20185_()), (float)Mth.m_14139_((double)ticks, (double)(this.f_19855_ + (double)1.45f), (double)(this.m_20186_() + (double)1.45f)), (float)Mth.m_14139_((double)ticks, (double)this.f_19856_, (double)this.m_20189_()));
        transform.rotate((Quaternionfc)Axis.f_252436_.m_252977_(-Mth.m_14179_((float)ticks, (float)this.f_19859_, (float)this.m_146908_())));
        transform.rotate((Quaternionfc)Axis.f_252529_.m_252977_(Mth.m_14179_((float)ticks, (float)this.f_19860_, (float)this.m_146909_())));
        transform.rotate((Quaternionfc)Axis.f_252403_.m_252977_(Mth.m_14179_((float)ticks, (float)this.prevRoll, (float)this.getRoll())));
        return transform;
    }
}

