/*
 * Decompiled with CFR 0.152.
 */
package tech.vvp.vvp.item.gun.launcher;

import com.atsuishio.superbwarfare.client.tooltip.component.LauncherImageComponent;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.event.ClientEventHandler;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.renderer.GeoItemRenderer;
import tech.vvp.vvp.VVP;
import tech.vvp.vvp.client.renderer.gun.At4ItemRenderer;

public class At4Item
extends GunItem {
    public At4Item() {
        super(new Item.Properties().m_41497_(Rarity.RARE).m_41487_(16));
    }

    public Supplier<? extends GeoItemRenderer<? extends Item>> getRenderer() {
        return At4ItemRenderer::new;
    }

    private PlayState idlePredicate(AnimationState<At4Item> event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return PlayState.STOP;
        }
        ItemStack stack = player.m_21205_();
        if (!(stack.m_41720_() instanceof GunItem)) {
            return PlayState.STOP;
        }
        if (event.getData(DataTickets.ITEM_RENDER_PERSPECTIVE) != ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.at4.idle"));
        }
        if (ClientEventHandler.isEditing) {
            return event.setAndContinue(RawAnimation.begin().thenPlay("animation.at4.edit"));
        }
        if (player.m_20142_() && player.m_20096_() && ClientEventHandler.cantSprint == 0.0f && ClientEventHandler.drawTime < 0.01) {
            if (ClientEventHandler.tacticalSprint) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.at4.run_fast"));
            }
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.at4.run"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.at4.idle"));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        AnimationController idleController = new AnimationController((GeoAnimatable)this, "idleController", 4, this::idlePredicate);
        data.add(new AnimationController[]{idleController});
    }

    public ResourceLocation getGunIcon(ItemStack stack) {
        int i = GunData.from((ItemStack)stack).selectedAmmoType.get();
        if (i == 0) {
            return VVP.loc("textures/gun_icon/at4_tbg_icon.png");
        }
        return VVP.loc("textures/gun_icon/at4_standard_icon.png");
    }

    @NotNull
    public Optional<TooltipComponent> m_142422_(@NotNull ItemStack pStack) {
        return Optional.of(new LauncherImageComponent(pStack));
    }

    public boolean shootBullet(@Nullable Entity shooter, @NotNull ServerLevel level, @NotNull Vec3 shootPosition, @NotNull Vec3 shootDirection, @NotNull GunData data, double spread, boolean zoom, @Nullable UUID uuid) {
        if (!super.shootBullet(shooter, level, shootPosition, shootDirection, data, spread, zoom, uuid)) {
            return false;
        }
        if (shooter != null) {
            ParticleTool.sendParticle((ServerLevel)level, (ParticleOptions)ParticleTypes.f_123796_, (double)(shooter.m_20185_() + 1.8 * shooter.m_20154_().f_82479_), (double)(shooter.m_20186_() + (double)shooter.m_20206_() - 0.1 + 1.8 * shooter.m_20154_().f_82480_), (double)(shooter.m_20189_() + 1.8 * shooter.m_20154_().f_82481_), (int)30, (double)0.4, (double)0.4, (double)0.4, (double)0.005, (boolean)true);
        }
        if (shooter instanceof Player) {
            ItemStack mainHandItem;
            Player player = (Player)shooter;
            if (!player.m_150110_().f_35937_ && (mainHandItem = player.m_21205_()).m_150930_((Item)this)) {
                mainHandItem.m_41774_(1);
            }
        }
        return true;
    }

    public boolean canEditAttachments(ItemStack stack) {
        return true;
    }
}

