/*
 * Decompiled with CFR 0.152.
 */
package tech.vvp.vvp.network.message;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;
import tech.vvp.vvp.client.gui.RadarHud;

public class S2CRadarSyncPacket {
    private final List<Vec3> targets;

    public S2CRadarSyncPacket(List<Vec3> targets) {
        this.targets = targets;
    }

    public S2CRadarSyncPacket(FriendlyByteBuf buf) {
        int size = buf.readInt();
        this.targets = new ArrayList<Vec3>(size);
        for (int i = 0; i < size; ++i) {
            this.targets.add(new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble()));
        }
    }

    public static void buffer(S2CRadarSyncPacket message, FriendlyByteBuf buf) {
        buf.writeInt(message.targets.size());
        for (Vec3 target : message.targets) {
            buf.writeDouble(target.f_82479_);
            buf.writeDouble(target.f_82480_);
            buf.writeDouble(target.f_82481_);
        }
    }

    public static void handler(S2CRadarSyncPacket message, Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            RadarHud.radarTargets = message.targets;
        });
        context.setPacketHandled(true);
    }
}

