/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.blockentity;

import com.mrcrayfish.framework.network.message.IMessage;
import com.mrcrayfish.furniture.refurbished.Config;
import com.mrcrayfish.furniture.refurbished.blockentity.fluid.FluidContainer;
import com.mrcrayfish.furniture.refurbished.blockentity.fluid.IFluidContainerBlock;
import com.mrcrayfish.furniture.refurbished.core.ModBlockEntities;
import com.mrcrayfish.furniture.refurbished.network.Network;
import com.mrcrayfish.furniture.refurbished.network.message.MessageFlushItem;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class ToiletBlockEntity
extends BlockEntity
implements IFluidContainerBlock {
    protected final FluidContainer tank;

    public ToiletBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)ModBlockEntities.TOILET.get(), pos, state);
    }

    public ToiletBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.tank = FluidContainer.create((Long)Config.SERVER.toilet.fluidCapacity.get(), container -> {
            this.m_6596_();
            container.sync(this);
        });
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Override
    public FluidContainer getFluidContainer() {
        return this.tank;
    }

    public InteractionResult interact(Player player, InteractionHand hand, BlockHitResult result) {
        Vec3 hit = result.m_82450_().m_82546_(Vec3.m_82528_((Vec3i)this.f_58858_));
        if (hit.m_7098_() > 0.625 && !this.tank.isEmpty() && this.flushItems(player.m_9236_()).m_19077_()) {
            return InteractionResult.SUCCESS;
        }
        if (this.interactWithBottle(player, hand, this.f_58858_).m_19077_()) {
            return InteractionResult.SUCCESS;
        }
        if (this.performPlatformInteraction(player, hand, this.f_58858_, result.m_82434_()).m_19077_()) {
            return InteractionResult.SUCCESS;
        }
        if (((Boolean)Config.SERVER.toilet.dispenseWater.get()).booleanValue() && result.m_82434_() != Direction.DOWN) {
            if (this.tryAndFillWithFluid(this.f_58857_, this.f_58858_, (Fluid)Fluids.f_76193_, Vec3.m_82512_((Vec3i)this.f_58858_)).m_19077_()) {
                return InteractionResult.SUCCESS;
            }
            if (this.tryAndCreateObsidian(this.f_58857_, this.f_58858_, (Fluid)Fluids.f_76193_, Vec3.m_82539_((Vec3i)this.f_58858_).m_82520_(0.0, 1.0, 0.0)).m_19077_()) {
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.CONSUME;
    }

    private InteractionResult flushItems(Level level) {
        List entities = level.m_45976_(ItemEntity.class, new AABB(this.f_58858_));
        if (!entities.isEmpty()) {
            if (!level.m_5776_()) {
                entities.forEach(entity -> {
                    Network.getPlay().sendToTrackingBlockEntity(() -> this, (IMessage)new MessageFlushItem(entity.m_19879_(), this.f_58858_));
                    entity.m_146870_();
                });
                level.m_186460_(this.f_58858_, this.m_58900_().m_60734_(), 40);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.tank.load(tag.m_128469_("FluidTank"));
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        CompoundTag tankTag = new CompoundTag();
        this.tank.save(tankTag);
        tag.m_128365_("FluidTank", (Tag)tankTag);
    }
}

