/*
 * Decompiled with CFR 0.152.
 */
package Aru.Aru.ashvehicle.Packet;

import Aru.Aru.ashvehicle.init.ClientTargetingData;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class MultiLockTargetPacket {
    private final List<UUID> targetUUIDs;

    public MultiLockTargetPacket(List<UUID> targetUUIDs) {
        this.targetUUIDs = targetUUIDs;
    }

    public static void encode(MultiLockTargetPacket msg, FriendlyByteBuf buf) {
        buf.m_130130_(msg.targetUUIDs.size());
        for (UUID uuid : msg.targetUUIDs) {
            buf.m_130077_(uuid);
        }
    }

    public static MultiLockTargetPacket decode(FriendlyByteBuf buf) {
        int count = buf.m_130242_();
        ArrayList<UUID> targets = new ArrayList<UUID>();
        for (int i = 0; i < count; ++i) {
            targets.add(buf.m_130259_());
        }
        return new MultiLockTargetPacket(targets);
    }

    public static void handle(MultiLockTargetPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91073_ == null) {
                return;
            }
            if (msg.targetUUIDs.isEmpty()) {
                ClientTargetingData.clearLockedTargets();
                return;
            }
            ArrayList<Entity> locked = new ArrayList<Entity>();
            block0: for (UUID uuid : msg.targetUUIDs) {
                for (Entity entity : mc.f_91073_.m_104735_()) {
                    if (entity == null || !entity.m_20148_().equals(uuid)) continue;
                    locked.add(entity);
                    continue block0;
                }
            }
            ClientTargetingData.setLockedTargets(locked);
        });
        ctx.get().setPacketHandled(true);
    }
}

