/*
 * Decompiled with CFR 0.152.
 */
package Aru.Aru.ashvehicle.entity.vehicle;

import Aru.Aru.ashvehicle.entity.weapon.BallisticMissileEntity;
import Aru.Aru.ashvehicle.entity.weapon.BallisticMissileWeapon;
import Aru.Aru.ashvehicle.init.CoordinateTargetVehicle;
import Aru.Aru.ashvehicle.init.ModEntities;
import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.config.server.ExplosionConfig;
import com.atsuishio.superbwarfare.config.server.VehicleConfig;
import com.atsuishio.superbwarfare.entity.vehicle.base.ContainerMobileVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.LandArmorEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.ThirdPersonCameraPosition;
import com.atsuishio.superbwarfare.entity.vehicle.base.WeaponVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.damage.DamageModifier;
import com.atsuishio.superbwarfare.entity.vehicle.weapon.VehicleWeapon;
import com.atsuishio.superbwarfare.event.ClientMouseHandler;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.network.message.receive.ShakeClientMessage;
import com.atsuishio.superbwarfare.tools.Ammo;
import com.atsuishio.superbwarfare.tools.CustomExplosion;
import com.atsuishio.superbwarfare.tools.InventoryTool;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.PlayMessages;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import org.joml.Vector4f;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SapsanEntity
extends ContainerMobileVehicleEntity
implements GeoEntity,
LandArmorEntity,
WeaponVehicleEntity,
CoordinateTargetVehicle {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean wasSprintInputDown = false;
    private boolean sprintToggled;
    private boolean shotToggled;
    private static final EntityDataAccessor<Float> POD_ROT = SynchedEntityData.m_135353_(SapsanEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> POD_TOGGLED = SynchedEntityData.m_135353_(SapsanEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public SapsanEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<SapsanEntity>)((EntityType)ModEntities.SAPSAN_GRIM2.get()), world);
    }

    public SapsanEntity(EntityType<SapsanEntity> type, Level world) {
        super(type, world);
    }

    @Override
    public int m_19879_() {
        return super.m_19879_();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(POD_ROT, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(POD_TOGGLED, (Object)false);
    }

    public void setPodRot(float value) {
        this.f_19804_.m_135381_(POD_ROT, (Object)Float.valueOf(value));
    }

    public float getPodRot() {
        return ((Float)this.f_19804_.m_135370_(POD_ROT)).floatValue();
    }

    public void setPodToggled(boolean value) {
        this.f_19804_.m_135381_(POD_TOGGLED, (Object)value);
    }

    public boolean getPodToggled() {
        return (Boolean)this.f_19804_.m_135370_(POD_TOGGLED);
    }

    public VehicleWeapon[][] initWeapons() {
        return new VehicleWeapon[][]{{new BallisticMissileWeapon().sound((SoundEvent)ModSounds.INTO_MISSILE.get())}};
    }

    public ThirdPersonCameraPosition getThirdPersonCameraPosition(int index) {
        return new ThirdPersonCameraPosition(2.75 + ClientMouseHandler.custom3pDistanceLerp, 1.0, 0.0);
    }

    @ParametersAreNonnullByDefault
    protected void m_7355_(BlockPos pPos, BlockState pState) {
        this.m_5496_((SoundEvent)ModSounds.WHEEL_STEP.get(), (float)(this.m_20184_().m_82553_() * 0.3), this.f_19796_.m_188501_() * 0.15f + 1.05f);
    }

    public DamageModifier getDamageModifier() {
        return super.getDamageModifier().custom((source, damage) -> Float.valueOf(this.getSourceAngle((DamageSource)source, 0.25f) * damage.floatValue()));
    }

    public void m_6075_() {
        this.turretYRotO = this.getTurretYRot();
        this.rudderRotO = this.getRudderRot();
        this.leftWheelRotO = this.getLeftWheelRot();
        this.rightWheelRotO = this.getRightWheelRot();
        if (this.m_9236_() instanceof ServerLevel) {
            this.handleAmmo();
        }
        float target = this.getPodToggled() ? 90.0f : 0.0f;
        float current = this.getPodRot();
        float speed = 2.5f;
        if (Math.abs((float)(current - target)) <= speed) {
            this.setPodRot(target);
        }
        if (this.getPodToggled() && current < 90.0f) {
            this.setPodRot(current + speed);
        } else if (!this.getPodToggled() && current > 0.0f) {
            this.setPodRot(current - speed);
        }
        double fluidFloat = 0.052 * SapsanEntity.getSubmergedHeight((Entity)this);
        this.m_20256_(this.m_20184_().m_82520_(0.0, fluidFloat, 0.0));
        if (this.m_20096_()) {
            float f0 = 0.54f + 0.25f * Mth.m_14154_((float)(90.0f - (float)SapsanEntity.calculateAngle((Vec3)this.m_20184_(), (Vec3)this.m_20252_(1.0f)))) / 90.0f;
            this.m_20256_(this.m_20184_().m_82549_(this.m_20252_(1.0f).m_82541_().m_82490_(0.05 * this.m_20184_().m_82526_(this.m_20252_(1.0f)))));
            this.m_20256_(this.m_20184_().m_82542_((double)f0, 0.99, (double)f0));
        } else if (this.m_20069_()) {
            float f1 = 0.74f + 0.09f * Mth.m_14154_((float)(90.0f - (float)SapsanEntity.calculateAngle((Vec3)this.m_20184_(), (Vec3)this.m_20252_(1.0f)))) / 90.0f;
            this.m_20256_(this.m_20184_().m_82549_(this.m_20252_(1.0f).m_82541_().m_82490_(0.04 * this.m_20184_().m_82526_(this.m_20252_(1.0f)))));
            this.m_20256_(this.m_20184_().m_82542_((double)f1, 0.85, (double)f1));
        } else {
            this.m_20256_(this.m_20184_().m_82542_(0.99, 0.99, 0.99));
        }
        Level var4 = this.m_9236_();
        if (var4 instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)var4;
            if (this.m_20069_() && this.m_20184_().m_82553_() > 0.1) {
                ParticleTool.sendParticle((ServerLevel)serverLevel, (ParticleOptions)ParticleTypes.f_123796_, (double)(this.m_20185_() + 0.5 * this.m_20184_().f_82479_), (double)(this.m_20186_() + SapsanEntity.getSubmergedHeight((Entity)this) - 0.2), (double)(this.m_20189_() + 0.5 * this.m_20184_().f_82481_), (int)((int)(2.0 + 4.0 * this.m_20184_().m_82553_())), (double)0.65, (double)0.0, (double)0.65, (double)0.0, (boolean)true);
                ParticleTool.sendParticle((ServerLevel)serverLevel, (ParticleOptions)ParticleTypes.f_123774_, (double)(this.m_20185_() + 0.5 * this.m_20184_().f_82479_), (double)(this.m_20186_() + SapsanEntity.getSubmergedHeight((Entity)this) - 0.2), (double)(this.m_20189_() + 0.5 * this.m_20184_().f_82481_), (int)((int)(2.0 + 10.0 * this.m_20184_().m_82553_())), (double)0.65, (double)0.0, (double)0.65, (double)0.0, (boolean)true);
            }
        }
        this.lowHealthWarning();
        this.terrainCompact(2.7f, 3.61f);
        this.releaseSmokeDecoy(this.getTurretVector(1.0f));
        this.inertiaRotate(1.2f);
        this.m_6210_();
        super.m_6075_();
    }

    public boolean canCollideHardBlock() {
        return this.m_20184_().m_165924_() > 0.09 || (double)Mth.m_14154_((float)((Float)this.f_19804_.m_135370_(POWER)).floatValue()) > 0.15;
    }

    private void handleAmmo() {
        if (this.m_146895_() instanceof Player) {
            Stream<ItemStack> var10000 = this.m_213659_().stream().filter(stack -> {
                if (stack.m_150930_((Item)ModItems.AMMO_BOX.get())) {
                    return Ammo.RIFLE.get(stack) > 0;
                }
                return false;
            });
            Ammo var10001 = Ammo.RIFLE;
            Objects.requireNonNull(var10001);
            int ammoCount = var10000.mapToInt(stack -> var10001.get((ItemStack)stack)).sum() + this.m_18947_((Item)ModItems.RIFLE_AMMO.get());
            if (this.getWeaponIndex(0) == 0) {
                this.f_19804_.m_135381_(AMMO, (Object)this.m_18947_((Item)ModItems.SMALL_SHELL.get()));
            }
        }
    }

    public Vec3 getBarrelVector(float pPartialTicks) {
        Matrix4f transform = this.getBarrelTransform(pPartialTicks);
        Vector4f rootPosition = this.transformPosition(transform, 0.0f, 0.0f, 0.0f);
        Vector4f targetPosition = this.transformPosition(transform, 0.0f, 0.0f, 1.0f);
        return new Vec3((double)rootPosition.x, (double)rootPosition.y, (double)rootPosition.z).m_82505_(new Vec3((double)targetPosition.x, (double)targetPosition.y, (double)targetPosition.z));
    }

    public void vehicleShoot(Player player, int type) {
    }

    public void shootMissileTo(Player player, Vec3 targetPos) {
        if (!this.getPodToggled()) {
            return;
        }
        if (this.cannotFire) {
            return;
        }
        boolean hasCreativeAmmo = false;
        for (int i = 0; i < this.getMaxPassengers() - 1; ++i) {
            Player pPlayer;
            Entity y = this.getNthEntity(i);
            if (!(y instanceof Player) || !InventoryTool.hasCreativeAmmoBox((Entity)(pPlayer = (Player)y))) continue;
            hasCreativeAmmo = true;
        }
        Matrix4f transform = this.getBarrelTransform(1.0f);
        float x = this.shotToggled ? -1.0f : 1.0f;
        float y = 1.0f;
        float z = -10.0f;
        this.shotToggled = !this.shotToggled;
        Vector4f worldPosition = this.transformPosition(transform, x, y, z);
        BallisticMissileEntity missile = ((BallisticMissileWeapon)this.getWeapon(0)).create((LivingEntity)player);
        missile.m_6034_(worldPosition.x, worldPosition.y, worldPosition.z);
        missile.m_146926_(90.0f);
        missile.m_146922_(180.0f);
        missile.setTargetPosition(targetPos);
        this.m_9236_().m_7967_((Entity)missile);
        ParticleTool.sendParticle((ServerLevel)((ServerLevel)this.m_9236_()), (ParticleOptions)ParticleTypes.f_123755_, (double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z, (int)10, (double)0.1, (double)0.1, (double)0.1, (double)0.0, (boolean)false);
        if (!player.m_9236_().f_46443_) {
            this.playShootSound3p(player, 1, 10, 30, 60);
        }
        ShakeClientMessage.sendToNearbyPlayers((Entity)this, (double)6.0, (double)8.0, (double)6.0, (double)12.0);
        this.f_19804_.m_135381_(CANNON_RECOIL_TIME, (Object)60);
        this.f_19804_.m_135381_(FIRE_ANIM, (Object)3);
        if (!hasCreativeAmmo) {
            // empty if block
        }
    }

    public void travel() {
        Entity passenger0 = this.m_146895_();
        if (this.getEnergy() > 0) {
            int i;
            boolean currentInput;
            if (passenger0 == null) {
                this.leftInputDown = false;
                this.rightInputDown = false;
                this.forwardInputDown = false;
                this.backInputDown = false;
                this.sprintInputDown = false;
                this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(0.0f));
            }
            if ((currentInput = this.sprintInputDown) && !this.wasSprintInputDown) {
                this.sprintToggled = !this.sprintToggled;
                this.setPodToggled(this.sprintToggled);
            }
            this.wasSprintInputDown = currentInput;
            if (this.forwardInputDown) {
                this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(Math.min((float)(((Float)this.f_19804_.m_135370_(POWER)).floatValue() + (((Float)this.f_19804_.m_135370_(POWER)).floatValue() < 0.0f ? 0.012f : 0.0024f)), (float)0.18f)));
            }
            if (this.backInputDown) {
                this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(Math.max((float)(((Float)this.f_19804_.m_135370_(POWER)).floatValue() - (((Float)this.f_19804_.m_135370_(POWER)).floatValue() > 0.0f ? 0.012f : 0.0024f)), (float)-0.13f)));
            }
            if (this.rightInputDown) {
                this.f_19804_.m_135381_(DELTA_ROT, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue() + 0.1f));
            } else if (this.leftInputDown) {
                this.f_19804_.m_135381_(DELTA_ROT, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue() - 0.1f));
            }
            if (this.forwardInputDown || this.backInputDown) {
                this.consumeEnergy((Integer)VehicleConfig.LAV_150_ENERGY_COST.get());
            }
            this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(POWER)).floatValue() * (this.upInputDown ? 0.5f : (!this.rightInputDown && !this.leftInputDown ? 0.99f : 0.977f))));
            this.f_19804_.m_135381_(DELTA_ROT, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue() * (float)Math.max((double)((double)0.76f - (double)0.1f * this.m_20184_().m_165924_()), (double)0.3)));
            double s0 = this.m_20184_().m_82526_(this.m_20252_(1.0f));
            this.setLeftWheelRot((float)((double)this.getLeftWheelRot() - 1.25 * s0 - this.m_20184_().m_165924_() * (double)Mth.m_14036_((float)(1.5f * ((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue()), (float)-5.0f, (float)5.0f)));
            this.setRightWheelRot((float)((double)this.getRightWheelRot() - 1.25 * s0 + this.m_20184_().m_165924_() * (double)Mth.m_14036_((float)(1.5f * ((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue()), (float)-5.0f, (float)5.0f)));
            this.setRudderRot(Mth.m_14036_((float)(this.getRudderRot() - ((Float)this.f_19804_.m_135370_(DELTA_ROT)).floatValue()), (float)-0.8f, (float)0.8f) * 0.75f);
            if (((Boolean)this.f_19804_.m_135370_(L_WHEEL_DAMAGED)).booleanValue() && ((Boolean)this.f_19804_.m_135370_(R_WHEEL_DAMAGED)).booleanValue()) {
                this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(POWER)).floatValue() * 0.93f));
                i = 0;
            } else if (((Boolean)this.f_19804_.m_135370_(L_WHEEL_DAMAGED)).booleanValue()) {
                this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(POWER)).floatValue() * 0.975f));
                i = 3;
            } else if (((Boolean)this.f_19804_.m_135370_(R_WHEEL_DAMAGED)).booleanValue()) {
                this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(POWER)).floatValue() * 0.975f));
                i = -3;
            } else {
                i = 0;
            }
            if (((Boolean)this.f_19804_.m_135370_(ENGINE1_DAMAGED)).booleanValue()) {
                this.f_19804_.m_135381_(POWER, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(POWER)).floatValue() * 0.875f));
            }
            this.m_146922_((float)((double)this.m_146908_() - Math.max((double)((double)(this.m_20069_() && !this.m_20096_() ? 5 : 10) * this.m_20184_().m_165924_()), (double)0.0) * (double)this.getRudderRot() * (double)(((Float)this.f_19804_.m_135370_(POWER)).floatValue() > 0.0f ? 1 : -1) - (double)i * s0));
            if (this.m_20069_() || this.m_20096_()) {
                float power = ((Float)this.f_19804_.m_135370_(POWER)).floatValue() * Mth.m_14036_((float)(1.0f + (float)(s0 > 0.0 ? 1 : -1) * this.m_146909_() / 35.0f), (float)0.0f, (float)2.0f);
                this.m_20256_(this.m_20184_().m_82549_(this.m_20252_(1.0f).m_82490_((double)((!this.m_20069_() && !this.m_20096_() ? 0.05f : (this.m_20069_() && !this.m_20096_() ? 0.3f : 1.0f)) * power))));
            }
        }
    }

    public SoundEvent getEngineSound() {
        return (SoundEvent)ModSounds.LAV_ENGINE.get();
    }

    public float getEngineSoundVolume() {
        return Mth.m_14154_((float)((Float)this.f_19804_.m_135370_(POWER)).floatValue()) * 2.0f;
    }

    public void m_19956_(@NotNull Entity passenger, @NotNull // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull @NotNull Entity.MoveFunction callback) {
        if (this.m_20363_(passenger)) {
            Matrix4f transform = this.getVehicleTransform(1.0f);
            int i = this.getSeatIndex(passenger);
            Vector4f worldPosition = i == 0 ? this.transformPosition(transform, 1.0f, 0.8f, 6.6f) : this.transformPosition(transform, 0.0f, 1.0f, 0.0f);
            passenger.m_6034_((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
            callback.m_20372_(passenger, (double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
            this.copyEntityData(passenger);
        }
    }

    public void copyEntityData(Entity entity) {
        if (entity == this.getNthEntity(0)) {
            entity.m_5618_(this.getBarrelYRot(1.0f));
        }
    }

    public int getMaxPassengers() {
        return 3;
    }

    public Vec3 driverZoomPos(float ticks) {
        Matrix4f transform = this.getTurretTransform(ticks);
        Vector4f worldPosition = this.transformPosition(transform, 0.3f, 0.75f, 0.56f);
        return new Vec3((double)worldPosition.x, (double)worldPosition.y, (double)worldPosition.z);
    }

    public Matrix4f getBarrelTransform(float ticks) {
        Matrix4f transformT = this.getTurretTransform(ticks);
        Matrix4f transform = new Matrix4f();
        Vector4f worldPosition = this.transformPosition(transform, 0.0234375f, 0.33795f, 0.825f);
        transformT.translate(worldPosition.x, worldPosition.y, worldPosition.z);
        float a = this.getTurretYaw(ticks);
        float r = (Mth.m_14154_((float)a) - 90.0f) / 90.0f;
        float r2 = Mth.m_14154_((float)a) <= 90.0f ? a / 90.0f : (a < 0.0f ? -(180.0f + a) / 90.0f : (180.0f - a) / 90.0f);
        float x = Mth.m_14179_((float)ticks, (float)this.turretXRotO, (float)this.getTurretXRot());
        float xV = Mth.m_14179_((float)ticks, (float)this.f_19860_, (float)this.m_146909_());
        float z = Mth.m_14179_((float)ticks, (float)this.prevRoll, (float)this.getRoll());
        transformT.rotate((Quaternionfc)Axis.f_252529_.m_252977_(x + r * xV + r2 * z));
        return transformT;
    }

    public Vec3 getTurretVector(float pPartialTicks) {
        Matrix4f transform = this.getTurretTransform(pPartialTicks);
        Vector4f rootPosition = this.transformPosition(transform, 0.0f, 0.0f, 0.0f);
        Vector4f targetPosition = this.transformPosition(transform, 0.0f, 0.0f, 1.0f);
        return new Vec3((double)rootPosition.x, (double)rootPosition.y, (double)rootPosition.z).m_82505_(new Vec3((double)targetPosition.x, (double)targetPosition.y, (double)targetPosition.z));
    }

    public void destroy() {
        if (this.m_9236_() instanceof ServerLevel) {
            CustomExplosion explosion = new CustomExplosion(this.m_9236_(), (Entity)this, ModDamageTypes.causeCustomExplosionDamage((RegistryAccess)this.m_9236_().m_9598_(), (Entity)this.getAttacker(), (Entity)this.getAttacker()), 80.0f, this.m_20185_(), this.m_20186_(), this.m_20189_(), 5.0f, (Boolean)ExplosionConfig.EXPLOSION_DESTROY.get() != false ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.KEEP).setDamageMultiplier(1.0f);
            explosion.m_46061_();
            ForgeEventFactory.onExplosionStart((Level)this.m_9236_(), (Explosion)explosion);
            explosion.m_46075_(false);
            ParticleTool.spawnMediumExplosionParticles((Level)this.m_9236_(), (Vec3)this.m_20182_());
        }
        this.explodePassengers();
        super.destroy();
    }

    protected void clampRotation(Entity entity) {
        float a = this.getTurretYaw(1.0f);
        float r = (Mth.m_14154_((float)a) - 90.0f) / 90.0f;
        float r2 = Mth.m_14154_((float)a) <= 90.0f ? a / 90.0f : (a < 0.0f ? -(180.0f + a) / 90.0f : (180.0f - a) / 90.0f);
        float min = -32.5f - r * this.m_146909_() - r2 * this.getRoll();
        float max = 15.0f - r * this.m_146909_() - r2 * this.getRoll();
        float f = Mth.m_14177_((float)entity.m_146909_());
        float f1 = Mth.m_14036_((float)f, (float)min, (float)max);
        entity.f_19860_ += f1 - f;
        entity.m_146926_(entity.m_146909_() + f1 - f);
        entity.m_5618_(this.getBarrelYRot(1.0f));
    }

    public void m_7340_(@NotNull Entity entity) {
        this.clampRotation(entity);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public int mainGunRpm(Player player) {
        return 300;
    }

    public boolean canShoot(Player player) {
        if (this.getWeaponIndex(0) == 0) {
            return ((Integer)this.f_19804_.m_135370_(AMMO) > 0 || InventoryTool.hasCreativeAmmoBox((Entity)player)) && !this.cannotFire;
        }
        if (this.getWeaponIndex(0) != 1) {
            return false;
        }
        return ((Integer)this.f_19804_.m_135370_(AMMO) > 0 || InventoryTool.hasCreativeAmmoBox((Entity)player)) && !this.cannotFireCoax;
    }

    public int getAmmoCount(Player player) {
        return (Integer)this.f_19804_.m_135370_(AMMO);
    }

    public boolean banHand(Player player) {
        return true;
    }

    public boolean hidePassenger(Entity entity) {
        return false;
    }

    public int zoomFov() {
        return 3;
    }

    public int getWeaponHeat(Player player) {
        if (this.getWeaponIndex(0) == 0) {
            return (Integer)this.f_19804_.m_135370_(HEAT);
        }
        return this.getWeaponIndex(0) == 1 ? (Integer)this.f_19804_.m_135370_(COAX_HEAT) : 0;
    }

    public ResourceLocation getVehicleIcon() {
        return Mod.loc((String)"textures/vehicle_icon/lav150_icon.png");
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderFirstPersonOverlay(GuiGraphics guiGraphics, PoseStack poseStack, Font font, Player player, int screenWidth, int screenHeight, float scale, int color) {
        float minWH = Math.min((int)screenWidth, (int)screenHeight);
        float scaledMinWH = Mth.m_14143_((float)(minWH * scale));
        float centerW = ((float)screenWidth - scaledMinWH) / 2.0f;
        float centerH = ((float)screenHeight - scaledMinWH) / 2.0f;
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderThirdPersonOverlay(GuiGraphics guiGraphics, Font font, Player player, int screenWidth, int screenHeight, float scale) {
    }

    public boolean hasDecoy() {
        return true;
    }

    public double getSensitivity(double original, boolean zoom, int seatIndex, boolean isOnGround) {
        return zoom ? 0.23 : (Minecraft.m_91087_().f_91066_.m_92176_().m_90612_() ? 0.3 : 0.4);
    }

    public boolean isEnclosed(int index) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public Vec2 getCameraRotation(float partialTicks, Player player, boolean zoom, boolean isFirstPerson) {
        if (!zoom && !isFirstPerson) {
            return super.getCameraRotation(partialTicks, player, false, false);
        }
        return this.getSeatIndex((Entity)player) == 0 ? new Vec2((float)(-SapsanEntity.getYRotFromVector((Vec3)this.getBarrelVec(partialTicks))), (float)(-SapsanEntity.getXRotFromVector((Vec3)this.getBarrelVec(partialTicks)))) : new Vec2(Mth.m_14179_((float)partialTicks, (float)player.f_20886_, (float)player.m_6080_()), Mth.m_14179_((float)partialTicks, (float)player.f_19860_, (float)player.m_146909_()));
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vec3 getCameraPosition(float partialTicks, Player player, boolean zoom, boolean isFirstPerson) {
        if (!zoom && !isFirstPerson) {
            return super.getCameraPosition(partialTicks, player, false, false);
        }
        if (this.getSeatIndex((Entity)player) == 0) {
            return zoom ? new Vec3(this.driverZoomPos((float)partialTicks).f_82479_, Mth.m_14139_((double)partialTicks, (double)(player.f_19855_ + (double)player.m_20192_()), (double)player.m_20188_()), this.driverZoomPos((float)partialTicks).f_82481_) : new Vec3(Mth.m_14139_((double)partialTicks, (double)player.f_19854_, (double)player.m_20185_()), Mth.m_14139_((double)partialTicks, (double)(player.f_19855_ + (double)player.m_20192_()), (double)player.m_20188_()), Mth.m_14139_((double)partialTicks, (double)player.f_19856_, (double)player.m_20189_()));
        }
        return new Vec3(Mth.m_14139_((double)partialTicks, (double)player.f_19854_, (double)player.m_20185_()) - 6.0 * player.m_20252_((float)partialTicks).f_82479_, Mth.m_14139_((double)partialTicks, (double)(player.f_19855_ + (double)player.m_20192_() + 1.0), (double)(player.m_20188_() + 1.0)) - 6.0 * player.m_20252_((float)partialTicks).f_82480_, Mth.m_14139_((double)partialTicks, (double)player.f_19856_, (double)player.m_20189_()) - 6.0 * player.m_20252_((float)partialTicks).f_82481_);
    }

    @Nullable
    public ResourceLocation getVehicleItemIcon() {
        return Mod.loc((String)"textures/gui/vehicle/type/land.png");
    }
}

