/*
 * Decompiled with CFR 0.152.
 */
package Aru.Aru.ashvehicle.entity.weapon;

import Aru.Aru.ashvehicle.init.ModEntities;
import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.config.server.ExplosionConfig;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.network.message.receive.ClientIndicatorMessage;
import com.atsuishio.superbwarfare.tools.CustomExplosion;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.PlayMessages;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class BallisticMissileEntity
extends ThrowableProjectile
implements GeoAnimatable {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private Vec3 targetPos;
    private int flightTime;
    private int ticksLived;
    private static final double GRAVITY = 0.08;
    private int explosionDamage = 100;
    private static final TicketType<Entity> MISSILE_TICKET = TicketType.m_9462_((String)"ballistic_missile", (entity1, entity2) -> 0);
    private ChunkPos currentTicketChunk = null;
    private static final double MAX_SPEED = 4.5;
    private static final double MAX_ACCELERATION = 0.2;
    private static final double HIT_RADIUS = 1.5;

    public BallisticMissileEntity(LivingEntity shooter, Level level) {
        super((EntityType)ModEntities.BALLISTIC_MISSILE.get(), shooter, level);
    }

    public BallisticMissileEntity(EntityType<? extends BallisticMissileEntity> type, Level level) {
        super(type, level);
    }

    public BallisticMissileEntity(PlayMessages.SpawnEntity spawnEntity, Level level) {
        this((EntityType<? extends BallisticMissileEntity>)((EntityType)ModEntities.BALLISTIC_MISSILE.get()), level);
    }

    public void setTargetPosition(Vec3 targetPos) {
        this.targetPos = targetPos;
        this.ticksLived = 0;
        this.m_20256_(new Vec3(0.0, 5.0, 0.0));
    }

    public void m_8119_() {
        Level level;
        super.m_8119_();
        ++this.ticksLived;
        if (!this.m_9236_().f_46443_ && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ChunkPos newChunk = new ChunkPos(this.m_20183_());
            if (this.currentTicketChunk == null || !newChunk.equals((Object)this.currentTicketChunk)) {
                if (this.currentTicketChunk != null) {
                    serverLevel.m_7726_().m_8438_(MISSILE_TICKET, this.currentTicketChunk, 10, (Object)this);
                }
                serverLevel.m_7726_().m_8387_(MISSILE_TICKET, newChunk, 10, (Object)this);
                this.currentTicketChunk = newChunk;
            }
        }
        if (this.targetPos != null) {
            Vec3 currentPos = this.m_20182_();
            Vec3 currentVelocity = this.m_20184_();
            Vec3 toTarget = this.targetPos.m_82546_(currentPos);
            double distance = toTarget.m_82553_();
            if (distance <= 1.5 || this.m_20069_() || this.m_20096_()) {
                this.stopChank();
                this.explode();
                this.m_146870_();
                return;
            }
            Vec3 desiredDirection = toTarget.m_82541_();
            Vec3 desiredVelocity = desiredDirection.m_82490_(4.5);
            Vec3 steering = desiredVelocity.m_82546_(currentVelocity);
            if (steering.m_82553_() > 0.2) {
                steering = steering.m_82541_().m_82490_(0.07);
            }
            Vec3 gravityAccel = new Vec3(0.0, -0.08, 0.0);
            Vec3 newVelocity = currentVelocity.m_82549_(steering).m_82549_(gravityAccel);
            newVelocity = newVelocity.m_82490_(1.03);
            this.m_20256_(newVelocity);
            this.m_6478_(MoverType.SELF, newVelocity);
            if (this.ticksLived == 1 && !this.m_9236_().m_5776_()) {
                ServerLevel serverLevel = (ServerLevel)this.m_9236_();
                ParticleTool.sendParticle((ServerLevel)serverLevel, (ParticleOptions)ParticleTypes.f_123796_, (double)this.m_20185_(), (double)this.m_20186_(), (double)this.m_20189_(), (int)15, (double)0.8, (double)0.8, (double)0.8, (double)0.01, (boolean)true);
                this.m_9236_().m_5594_(null, this.m_20183_(), (SoundEvent)ModSounds.MISSILE_START.get(), SoundSource.PLAYERS, 4.0f, 1.0f);
            }
        }
    }

    public void m_8060_(BlockHitResult blockHitResult) {
        if (this.m_9236_() instanceof ServerLevel) {
            float hardness;
            double x = blockHitResult.m_82450_().f_82479_;
            double y = blockHitResult.m_82450_().f_82480_;
            double z = blockHitResult.m_82450_().f_82481_;
            if (((Boolean)ExplosionConfig.EXPLOSION_DESTROY.get()).booleanValue() && (hardness = this.m_9236_().m_8055_(BlockPos.m_274561_((double)x, (double)y, (double)z)).m_60734_().m_155943_()) <= 50.0f && hardness != -1.0f) {
                BlockPos blockPos = BlockPos.m_274561_((double)x, (double)y, (double)z);
                Block.m_49892_((BlockState)this.m_9236_().m_8055_(blockPos), (LevelAccessor)this.m_9236_(), (BlockPos)BlockPos.m_274561_((double)x, (double)y, (double)z), (BlockEntity)null);
                this.m_9236_().m_46961_(blockPos, true);
            }
            for (int i = 0; i < 5; ++i) {
                this.apExplode((HitResult)blockHitResult, i);
            }
            this.causeExplode((HitResult)blockHitResult);
            this.stopChank();
        }
    }

    protected void m_5790_(EntityHitResult result) {
        Entity entity = result.m_82443_();
        if (this.m_9236_() instanceof ServerLevel && this.f_19797_ > 8) {
            LivingEntity living;
            if (entity == this.m_19749_() || this.m_19749_() != null && entity == this.m_19749_().m_20202_()) {
                return;
            }
            Entity player1 = this.m_19749_();
            if (player1 instanceof LivingEntity && !(living = (LivingEntity)player1).m_9236_().m_5776_() && living instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)living;
                living.m_9236_().m_5594_((Player)null, living.m_20183_(), (SoundEvent)ModSounds.INDICATION.get(), SoundSource.VOICE, 1.0f, 1.0f);
                Mod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ClientIndicatorMessage(0, 5));
            }
            entity.m_6469_(ModDamageTypes.causeCustomExplosionDamage((RegistryAccess)this.m_9236_().m_9598_(), (Entity)this, (Entity)this.m_19749_()), 20.0f);
            if (entity instanceof LivingEntity) {
                entity.f_19802_ = 0;
            }
            for (int i = 0; i < 5; ++i) {
                this.apExplode((HitResult)result, i);
            }
            this.causeExplode((HitResult)result);
            this.stopChank();
            this.m_146870_();
        }
    }

    private void apExplode(HitResult result, int index) {
        CustomExplosion explosion = new CustomExplosion(this.m_9236_(), (Entity)this, ModDamageTypes.causeCustomExplosionDamage((RegistryAccess)this.m_9236_().m_9598_(), (Entity)this, (Entity)this.m_19749_()), (float)this.explosionDamage, result.m_82450_().f_82479_ + (double)index * this.m_20184_().m_82541_().f_82479_, result.m_82450_().f_82480_ + (double)index * this.m_20184_().m_82541_().f_82480_, result.m_82450_().f_82481_ + (double)index * this.m_20184_().m_82541_().f_82481_, 20.0f, (Boolean)ExplosionConfig.EXPLOSION_DESTROY.get() != false ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.KEEP).setDamageMultiplier(1.0f);
        explosion.m_46061_();
        ForgeEventFactory.onExplosionStart((Level)this.m_9236_(), (Explosion)explosion);
        explosion.m_46075_(false);
    }

    private void causeExplode(HitResult result) {
        CustomExplosion explosion = new CustomExplosion(this.m_9236_(), (Entity)this, ModDamageTypes.causeCustomExplosionDamage((RegistryAccess)this.m_9236_().m_9598_(), (Entity)this, (Entity)this.m_19749_()), (float)this.explosionDamage, this.m_20185_(), this.m_20188_(), this.m_20189_(), 20.0f, (Boolean)ExplosionConfig.EXPLOSION_DESTROY.get() != false ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.KEEP).setDamageMultiplier(1.0f);
        explosion.m_46061_();
        ForgeEventFactory.onExplosionStart((Level)this.m_9236_(), (Explosion)explosion);
        explosion.m_46075_(false);
        ParticleTool.spawnHugeExplosionParticles((Level)this.m_9236_(), (Vec3)result.m_82450_());
    }

    private void explode() {
        this.m_9236_().m_255391_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 10.0f, true, Level.ExplosionInteraction.BLOCK);
        this.stopChank();
    }

    public boolean m_20068_() {
        return false;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public double getTick(Object o) {
        return this.f_19797_;
    }

    protected void m_8097_() {
    }

    private void stopChank() {
        Level level;
        if (!this.m_9236_().f_46443_ && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.currentTicketChunk != null) {
                serverLevel.m_7726_().m_8438_(MISSILE_TICKET, this.currentTicketChunk, 10, (Object)this);
                this.currentTicketChunk = null;
            }
        }
    }

    public boolean m_142391_() {
        return true;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BallisticMissileEntity)) {
            return false;
        }
        BallisticMissileEntity other = (BallisticMissileEntity)((Object)obj);
        return this.m_19879_() == other.m_19879_();
    }

    public int hashCode() {
        return Integer.hashCode(this.m_19879_());
    }
}

