/*
 * Decompiled with CFR 0.152.
 */
package Aru.Aru.ashvehicle.entity.weapon;

import Aru.Aru.ashvehicle.init.ModEntities;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class NuclearBombEntity
extends ThrowableItemProjectile
implements GeoEntity {
    public static final EntityDataAccessor<Float> HEALTH = SynchedEntityData.m_135353_(NuclearBombEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private float explosionDamage = 100.0f;
    private float explosionRadius = 40.0f;

    public NuclearBombEntity(EntityType<? extends NuclearBombEntity> type, Level world) {
        super(type, world);
        this.f_19811_ = true;
    }

    public NuclearBombEntity(LivingEntity entity, Level level) {
        super((EntityType)ModEntities.NUCLEAR_BOMB.get(), entity, level);
    }

    public NuclearBombEntity(PlayMessages.SpawnEntity spawnEntity, Level level) {
        this((EntityType<? extends NuclearBombEntity>)((EntityType)ModEntities.NUCLEAR_BOMB.get()), level);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HEALTH, (Object)Float.valueOf(50.0f));
    }

    public void m_8060_(BlockHitResult hit) {
        if (!this.m_9236_().f_46443_) {
            this.explode();
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_ && (this.f_19797_ > 600 || ((Float)this.f_19804_.m_135370_(HEALTH)).floatValue() <= 0.0f)) {
            this.explode();
        }
    }

    protected Item m_7881_() {
        return (Item)ModItems.MEDIUM_AERIAL_BOMB.get();
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_276093_(DamageTypes.f_268671_) || source.m_276093_(DamageTypes.f_268585_) || source.m_276093_(DamageTypes.f_268722_)) {
            return false;
        }
        this.f_19804_.m_135381_(HEALTH, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(HEALTH)).floatValue() - amount));
        return super.m_6469_(source, amount);
    }

    private void explode() {
        if (!this.m_9236_().f_46443_) {
            this.m_9236_().m_254849_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 6.0f, Level.ExplosionInteraction.BLOCK);
            this.applyRadiationEffect();
            this.spawnMushroomCloudParticles();
            this.startHemisphereExplosions();
            this.startSurfaceRingExplosions();
            this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_11913_, SoundSource.AMBIENT, 10.0f, 0.5f);
        }
        this.m_146870_();
    }

    private void applyRadiationEffect() {
        AABB area = new AABB(this.m_20183_()).m_82400_(35.0);
        for (LivingEntity entity : this.m_9236_().m_45976_(LivingEntity.class, area)) {
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 600, 2));
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 1200, 1));
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 200));
        }
    }

    private void spawnMushroomCloudParticles() {
        BlockPos pos = this.m_20183_();
        for (int i = 0; i < 20; ++i) {
            double radius = 3.0 + (double)i * 0.25;
            double y = (double)pos.m_123342_() + (double)i * 0.3;
            for (int angle = 0; angle < 360; angle += 45) {
                double rad = Math.toRadians(angle);
                double x = (double)pos.m_123341_() + 0.5 + radius * Math.cos(rad);
                double z = (double)pos.m_123343_() + 0.5 + radius * Math.sin(rad);
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123755_, x, y, z, 0.0, 0.05, 0.0);
            }
        }
    }

    private void startHemisphereExplosions() {
        BlockPos center = this.m_20183_();
        int step = 16;
        int maxRadius = (int)this.explosionRadius;
        for (int r = step; r <= maxRadius; r += step) {
            int currentRadius = r;
            for (int x = -currentRadius; x <= currentRadius; x += step) {
                for (int y = 0; y <= currentRadius; y += step) {
                    for (int z = -currentRadius; z <= currentRadius; z += step) {
                        double distance = Math.sqrt(x * x + y * y + z * z);
                        if (!(distance >= (double)(currentRadius - step)) || !(distance <= (double)currentRadius + 0.5)) continue;
                        BlockPos pos = center.m_7918_(x, -y, z);
                        this.m_9236_().m_255391_((Entity)this, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 14.0f, false, Level.ExplosionInteraction.BLOCK);
                    }
                }
            }
        }
    }

    private void startSurfaceRingExplosions() {
        int step;
        BlockPos center = this.m_20183_();
        int maxRadius = 80;
        for (int radius = step = 8; radius <= maxRadius; radius += step) {
            for (int i = 0; i < 360; i += 12) {
                double angle = Math.toRadians(i);
                double dx = (double)radius * Math.cos(angle);
                double dz = (double)radius * Math.sin(angle);
                BlockPos pos = center.m_7918_((int)dx, 0, (int)dz);
                BlockPos ground = this.m_9236_().m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, pos);
                this.m_9236_().m_255391_((Entity)this, (double)ground.m_123341_() + 0.5, (double)ground.m_123342_() + 0.5, (double)ground.m_123343_() + 0.5, 14.0f, false, Level.ExplosionInteraction.BLOCK);
            }
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean m_6087_() {
        return true;
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128350_("Health", ((Float)this.f_19804_.m_135370_(HEALTH)).floatValue());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("Health")) {
            this.f_19804_.m_135381_(HEALTH, (Object)Float.valueOf(tag.m_128457_("Health")));
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void setExplosionDamage(float damage) {
        this.explosionDamage = damage;
    }

    public void setExplosionRadius(float radius) {
        this.explosionRadius = radius;
    }

    public float getVolume() {
        return 0.7f;
    }

    public SoundEvent getSound() {
        return (SoundEvent)ModSounds.SHELL_FLY.get();
    }

    public SoundEvent getCloseSound() {
        return SoundEvents.f_271165_;
    }

    protected float m_7139_() {
        return 0.06f;
    }
}

