/*
 * Decompiled with CFR 0.152.
 */
package Aru.Aru.ashvehicle.init;

import Aru.Aru.ashvehicle.entity.Class.BaseAircraftEntity;
import Aru.Aru.ashvehicle.entity.vehicle.GepardEntity;
import Aru.Aru.ashvehicle.entity.vehicle.ZumwaltEntity;
import Aru.Aru.ashvehicle.init.ClientTargetingData;
import Aru.Aru.ashvehicle.init.ModEntities;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="ashvehicle", value={Dist.CLIENT})
public class ClientEntityHighlighter {
    @SubscribeEvent
    public static void onRenderGuiOverlay(RenderGuiOverlayEvent.Post event) {
        boolean isAllowedVehicle;
        List<Entity> lockedTargets = ClientTargetingData.getLockedTargets();
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        Entity vehicle = player.m_20202_();
        if (player == null || vehicle == null) {
            return;
        }
        boolean bl = isAllowedVehicle = vehicle instanceof GepardEntity || vehicle instanceof ZumwaltEntity || vehicle instanceof BaseAircraftEntity;
        if (!isAllowedVehicle) {
            return;
        }
        float bulletSpeed = 35.0f;
        Vec3 shooterPos = new Vec3(player.m_20185_(), player.m_20188_(), player.m_20189_());
        Set<EntityType> excludedTypes = Set.of((EntityType)com.atsuishio.superbwarfare.init.ModEntities.SMALL_CANNON_SHELL.get(), (EntityType)com.atsuishio.superbwarfare.init.ModEntities.SMALL_ROCKET.get(), (EntityType)com.atsuishio.superbwarfare.init.ModEntities.CANNON_SHELL.get(), (EntityType)com.atsuishio.superbwarfare.init.ModEntities.GUN_GRENADE.get(), (EntityType)com.atsuishio.superbwarfare.init.ModEntities.PROJECTILE.get(), (EntityType)com.atsuishio.superbwarfare.init.ModEntities.AGM_65.get(), (EntityType)com.atsuishio.superbwarfare.init.ModEntities.RPG_ROCKET.get(), (EntityType)com.atsuishio.superbwarfare.init.ModEntities.WG_MISSILE.get(), (EntityType)com.atsuishio.superbwarfare.init.ModEntities.JAVELIN_MISSILE.get(), (EntityType)com.atsuishio.superbwarfare.init.ModEntities.HAND_GRENADE.get(), (EntityType)com.atsuishio.superbwarfare.init.ModEntities.RGO_GRENADE.get(), (EntityType)com.atsuishio.superbwarfare.init.ModEntities.MELON_BOMB.get(), (EntityType)com.atsuishio.superbwarfare.init.ModEntities.MORTAR_SHELL.get(), (EntityType)com.atsuishio.superbwarfare.init.ModEntities.MORTAR.get(), (EntityType)com.atsuishio.superbwarfare.init.ModEntities.LASER.get(), (EntityType)com.atsuishio.superbwarfare.init.ModEntities.FLARE_DECOY.get(), (EntityType)com.atsuishio.superbwarfare.init.ModEntities.SMOKE_DECOY.get(), (EntityType)com.atsuishio.superbwarfare.init.ModEntities.CLAYMORE.get(), (EntityType)com.atsuishio.superbwarfare.init.ModEntities.BLU_43.get(), (EntityType)com.atsuishio.superbwarfare.init.ModEntities.TM_62.get(), (EntityType)com.atsuishio.superbwarfare.init.ModEntities.C_4.get(), (EntityType)com.atsuishio.superbwarfare.init.ModEntities.WATER_MASK.get(), (EntityType)com.atsuishio.superbwarfare.init.ModEntities.TASER_BULLET.get(), (EntityType)com.atsuishio.superbwarfare.init.ModEntities.MK_82.get(), (EntityType)com.atsuishio.superbwarfare.init.ModEntities.MK_42.get(), (EntityType)ModEntities.AAM_4.get(), (EntityType)ModEntities.GBU_57.get(), player.m_6095_());
        Set<EntityType> stealthTypes = Set.of((EntityType)ModEntities.F_35.get(), (EntityType)ModEntities.B_2.get(), (EntityType)ModEntities.F_22.get(), (EntityType)ModEntities.F_117.get(), (EntityType)ModEntities.SU_57.get(), player.m_6095_());
        Set<String> allowedNamespaces = Set.of("superbwarfare", "ashvehicle", "vvp");
        List targets = vehicle.m_9236_().m_6249_((Entity)player, player.m_20191_().m_82400_(1028.0), arg_0 -> ClientEntityHighlighter.lambda$onRenderGuiOverlay$0((Player)player, vehicle, allowedNamespaces, excludedTypes, arg_0));
        GuiGraphics guiGraphics = event.getGuiGraphics();
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172811_);
        for (Entity target : targets) {
            int size;
            float fov = ((Integer)mc.f_91066_.m_231837_().m_231551_()).intValue();
            Vec3 targetPos = target.m_20191_().m_82399_();
            Vec3 screenPos = ClientEntityHighlighter.worldToScreen(targetPos, mc, event.getPartialTick(), fov);
            if (screenPos == null) continue;
            int n = size = stealthTypes.contains(target.m_6095_()) ? 6 : 10;
            if (lockedTargets.contains(target)) {
                ClientEntityHighlighter.drawRectFrame(guiGraphics, (int)screenPos.f_82479_, (int)screenPos.f_82480_, size, -256);
            } else {
                ClientEntityHighlighter.drawRectFrame(guiGraphics, (int)screenPos.f_82479_, (int)screenPos.f_82480_, size, -16711936);
            }
            Vec3 targetVelocity = target.m_20184_();
            Vec3 interceptPoint = ClientEntityHighlighter.calculateInterceptPoint(shooterPos, targetPos, targetVelocity, bulletSpeed);
            Vec3 interceptScreenPos = ClientEntityHighlighter.worldToScreen(interceptPoint, mc, event.getPartialTick(), fov);
            if (interceptScreenPos == null) continue;
            int interceptSize = size - 2;
            ClientEntityHighlighter.drawRectFrameRotated(guiGraphics, poseStack, (int)interceptScreenPos.f_82479_, (int)interceptScreenPos.f_82480_, interceptSize, 35.0f, -65536);
        }
        poseStack.m_85849_();
        RenderSystem.disableBlend();
    }

    private static void drawRectFrameRotated(GuiGraphics guiGraphics, PoseStack poseStack, int centerX, int centerY, int size, float angleDegrees, int color) {
        poseStack.m_85836_();
        poseStack.m_252880_((float)centerX, (float)centerY, 0.0f);
        poseStack.m_252781_(Axis.f_252403_.m_252977_(angleDegrees));
        poseStack.m_252880_((float)(-centerX), (float)(-centerY), 0.0f);
        int half = size / 2;
        int left = centerX - half;
        int top = centerY - half;
        int right = centerX + half;
        int bottom = centerY + half;
        guiGraphics.m_280509_(left, top, right, top + 1, color);
        guiGraphics.m_280509_(left, bottom - 1, right, bottom, color);
        guiGraphics.m_280509_(left, top, left + 1, bottom, color);
        guiGraphics.m_280509_(right - 1, top, right, bottom, color);
        poseStack.m_85849_();
    }

    private static void drawRectFrame(GuiGraphics guiGraphics, int centerX, int centerY, int size, int color) {
        int half = size / 2;
        int left = centerX - half;
        int top = centerY - half;
        int right = centerX + half;
        int bottom = centerY + half;
        guiGraphics.m_280509_(left, top, right, top + 1, color);
        guiGraphics.m_280509_(left, bottom - 1, right, bottom, color);
        guiGraphics.m_280509_(left, top, left + 1, bottom, color);
        guiGraphics.m_280509_(right - 1, top, right, bottom, color);
    }

    private static Vec3 worldToScreen(Vec3 worldPos, Minecraft mc, float partialTicks, float fov) {
        Camera camera = mc.f_91063_.m_109153_();
        Vec3 camPos = camera.m_90583_();
        Vec3 rel = worldPos.m_82546_(camPos);
        float yaw = (float)Math.toRadians(-camera.m_90590_());
        float pitch = (float)Math.toRadians(-camera.m_90589_());
        double x1 = rel.f_82479_;
        double y1 = rel.f_82480_;
        double z1 = rel.f_82481_;
        double x2 = Math.cos(yaw) * x1 - Math.sin(yaw) * z1;
        double z2 = Math.sin(yaw) * x1 + Math.cos(yaw) * z1;
        double y2 = Math.cos(pitch) * y1 - Math.sin(pitch) * z2;
        double z3 = Math.sin(pitch) * y1 + Math.cos(pitch) * z2;
        int screenWidth = mc.m_91268_().m_85445_();
        int screenHeight = mc.m_91268_().m_85446_();
        double fovRad = Math.toRadians(fov);
        double scale = (double)screenHeight / (2.0 * Math.tan(fovRad / 2.0));
        if (z3 <= 0.01) {
            return null;
        }
        double screenX = (double)screenWidth / 2.0 - x2 * scale / z3;
        double screenY = (double)screenHeight / 2.0 - y2 * scale / z3;
        if (screenX < 0.0 || screenX >= (double)screenWidth || screenY < 0.0 || screenY >= (double)screenHeight) {
            return null;
        }
        return new Vec3(screenX, screenY, 0.0);
    }

    public static Vec3 calculateInterceptPoint(Vec3 shooterPos, Vec3 targetPos, Vec3 targetVel, float bulletSpeed) {
        double t2;
        double c;
        Vec3 displacement = targetPos.m_82546_(shooterPos);
        double a = targetVel.m_82526_(targetVel) - (double)(bulletSpeed * bulletSpeed);
        double b = 2.0 * displacement.m_82526_(targetVel);
        double discriminant = b * b - 4.0 * a * (c = displacement.m_82526_(displacement));
        if (discriminant < 0.0 || Math.abs(a) < 1.0E-6) {
            return targetPos;
        }
        double sqrtDisc = Math.sqrt(discriminant);
        double t1 = (-b - sqrtDisc) / (2.0 * a);
        double t = Math.min(t1, t2 = (-b + sqrtDisc) / (2.0 * a));
        if (t < 0.0) {
            t = Math.max(t1, t2);
        }
        if (t < 0.0) {
            return targetPos;
        }
        return targetPos.m_82549_(targetVel.m_82490_(t));
    }

    private static /* synthetic */ boolean lambda$onRenderGuiOverlay$0(Player player, Entity vehicle, Set allowedNamespaces, Set excludedTypes, Entity e) {
        if (e == player || e == vehicle || !e.m_6084_()) {
            return false;
        }
        ResourceLocation rl = ForgeRegistries.ENTITY_TYPES.getKey((Object)e.m_6095_());
        if (rl == null) {
            return false;
        }
        if (!allowedNamespaces.contains(rl.m_135827_())) {
            return false;
        }
        return !excludedTypes.contains(e.m_6095_());
    }
}

