/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.wireless.redstone;

import com.lothrazar.cyclic.block.laser.RenderLaser;
import com.lothrazar.cyclic.block.wireless.redstone.TileWirelessTransmit;
import com.lothrazar.cyclic.data.PreviewOutlineType;
import com.lothrazar.library.core.BlockPosDim;
import com.lothrazar.library.render.type.FakeBlockRenderTypes;
import com.lothrazar.library.util.LevelWorldUtil;
import com.lothrazar.library.util.RenderBlockUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class RenderTransmit
implements BlockEntityRenderer<TileWirelessTransmit> {
    public RenderTransmit(BlockEntityRendererProvider.Context d) {
    }

    public static void draw(int slot, TileWirelessTransmit tile, PoseStack matrixStackIn, MultiBufferSource bufferIn) {
        BlockPosDim posPosTarget = tile.getTargetInSlot(slot);
        if (posPosTarget == null) {
            return;
        }
        if (!LevelWorldUtil.dimensionIsEqual((BlockPosDim)posPosTarget, (Level)tile.m_58904_())) {
            return;
        }
        BlockPos posTarget = posPosTarget.getPos();
        if (posTarget == null || posTarget.equals((Object)BlockPos.f_121853_)) {
            return;
        }
        matrixStackIn.m_85836_();
        Matrix4f positionMatrix = matrixStackIn.m_85850_().m_252922_();
        BlockPos tilePos = tile.m_58899_();
        Vector3f from = new Vector3f((float)posTarget.m_123341_() + 0.5f - (float)tilePos.m_123341_(), (float)posTarget.m_123342_() + 0.5f - (float)tilePos.m_123342_(), (float)posTarget.m_123343_() + 0.5f - (float)tilePos.m_123343_());
        Vector3f to = new Vector3f(0.5f, 0.5f, 0.5f);
        VertexConsumer builder = bufferIn.m_6299_(FakeBlockRenderTypes.LASER_MAIN_BEAM);
        RenderLaser.drawDirewolfLaser(builder, positionMatrix, from, to, tile.getRed(), tile.getGreen(), tile.getBlue(), tile.getAlpha(), tile.getThick(), tilePos);
        float coreThick = 0.01f;
        RenderLaser.drawDirewolfLaser(builder, positionMatrix, from, to, 1.0f, 1.0f, 1.0f, tile.getAlpha(), 0.01f, tilePos);
        matrixStackIn.m_85849_();
    }

    public boolean shouldRenderOffScreen(TileWirelessTransmit te) {
        return true;
    }

    public void render(TileWirelessTransmit te, float v, PoseStack matrixStack, MultiBufferSource iRenderTypeBuffer, int partialTicks, int destroyStage) {
        int slot;
        if (te.requiresRedstone() && !te.isPowered()) {
            return;
        }
        int previewType = te.getField(TileWirelessTransmit.Fields.RENDER.ordinal());
        if (previewType <= 0) {
            return;
        }
        ArrayList<BlockPos> shape = new ArrayList<BlockPos>();
        String dimensionId = LevelWorldUtil.dimensionToString((Level)te.m_58904_());
        for (slot = 0; slot < te.inventory.getSlots(); ++slot) {
            BlockPosDim dimPosSaved = te.getTargetInSlot(slot);
            if (dimPosSaved == null || !dimPosSaved.getDimension().equalsIgnoreCase(dimensionId)) continue;
            shape.add(dimPosSaved.getPos());
        }
        if (PreviewOutlineType.WIREFRAME.ordinal() == previewType) {
            for (BlockPos crd : shape) {
                RenderBlockUtils.createBox((PoseStack)matrixStack, (BlockPos)crd, (Vec3)Vec3.m_82528_((Vec3i)te.m_58899_()));
            }
        } else {
            for (slot = 0; slot < te.inventory.getSlots(); ++slot) {
                RenderTransmit.draw(slot, te, matrixStack, iRenderTypeBuffer);
            }
        }
    }
}

