/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.enchant;

import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.config.ConfigRegistry;
import com.lothrazar.library.enchant.EnchantmentFlib;
import com.lothrazar.library.util.EnchantUtil;
import com.lothrazar.library.util.FakePlayerUtil;
import com.lothrazar.library.util.StringParseUtil;
import java.util.Collections;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.registries.ForgeRegistries;

public class GloomCurseEnchant
extends EnchantmentFlib {
    public static final double BASE_ACTIVATION_CHANCE = 0.1;
    public static final double BASE_APPLY_CHANCE = 0.3;
    public static final double MIN_EFFECTS = 1.0;
    public static final double MAX_EFFECTS = 3.0;
    public static final int EFFECT_DURATION = 100;
    public static ForgeConfigSpec.BooleanValue CFG;
    public static final String ID = "curse";

    public GloomCurseEnchant(Enchantment.Rarity rarityIn, EnchantmentCategory typeIn, EquipmentSlot ... slots) {
        super(rarityIn, typeIn, slots);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public boolean isEnabled() {
        return (Boolean)CFG.get();
    }

    public int m_6586_() {
        return 1;
    }

    public boolean m_6594_() {
        return this.isEnabled() && super.m_6594_();
    }

    public boolean m_6592_() {
        return this.isEnabled() && super.m_6592_();
    }

    public boolean isAllowedOnBooks() {
        return this.isEnabled() && super.isAllowedOnBooks();
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return this.isEnabled() && super.canApplyAtEnchantingTable(stack);
    }

    public boolean m_6081_(ItemStack stack) {
        return this.isEnabled() && stack.m_41720_() instanceof ArmorItem;
    }

    public void m_7675_(LivingEntity user, Entity attacker, int level) {
        if (user.m_9236_().f_46443_ || !(attacker instanceof LivingEntity) || FakePlayerUtil.isFakePlayer((Entity)attacker)) {
            return;
        }
        LivingEntity livingAttacker = (LivingEntity)attacker;
        int totalLevels = this.getCurrentArmorLevelSlot(user, EquipmentSlot.HEAD) + this.getCurrentArmorLevelSlot(user, EquipmentSlot.CHEST) + this.getCurrentArmorLevelSlot(user, EquipmentSlot.LEGS) + this.getCurrentArmorLevelSlot(user, EquipmentSlot.FEET);
        double adjustedActivationChance = 0.1 / (double)totalLevels;
        if (adjustedActivationChance > user.m_9236_().f_46441_.m_188500_()) {
            List negativeEffects = EnchantUtil.getNegativeEffects();
            Collections.shuffle(negativeEffects);
            int appliedEffects = 0;
            for (MobEffect effect : negativeEffects) {
                if (effect == null) continue;
                ResourceLocation effectKey = ForgeRegistries.MOB_EFFECTS.getKey((Object)effect);
                if (StringParseUtil.isInList(ConfigRegistry.getGloomIgnoreList(), (ResourceLocation)effectKey)) {
                    ModCyclic.LOGGER.info("Gloom(curse) effect cannot apply " + effectKey);
                    continue;
                }
                if (!((double)appliedEffects < 1.0) && !(0.3 > user.m_9236_().f_46441_.m_188500_())) continue;
                livingAttacker.m_7292_(new MobEffectInstance(effect, 100));
                if (!((double)(++appliedEffects) >= 3.0)) continue;
                break;
            }
        }
        super.m_7675_(user, attacker, level);
    }
}

