/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.gui;

import com.lothrazar.cyclic.registry.TextureRegistry;
import java.util.ArrayList;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class TimerBar {
    private Font font;
    private int x = 20;
    private int y = 98;
    public int capacity;
    public int width = 26;
    private int height = 14;
    public int guiLeft;
    public int guiTop;
    public boolean showText = true;
    public boolean visible = true;

    public TimerBar(Font parent, int x, int y, int cap) {
        this.font = parent;
        this.x = x;
        this.y = y;
        this.capacity = cap;
    }

    public boolean isMouseover(int mouseX, int mouseY) {
        return this.guiLeft + this.x < mouseX && mouseX < this.guiLeft + this.x + this.width && this.guiTop + this.y < mouseY && mouseY < this.guiTop + this.y + this.height;
    }

    public void draw(GuiGraphics gg, float timer) {
        if (!this.visible) {
            return;
        }
        float pct = Math.min(timer / (float)this.capacity, 1.0f);
        gg.m_280163_(TextureRegistry.PROGRESS, this.guiLeft + this.x, this.guiTop + this.y, 0.0f, 0.0f, (int)((float)this.width * pct), this.height, this.width, this.height);
        if (this.showText) {
            gg.m_280488_(this.font, "[" + (int)timer + "]", this.guiLeft + this.x + 2, this.guiTop + this.y + 4, 4209792);
        }
    }

    public void renderHoveredToolTip(GuiGraphics gg, int mouseX, int mouseY, int curr) {
        if (this.isMouseover(mouseX, mouseY) && this.visible) {
            Object display = "";
            int seconds = curr / 20;
            if (curr > 2400) {
                int minutes = seconds / 60;
                int remainder = seconds % 60;
                display = minutes + "m " + remainder + "s";
            } else {
                display = curr > 400 ? seconds + "s" : "" + curr;
            }
            ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
            list.add(Component.m_237115_((String)display));
            gg.m_280666_(this.font, list, mouseX, mouseY);
        }
    }
}

