/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.item.ender;

import com.lothrazar.cyclic.item.ItemBaseCyclic;
import com.lothrazar.cyclic.registry.SoundRegistry;
import com.lothrazar.library.core.IHasClickToggle;
import com.lothrazar.library.util.ChatUtil;
import com.lothrazar.library.util.EntityUtil;
import com.lothrazar.library.util.ItemStackUtil;
import com.lothrazar.library.util.SoundUtil;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class EnderWingItem
extends ItemBaseCyclic
implements IHasClickToggle {
    private static final int COOLDOWN = 600;

    public EnderWingItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        if (worldIn.f_46443_ || playerIn.m_36335_().m_41519_((Item)this)) {
            return super.m_7203_(worldIn, playerIn, handIn);
        }
        this.attemptTeleport(worldIn, playerIn, playerIn.m_21120_(handIn));
        return super.m_7203_(worldIn, playerIn, handIn);
    }

    private void attemptTeleport(Level worldIn, Player playerIn, ItemStack held) {
        BlockPos respawnPos;
        ServerPlayer serverPlayerEntity;
        ServerLevel serverWorld = worldIn.m_7654_().m_129880_(Level.f_46428_);
        ServerPlayer serverPlayer = serverPlayerEntity = playerIn instanceof ServerPlayer ? (ServerPlayer)playerIn : null;
        if (serverWorld != null && serverPlayerEntity != null && (respawnPos = serverPlayerEntity.m_8961_()) != null) {
            Optional optional = Player.m_36130_((ServerLevel)serverWorld, (BlockPos)respawnPos, (float)0.0f, (boolean)true, (boolean)true);
            boolean needsTeleport = false;
            if (optional.isPresent()) {
                BlockPos pos = new BlockPos((int)((Vec3)optional.get()).m_7096_(), (int)((Vec3)optional.get()).m_7098_(), (int)((Vec3)optional.get()).m_7094_());
                ResourceKey spawnWorldKey = serverPlayerEntity.m_8963_();
                ServerLevel spawnWorld = worldIn.m_7654_().m_129880_(spawnWorldKey);
                if (spawnWorld != null && spawnWorldKey == Level.f_46429_) {
                    if (worldIn.m_46472_() == Level.f_46429_) {
                        needsTeleport = true;
                    } else {
                        ChatUtil.sendStatusMessage((Player)playerIn, (String)"command.cyclic.home.nether");
                    }
                } else if (spawnWorld != null && spawnWorldKey == Level.f_46428_) {
                    if (worldIn.m_46472_() == Level.f_46428_) {
                        needsTeleport = true;
                    } else {
                        ChatUtil.sendStatusMessage((Player)playerIn, (String)"command.cyclic.home.overworld");
                    }
                }
                if (needsTeleport) {
                    ItemStackUtil.damageItem((LivingEntity)playerIn, (ItemStack)held);
                    playerIn.m_36335_().m_41524_((Item)this, 600);
                    EntityUtil.enderTeleportEvent((LivingEntity)playerIn, (Level)spawnWorld, (BlockPos)pos);
                    SoundUtil.playSound((Entity)playerIn, (SoundEvent)((SoundEvent)SoundRegistry.WARP_ECHO.get()));
                }
            } else {
                ChatUtil.sendStatusMessage((Player)playerIn, (String)"command.cyclic.home.obstructed");
            }
        }
    }

    public void toggle(Player player, ItemStack held) {
        this.attemptTeleport(player.m_9236_(), player, held);
    }

    public boolean isOn(ItemStack held) {
        return false;
    }
}

