/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.item.equipment;

import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.item.ItemBaseCyclic;
import com.lothrazar.cyclic.render.ShieldBlockEntityWithoutLevelRenderer;
import com.lothrazar.library.util.ItemStackUtil;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.living.ShieldBlockEvent;

public class ShieldCyclicItem
extends ItemBaseCyclic {
    public static final ResourceLocation BLOCKING = new ResourceLocation("minecraft:blocking");
    public static ForgeConfigSpec.IntValue LEATHER_PCT;
    public static ForgeConfigSpec.IntValue WOOD_PCT;
    public static ForgeConfigSpec.IntValue FLINT_PCT;
    public static ForgeConfigSpec.IntValue FLINT_THORNS_PCT;
    private ShieldType type;

    public ShieldCyclicItem(Item.Properties properties, ShieldType type) {
        super(properties);
        this.type = type;
        DispenserBlock.m_52672_((ItemLike)this, (DispenseItemBehavior)ArmorItem.f_40376_);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }

    public boolean m_6832_(ItemStack stackShield, ItemStack stackIngredient) {
        if (this.type == ShieldType.WOOD) {
            return stackIngredient.m_150930_(Items.f_42398_);
        }
        if (this.type == ShieldType.LEATHER) {
            return stackIngredient.m_150930_(Items.f_42454_);
        }
        if (this.type == ShieldType.BONE) {
            return stackIngredient.m_150930_(Items.f_42500_);
        }
        if (this.type == ShieldType.OBSIDIAN) {
            return stackIngredient.m_150930_(Blocks.f_50080_.m_5456_());
        }
        if (this.type == ShieldType.FLINT) {
            return stackIngredient.m_204117_(ItemTags.f_13165_);
        }
        return false;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BLOCK;
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return ToolActions.DEFAULT_SHIELD_ACTIONS.contains(toolAction) || toolAction.equals(ToolActions.SHIELD_BLOCK);
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player playerIn, InteractionHand hand) {
        ItemStack itemstack = playerIn.m_21120_(hand);
        playerIn.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)itemstack);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return ShieldBlockEntityWithoutLevelRenderer.instance;
            }
        });
    }

    public void onShieldBlock(ShieldBlockEvent event, Player playerIn) {
        Entity enemy;
        LivingEntity shieldHolder = event.getEntity();
        ItemStack shield = shieldHolder.m_21211_();
        DamageSource dmgSource = event.getDamageSource();
        int thornsDmg = 0;
        int cooldown = 1;
        float reduceBlockedDamagePct = 1.0f;
        boolean immuneToDamage = false;
        boolean isDestroyed = false;
        switch (this.type) {
            case LEATHER: {
                cooldown = 6;
                reduceBlockedDamagePct = (float)((Integer)LEATHER_PCT.get()).intValue() / 100.0f;
                if (!dmgSource.m_276093_(DamageTypes.f_268565_)) break;
                immuneToDamage = true;
                break;
            }
            case WOOD: {
                cooldown = 10;
                reduceBlockedDamagePct = (float)((Integer)WOOD_PCT.get()).intValue() / 100.0f;
                if (!dmgSource.m_276093_(DamageTypes.f_268565_)) break;
                isDestroyed = true;
                break;
            }
            case FLINT: {
                cooldown = 4;
                reduceBlockedDamagePct = (float)((Integer)FLINT_PCT.get()).intValue() / 100.0f;
                if (dmgSource.m_276093_(DamageTypes.f_268534_)) {
                    boolean bl = immuneToDamage = playerIn.m_9236_().f_46441_.m_188500_() < 0.5;
                }
                if (dmgSource.m_276093_(DamageTypes.f_268565_) || !dmgSource.m_276093_(DamageTypes.f_268534_) || !(playerIn.m_9236_().f_46441_.m_188500_() < (double)((float)((Integer)FLINT_THORNS_PCT.get()).intValue() / 100.0f))) break;
                thornsDmg = 1;
                break;
            }
            case BONE: {
                cooldown = 2;
                if (!dmgSource.m_276093_(DamageTypes.f_268534_)) break;
                immuneToDamage = true;
                break;
            }
            case OBSIDIAN: {
                reduceBlockedDamagePct = 0.0f;
                cooldown = 0;
                if (dmgSource.m_276093_(DamageTypes.f_268534_)) {
                    immuneToDamage = true;
                }
                if (!dmgSource.m_276093_(DamageTypes.f_268565_)) break;
                immuneToDamage = true;
            }
        }
        if (immuneToDamage) {
            event.setShieldTakesDamage(false);
        }
        if (isDestroyed && playerIn != null) {
            ItemStackUtil.damageItem((LivingEntity)playerIn, (ItemStack)shield);
        }
        event.setBlockedDamage(event.getBlockedDamage() * reduceBlockedDamagePct);
        ModCyclic.LOGGER.info(this + " original damage " + event.getOriginalBlockedDamage() + " :set Blocked Damage " + event.getBlockedDamage());
        if (playerIn != null && cooldown > 0) {
            playerIn.m_36335_().m_41524_(shield.m_41720_(), cooldown);
        }
        if (thornsDmg > 0 && event.getDamageSource().m_7640_() != null && (enemy = event.getDamageSource().m_7640_()) instanceof LivingEntity) {
            LivingEntity liv = (LivingEntity)enemy;
            enemy.m_6469_(playerIn.m_9236_().m_269111_().m_269374_((Entity)shieldHolder), (float)thornsDmg);
        }
    }

    public void onKnockback(LivingKnockBackEvent event) {
        switch (this.type) {
            case BONE: {
                break;
            }
            case OBSIDIAN: {
                event.setCanceled(true);
                break;
            }
            case FLINT: {
                break;
            }
            case LEATHER: {
                break;
            }
            case WOOD: {
                event.setStrength(event.getStrength() * 1.5f);
                break;
            }
        }
    }

    public static enum ShieldType {
        LEATHER,
        WOOD,
        FLINT,
        OBSIDIAN,
        BONE;

    }
}

