/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.net;

import com.lothrazar.cyclic.block.facade.IBlockFacade;
import com.lothrazar.cyclic.block.facade.ITileFacade;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkEvent;

public class BlockFacadeMessage {
    private BlockPos pos;
    private boolean erase = false;
    private CompoundTag blockStateTag = new CompoundTag();

    private BlockFacadeMessage() {
    }

    public BlockFacadeMessage(BlockPos pos, CompoundTag state) {
        this.pos = pos;
        this.blockStateTag = state;
        this.erase = false;
    }

    public BlockFacadeMessage(BlockPos pos, boolean eraseIn) {
        this.pos = pos;
        this.erase = eraseIn;
        this.blockStateTag = new CompoundTag();
    }

    public static void handle(BlockFacadeMessage message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            ServerLevel serverWorld = (ServerLevel)player.m_9236_();
            BlockState bs = serverWorld.m_8055_(message.pos);
            Block patt1346$temp = bs.m_60734_();
            if (patt1346$temp instanceof IBlockFacade) {
                IBlockFacade facadeBlock = (IBlockFacade)patt1346$temp;
                ITileFacade tile = facadeBlock.getTileFacade((BlockGetter)serverWorld, message.pos);
                if (message.erase) {
                    tile.setFacade(new CompoundTag());
                } else {
                    tile.setFacade(message.blockStateTag);
                }
                serverWorld.markAndNotifyBlock(message.pos, serverWorld.m_46745_(message.pos), bs, bs, 3, 1);
                serverWorld.m_7260_(message.pos, bs, bs, 3);
                serverWorld.m_6289_(message.pos, bs.m_60734_());
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static BlockFacadeMessage decode(FriendlyByteBuf buf) {
        BlockFacadeMessage message = new BlockFacadeMessage();
        message.erase = buf.readBoolean();
        message.pos = buf.m_130135_();
        message.blockStateTag = buf.m_130260_();
        return message;
    }

    public static void encode(BlockFacadeMessage msg, FriendlyByteBuf buf) {
        buf.writeBoolean(msg.erase);
        buf.m_130064_(msg.pos);
        buf.m_130079_(msg.blockStateTag);
    }
}

