/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.citycraft.blocks;

import java.util.function.ToIntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RedstoneTorchBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;
import xxrexraptorxx.citycraft.registry.ModBlocks;

public class TrafficLightBlock
extends HorizontalDirectionalBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty LIT = RedstoneTorchBlock.f_55674_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape TRIPPE = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    private static final VoxelShape DOUBLE = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);
    private static final VoxelShape SINGLE = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0);
    private static final VoxelShape SIDE_EAST_WEST = Block.m_49796_((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)8.0, (double)16.0);
    private static final VoxelShape SIDE_NORTH_SOUTH = Block.m_49796_((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)8.0, (double)12.0);

    public TrafficLightBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_60999_().m_60978_(0.5f).m_60918_(SoundType.f_56743_).m_284268_(DyeColor.GRAY).m_280658_(NoteBlockInstrument.PLING).m_60953_(TrafficLightBlock.litBlockEmission(2)).m_60999_());
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true))).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        String blockName = ForgeRegistries.BLOCKS.getKey((Object)this).m_135815_();
        if (blockName.contains("tripple")) {
            return TRIPPE;
        }
        if (blockName.contains("double")) {
            return DOUBLE;
        }
        if (this == ModBlocks.SIGNAL_LIGHT.get() || this == ModBlocks.PEDESTRIAN_SIGNAL_LIGHT.get()) {
            return SINGLE;
        }
        if (state.m_61143_((Property)f_54117_) == Direction.NORTH || state.m_61143_((Property)f_54117_) == Direction.SOUTH) {
            return SIDE_NORTH_SOUTH;
        }
        return SIDE_EAST_WEST;
    }

    public void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, LIT, WATERLOGGED});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)context.m_8125_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(!context.m_43725_().m_276867_(context.m_8083_())));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, facing, facingState, level, currentPos, facingPos);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (!level.f_46443_) {
            boolean isLit = (Boolean)state.m_61143_((Property)LIT);
            boolean hasSignal = level.m_276867_(pos);
            if (isLit && hasSignal) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)), 2);
            } else if (!isLit && !hasSignal) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true)), 2);
            }
        }
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        boolean hasSignal = level.m_276867_(pos);
        if (((Boolean)state.m_61143_((Property)LIT)).booleanValue() && hasSignal) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)), 2);
        } else if (!((Boolean)state.m_61143_((Property)LIT)).booleanValue() && !hasSignal) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true)), 2);
        }
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter level, BlockPos pos, @Nullable Direction direction) {
        return true;
    }

    private static ToIntFunction<BlockState> litBlockEmission(int lightValue) {
        return block -> (Boolean)block.m_61143_((Property)BlockStateProperties.f_61443_) != false ? lightValue : 0;
    }
}

