/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.citycraft.blocks.container;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import xxrexraptorxx.citycraft.recipes.IPaintingRecipe;
import xxrexraptorxx.citycraft.registry.ModBlocks;
import xxrexraptorxx.citycraft.registry.ModMenuTypes;
import xxrexraptorxx.citycraft.registry.ModRecipeTypes;

public class PainterMenu
extends AbstractContainerMenu {
    public static final int INPUT_SLOT_1 = 0;
    public static final int INPUT_SLOT_2 = 1;
    public static final int RESULT_SLOT = 2;
    private static final int INV_SLOT_START = 3;
    private static final int INV_SLOT_END = 30;
    private static final int USE_ROW_SLOT_START = 30;
    private static final int USE_ROW_SLOT_END = 39;
    private final Level level;
    private List<IPaintingRecipe> recipes = Lists.newArrayList();
    private final List<IPaintingRecipe> allRecipes;
    private ItemStack input1 = ItemStack.f_41583_;
    private ItemStack input2 = ItemStack.f_41583_;
    long lastSoundTime;
    private final ContainerLevelAccess access;
    final Slot inputSlot1;
    final Slot inputSlot2;
    final Slot resultSlot;
    final ResultContainer resultContainer = new ResultContainer();
    Runnable slotUpdateListener = () -> {};
    private final DataSlot selectedRecipeIndex = DataSlot.m_39401_();
    private final List<Integer> inputSlotIndexes = List.of(Integer.valueOf(0), Integer.valueOf(1));
    private final Container container = new SimpleContainer(2){

        public void m_6596_() {
            super.m_6596_();
            PainterMenu.this.m_6199_((Container)this);
            PainterMenu.this.slotUpdateListener.run();
        }
    };

    public PainterMenu(int containerId, Inventory playerInventory) {
        this(containerId, playerInventory, ContainerLevelAccess.f_39287_);
    }

    public PainterMenu(int containerId, Inventory playerInventory, final ContainerLevelAccess access) {
        super(ModMenuTypes.PAINTER, containerId);
        this.level = playerInventory.f_35978_.m_9236_();
        this.access = access;
        this.allRecipes = this.level.m_7465_().m_44013_(ModRecipeTypes.PAINTING);
        this.inputSlot1 = this.m_38897_(new Slot(this.container, 0, 20, 20));
        this.inputSlot2 = this.m_38897_(new Slot(this.container, 1, 20, 48));
        this.resultSlot = this.m_38897_(new Slot((Container)this.resultContainer, 2, 143, 33){

            public boolean m_5857_(ItemStack stack) {
                return false;
            }

            public void m_142406_(Player player, ItemStack stack) {
                stack.m_41678_(player.m_9236_(), player, stack.m_41613_());
                PainterMenu.this.resultContainer.m_58395_(player, this.getRelevantItems());
                ItemStack inputStack1 = PainterMenu.this.inputSlot1.m_6201_(1);
                ItemStack inputStack2 = PainterMenu.this.inputSlot2.m_6201_(1);
                if (!inputStack1.m_41619_() || !inputStack2.m_41619_()) {
                    PainterMenu.this.setupResultSlot();
                }
                access.m_39292_((world, pos) -> {
                    long time = world.m_46467_();
                    if (PainterMenu.this.lastSoundTime != time) {
                        world.m_5594_(null, pos, SoundEvents.f_12494_, SoundSource.BLOCKS, 1.0f, 1.0f);
                        PainterMenu.this.lastSoundTime = time;
                    }
                });
                super.m_142406_(player, stack);
            }

            private List<ItemStack> getRelevantItems() {
                ArrayList items = Lists.newArrayList();
                items.add(PainterMenu.this.inputSlot1.m_7993_());
                items.add(PainterMenu.this.inputSlot2.m_7993_());
                return items;
            }
        });
        int startX = 8;
        int startY = 84;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInventory, j + i * 9 + 9, startX + j * 18, startY + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.m_38897_(new Slot((Container)playerInventory, k, startX + k * 18, 142));
        }
        this.m_38895_(this.selectedRecipeIndex);
    }

    public boolean m_6875_(Player player) {
        return PainterMenu.m_38889_((ContainerLevelAccess)this.access, (Player)player, (Block)((Block)ModBlocks.BLOCK_PAINTER.get()));
    }

    public boolean m_6366_(Player player, int id) {
        if (this.isValidRecipeIndex(id)) {
            this.selectedRecipeIndex.m_6422_(id);
            this.setupResultSlot();
        }
        return true;
    }

    public void m_6199_(Container inventory) {
        ItemStack stack1 = this.inputSlot1.m_7993_();
        ItemStack stack2 = this.inputSlot2.m_7993_();
        if (!stack1.m_150930_(this.input1.m_41720_()) || !stack2.m_150930_(this.input2.m_41720_())) {
            this.input1 = stack1.m_41777_();
            this.input2 = stack2.m_41777_();
            this.setupRecipeList(this.container, stack1, stack2);
        }
    }

    private void setupRecipeList(Container container, ItemStack stack1, ItemStack stack2) {
        this.recipes.clear();
        this.selectedRecipeIndex.m_6422_(-1);
        this.resultSlot.m_5852_(ItemStack.f_41583_);
        if (!stack1.m_41619_() && !stack2.m_41619_()) {
            this.recipes = this.level.m_7465_().m_44056_(ModRecipeTypes.PAINTING, container, this.level);
        }
    }

    private void setupResultSlot() {
        if (!this.recipes.isEmpty() && this.isValidRecipeIndex(this.selectedRecipeIndex.m_6501_())) {
            IPaintingRecipe recipe = this.recipes.get(this.selectedRecipeIndex.m_6501_());
            ItemStack resultStack = recipe.m_5874_(this.container, this.level.m_9598_());
            if (resultStack.m_246617_(this.level.m_246046_())) {
                this.resultContainer.m_6029_((Recipe)recipe);
                this.resultSlot.m_5852_(resultStack);
            } else {
                this.resultSlot.m_5852_(ItemStack.f_41583_);
            }
        } else {
            this.resultSlot.m_5852_(ItemStack.f_41583_);
        }
        this.m_38946_();
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.resultContainer.m_8016_(2);
        this.access.m_39292_((p_40313_, p_40314_) -> this.m_150411_(player, this.container));
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack stack = slot.m_7993_();
            itemstack = stack.m_41777_();
            if (index == 2) {
                if (!this.m_38903_(stack, 3, 39, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(stack, itemstack);
            } else if (index >= 3 && index < 39) {
                if (!this.canMoveIntoInputSlots(stack)) {
                    return ItemStack.f_41583_;
                }
                int slotIndex = this.getSlotToQuickMoveTo(stack);
                if (!this.m_38903_(stack, slotIndex, slotIndex + 1, false)) {
                    return ItemStack.f_41583_;
                }
            } else if (!this.m_38903_(stack, 3, 39, false)) {
                return ItemStack.f_41583_;
            }
            if (stack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (stack.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, stack);
            this.m_38946_();
        }
        return itemstack;
    }

    public int getSlotToQuickMoveTo(ItemStack stack) {
        return this.allRecipes.stream().map(recipeMap -> PainterMenu.findSlotMatchingIngredient(recipeMap, stack)).filter(Optional::isPresent).findFirst().orElse(Optional.of(1)).get();
    }

    private static Optional<Integer> findSlotMatchingIngredient(IPaintingRecipe recipe, ItemStack stack) {
        if (recipe.isBaseIngredient(stack)) {
            return Optional.of(0);
        }
        if (recipe.isColorIngredient(stack)) {
            return Optional.of(1);
        }
        return Optional.empty();
    }

    public boolean canMoveIntoInputSlots(ItemStack stack) {
        return this.level.m_7465_().m_44013_(ModRecipeTypes.PAINTING).stream().map(recipeMap -> PainterMenu.findSlotMatchingIngredient(recipeMap, stack)).anyMatch(Optional::isPresent);
    }

    public int getResultSlot() {
        return 2;
    }

    public void registerUpdateListener(Runnable runnable) {
        this.slotUpdateListener = runnable;
    }

    private boolean isValidRecipeIndex(int id) {
        return id >= 0 && id < this.recipes.size();
    }

    public int getSelectedRecipeIndex() {
        return this.selectedRecipeIndex.m_6501_();
    }

    public List<IPaintingRecipe> getRecipes() {
        return this.recipes;
    }

    public int getNumRecipes() {
        return this.recipes.size();
    }

    public boolean hasInputItem() {
        return this.inputSlot1.m_6657_() && this.inputSlot2.m_6657_() && !this.recipes.isEmpty();
    }
}

