/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.citycraft.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.stream.Stream;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeHooks;
import xxrexraptorxx.citycraft.main.CityCraft;
import xxrexraptorxx.citycraft.recipes.IPaintingRecipe;
import xxrexraptorxx.citycraft.registry.ModRecipeSerializers;

public class PaintingRecipe
implements IPaintingRecipe {
    private final ResourceLocation id;
    final Ingredient base;
    final Ingredient color;
    final ItemStack result;

    public PaintingRecipe(ResourceLocation id, Ingredient baseIngredient, Ingredient colorIngredient, ItemStack result) {
        this.id = id;
        this.base = baseIngredient;
        this.color = colorIngredient;
        this.result = result;
    }

    public boolean m_5818_(Container container, Level level) {
        return this.base.test(container.m_8020_(0)) && this.color.test(container.m_8020_(1));
    }

    public ItemStack m_5874_(Container container, RegistryAccess registryAccess) {
        ItemStack itemstack = this.result.m_41777_();
        CompoundTag compoundtag = container.m_8020_(0).m_41783_();
        if (compoundtag != null) {
            itemstack.m_41751_(compoundtag.m_6426_());
        }
        return itemstack;
    }

    @Override
    public Ingredient getIngredients(Integer slotId) {
        switch (slotId) {
            case 0: {
                return this.base;
            }
            case 1: {
                return this.color;
            }
        }
        CityCraft.LOGGER.error("Invalid Ingredient slot id: " + this.id);
        return null;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.result;
    }

    @Override
    public boolean isColorIngredient(ItemStack pStack) {
        return this.color.test(pStack);
    }

    @Override
    public boolean isBaseIngredient(ItemStack pStack) {
        return this.base.test(pStack);
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public boolean m_5598_() {
        return true;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeSerializers.PAINTING.get();
    }

    public boolean m_142505_() {
        return Stream.of(this.color, this.base).anyMatch(ForgeHooks::hasNoElements);
    }

    public static class Serializer
    implements RecipeSerializer<PaintingRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("citycraft:painting");

        public PaintingRecipe fromJson(ResourceLocation loc, JsonObject json) {
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)GsonHelper.m_289747_((JsonObject)json, (String)"base"));
            Ingredient color = Ingredient.m_43917_((JsonElement)GsonHelper.m_289747_((JsonObject)json, (String)"color"));
            ItemStack result = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            return new PaintingRecipe(loc, ingredient, color, result);
        }

        public PaintingRecipe fromNetwork(ResourceLocation loc, FriendlyByteBuf buf) {
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buf);
            Ingredient ingredient1 = Ingredient.m_43940_((FriendlyByteBuf)buf);
            ItemStack itemstack = buf.m_130267_();
            return new PaintingRecipe(loc, ingredient, ingredient1, itemstack);
        }

        public void toNetwork(FriendlyByteBuf buf, PaintingRecipe recipe) {
            recipe.base.m_43923_(buf);
            recipe.color.m_43923_(buf);
            buf.m_130055_(recipe.result);
        }
    }
}

