/*
 * Decompiled with CFR 0.152.
 */
package com.fureniku.metropolis;

import com.fureniku.metropolis.blockentity.MetroBlockEntity;
import com.fureniku.metropolis.menus.MetroMenu;
import com.fureniku.metropolis.utils.CreativeTabSet;
import com.fureniku.metropolis.utils.Debug;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public abstract class RegistrationBase {
    protected final DeferredRegister<Block> blockRegistry;
    protected final DeferredRegister<Item> itemRegistry;
    protected final DeferredRegister<CreativeModeTab> creativeTabs;
    protected final DeferredRegister<BlockEntityType<?>> blockEntityRegistry;
    protected final DeferredRegister<MenuType<?>> menuTypeRegistry;
    public final String modid;
    private HashMap<String, RegistryObject<Block>> block_map = new HashMap();
    private HashMap<String, RegistryObject<Item>> item_map = new HashMap();

    public RegistrationBase(String modid, IEventBus modEventBus) {
        this.modid = modid;
        this.blockRegistry = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)modid);
        this.itemRegistry = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)modid);
        this.creativeTabs = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)modid);
        this.blockEntityRegistry = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)modid);
        this.menuTypeRegistry = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MENU_TYPES, (String)modid);
        modEventBus.addListener(this::common);
        modEventBus.addListener(this::client);
        modEventBus.addListener(this::buildCreativeTabs);
        modEventBus.addListener(this::generate);
        this.blockRegistry.register(modEventBus);
        this.itemRegistry.register(modEventBus);
        this.creativeTabs.register(modEventBus);
        this.blockEntityRegistry.register(modEventBus);
        this.menuTypeRegistry.register(modEventBus);
    }

    public abstract void init(IEventBus var1);

    @Nullable
    public final RegistryObject<Block> getBlock(String key) {
        if (this.block_map.containsKey(key)) {
            return this.block_map.get(key);
        }
        Debug.LogError("Key [" + key + "] not found in block_map. Dump map info below.", new Object[0]);
        Debug.Log(this.block_map.toString(), new Object[0]);
        return null;
    }

    @Nullable
    public final RegistryObject<Item> getItem(String key) {
        if (this.item_map.containsKey(key)) {
            return this.item_map.get(key);
        }
        Debug.LogError("Key [" + key + "] not found in item_map. Dump map info below.", new Object[0]);
        Debug.Log(this.item_map.toString(), new Object[0]);
        return null;
    }

    public final HashMap<String, RegistryObject<Block>> getBlockArray() {
        return this.block_map;
    }

    public String registerBlockSet(String name, Supplier<Block> blockClass) {
        this.retrieveRegisterBlockSet(name, blockClass);
        return name;
    }

    public RegistryObject<Block> retrieveRegisterBlockSet(String name, Supplier<Block> blockClass) {
        RegistryObject block = this.blockRegistry.register(name, blockClass);
        RegistryObject blockItem = this.itemRegistry.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
        this.addBlock(name, (RegistryObject<Block>)block);
        this.addItem(name, (RegistryObject<Item>)blockItem);
        return block;
    }

    public <T extends MetroBlockEntity> RegistryObject<BlockEntityType<T>> registerBlockEntity(String name, BlockEntityType.BlockEntitySupplier<T> blockEntity, Block ... validBlocks) {
        return this.blockEntityRegistry.register(name, () -> BlockEntityType.Builder.m_155273_((BlockEntityType.BlockEntitySupplier)blockEntity, (Block[])validBlocks).m_58966_(null));
    }

    public <T extends MetroBlockEntity> RegistryObject<BlockEntityType<T>> registerBlockEntityWithBlock(String name, Supplier<Block> blockClass, BlockEntityType.BlockEntitySupplier<T> blockEntity) {
        RegistryObject block = this.blockRegistry.register(name, blockClass);
        RegistryObject blockItem = this.itemRegistry.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
        this.addBlock(name, (RegistryObject<Block>)block);
        this.addItem(name, (RegistryObject<Item>)blockItem);
        return this.blockEntityRegistry.register(name + "_entity", () -> BlockEntityType.Builder.m_155273_((BlockEntityType.BlockEntitySupplier)blockEntity, (Block[])new Block[]{(Block)block.get()}).m_58966_(null));
    }

    public <T extends MetroMenu> RegistryObject<MenuType<T>> registerMenuType(String name, Supplier<MenuType<T>> menu) {
        return this.menuTypeRegistry.register(name, menu);
    }

    public abstract void generateCreativeTabs();

    protected abstract ArrayList<CreativeTabSet> getCreativeTabs();

    @SubscribeEvent
    public void buildCreativeTabs(BuildCreativeModeTabContentsEvent event) {
        for (int i = 0; i < this.getCreativeTabs().size(); ++i) {
            CreativeTabSet tab = this.getCreativeTabs().get(i);
            if (event.getTabKey() != tab.getTab().getKey()) continue;
            for (int j = 0; j < tab.getItems().size(); ++j) {
                event.m_246342_(tab.getItems().get(j));
            }
        }
    }

    protected abstract void commonSetup(FMLCommonSetupEvent var1);

    protected abstract void clientSetup(FMLClientSetupEvent var1);

    protected abstract void dataGen(GatherDataEvent var1, DataGenerator var2, PackOutput var3, ExistingFileHelper var4);

    public DeferredRegister<Block> getBlockDeferredRegister() {
        return this.blockRegistry;
    }

    public DeferredRegister<Item> getItemDeferredRegister() {
        return this.itemRegistry;
    }

    public DeferredRegister<BlockEntityType<?>> getBlockEntityRegistry() {
        return this.blockEntityRegistry;
    }

    public DeferredRegister<CreativeModeTab> getCreativeTabDeferredRegister() {
        return this.creativeTabs;
    }

    private void generate(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper efh = event.getExistingFileHelper();
        this.dataGen(event, generator, packOutput, efh);
    }

    @SubscribeEvent
    protected void common(FMLCommonSetupEvent event) {
        this.generateCreativeTabs();
        this.commonSetup(event);
    }

    @SubscribeEvent
    protected void client(FMLClientSetupEvent event) {
        this.clientSetup(event);
    }

    private void addBlock(String key, RegistryObject<Block> value) {
        this.block_map.put(key, value);
    }

    private void addItem(String key, RegistryObject<Item> value) {
        this.item_map.put(key, value);
    }
}

