/*
 * Decompiled with CFR 0.152.
 */
package com.fureniku.metropolis;

import com.fureniku.metropolis.RegistrationBase;
import com.fureniku.metropolis.datagen.TextureSet;
import com.fureniku.metropolis.utils.CreativeTabSet;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.RegistryObject;

public abstract class RegistrationGroup {
    protected final RegistrationBase registration;

    public RegistrationGroup(RegistrationBase registrationBase) {
        this.registration = registrationBase;
    }

    public abstract void init(IEventBus var1);

    public abstract void generateCreativeTabs();

    public abstract ArrayList<CreativeTabSet> getCreativeTabs();

    protected String registerBlockSet(String name, Supplier<Block> blockClass) {
        this.registration.registerBlockSet(name, blockClass);
        return name;
    }

    protected RegistryObject<Block> getBlock(String key) {
        return this.registration.getBlock(key);
    }

    protected RegistryObject<Item> getItem(String key) {
        return this.registration.getItem(key);
    }

    protected ResourceLocation getLoc(String name) {
        return this.getLocFull(name);
    }

    protected final ResourceLocation getLocFull(String name) {
        return new ResourceLocation(this.registration.modid, name);
    }

    protected TextureSet texture(String name, String loc) {
        return this.texture(name, this.getLoc(loc));
    }

    protected TextureSet texture(String name, ResourceLocation loc) {
        return new TextureSet(name, loc);
    }
}

