/*
 * Decompiled with CFR 0.152.
 */
package com.fureniku.metropolis.blocks;

import com.fureniku.metropolis.RegistrationBase;
import com.fureniku.metropolis.utils.CreativeTabSet;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.RegistryObject;

public abstract class BlockSet {
    protected int _blockCount;
    protected RegistryObject<Block>[] _blocks;
    protected RegistryObject<Item>[] _itemBlocks;
    protected String _name;
    protected ResourceLocation _resourceLocation;
    protected BiFunction<BlockAndTintGetter, BlockPos, Integer> tintColorBlock;
    protected Supplier<Integer> tintColorItem;

    public BlockSet(String name, int count, RegistrationBase register) {
        this(name, null, count, register);
    }

    public BlockSet(String name, ResourceLocation texture, int count, RegistrationBase register) {
        this._name = name;
        this._resourceLocation = texture;
        this._blockCount = count;
        this._blocks = new RegistryObject[this._blockCount];
        this._itemBlocks = new RegistryObject[this._blockCount];
        this.init(register);
    }

    private void init(RegistrationBase register) {
        for (int i = 0; i < this._blockCount; ++i) {
            int id = i + 1;
            this._blocks[i] = register.retrieveRegisterBlockSet(this._name + "_" + id, this.getClassSupplier(id));
            this._itemBlocks[i] = register.getItem(this._name + "_" + id);
        }
    }

    public BlockSet addColorTints(IEventBus modEventBus, BiFunction<BlockAndTintGetter, BlockPos, Integer> blockColor, Supplier<Integer> itemColor) {
        if (FMLEnvironment.dist.isClient()) {
            modEventBus.addListener(this::registerBlockColors);
            modEventBus.addListener(this::registerItemColors);
            this.tintColorBlock = blockColor;
            this.tintColorItem = itemColor;
        }
        return this;
    }

    protected abstract Supplier<Block> getClassSupplier(int var1);

    public Block getFromId(int id) {
        return (Block)this._blocks[id - 1].get();
    }

    public String getSetName() {
        return this._name;
    }

    public void registerToCreativeTab(CreativeTabSet tab) {
        for (int i = 0; i < this._blockCount; ++i) {
            tab.addItem(((Block)this._blocks[i].get()).m_5456_().m_7968_());
        }
    }

    public RegistryObject<Block> getRegistryBlock(int id) {
        return this._blocks[id - 1];
    }

    public RegistryObject<Item> getRegistryItem(int id) {
        return this._itemBlocks[id - 1];
    }

    public RegistryObject<Block>[] getRegistryBlocks() {
        return this._blocks;
    }

    public RegistryObject<Item>[] getRegistryItems() {
        return this._itemBlocks;
    }

    @SubscribeEvent
    public void registerBlockColors(RegisterColorHandlersEvent.Block event) {
        event.register((state, tint, pos, tintIndex) -> this.tintColorBlock.apply(tint, pos), (Block[])Stream.of(this.getRegistryBlocks()).map(RegistryObject::get).toArray(Block[]::new));
    }

    @SubscribeEvent
    public void registerItemColors(RegisterColorHandlersEvent.Item event) {
        event.register((stack, tintIndex) -> this.tintColorItem.get(), (ItemLike[])Stream.of(this.getRegistryItems()).map(RegistryObject::get).toArray(Item[]::new));
    }
}

