/*
 * Decompiled with CFR 0.152.
 */
package com.fureniku.metropolis.blocks;

import com.fureniku.metropolis.blocks.decorative.helpers.HelperBase;
import com.fureniku.metropolis.datagen.MetroBlockStateProvider;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.RegistryObject;

public abstract class MetroBlockBase
extends Block {
    protected ArrayList<HelperBase> _helpers;
    private String _tag = "untagged";

    public MetroBlockBase(BlockBehaviour.Properties props) {
        super(props);
    }

    protected BlockState getPlacementState(BlockPlaceContext context) {
        return this.m_49966_();
    }

    protected void createBlockState(StateDefinition.Builder<Block, BlockState> builder) {
    }

    protected VoxelShape getShapeFromBlockState(BlockState blockState) {
        return Shapes.m_83144_();
    }

    protected Vec3 getOffset(BlockState blockState, BlockGetter level, BlockPos pos) {
        return Vec3.f_82478_;
    }

    public boolean hasHelper(Class<? extends HelperBase> helperClass) {
        for (int i = 0; i < this._helpers.size(); ++i) {
            if (this._helpers.get(i).getClass() != helperClass) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public HelperBase getHelper(Class<? extends HelperBase> helperClass) {
        for (int i = 0; i < this._helpers.size(); ++i) {
            if (this._helpers.get(i).getClass() != helperClass) continue;
            return this._helpers.get(i);
        }
        return null;
    }

    protected void setTag(String tag) {
        this._tag = tag;
    }

    public String getTag() {
        return this._tag;
    }

    public float m_142740_() {
        return 0.25f;
    }

    public float m_142627_() {
        return 0.2f;
    }

    protected InteractionResult onRightClick(BlockState state, Level level, BlockPos pos, Player player) {
        return InteractionResult.PASS;
    }

    protected void onNeighbourChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos neighborPos) {
    }

    public void setBlock(Level level, BlockPos pos, BlockState state) {
        level.m_46597_(pos, state);
    }

    protected InteractionResult onUse(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        return InteractionResult.PASS;
    }

    public void generateBlockState(RegistryObject<Block> blockRegistryObject, MetroBlockStateProvider blockStateProvider) {
        blockStateProvider.simpleBlockWithItem((Block)blockRegistryObject.get());
    }

    public MenuProvider getMenu(BlockState state, Level level, BlockPos pos) {
        return null;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext pContext) {
        Vec3 offset = this.getOffset(state, level, pos);
        if (offset != Vec3.f_82478_) {
            return this.getShapeFromBlockState(state).m_83216_(offset.f_82479_, offset.f_82480_, offset.f_82481_);
        }
        return this.getShapeFromBlockState(state);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return this.getPlacementState(context);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (hand == InteractionHand.MAIN_HAND) {
            return this.onRightClick(state, level, pos, player);
        }
        return this.onUse(state, level, pos, player, hand, result);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        this.createBlockState(builder);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos neighborPos, boolean p_55671_) {
        this.onNeighbourChanged(state, level, pos, state.m_60734_(), neighborPos);
    }

    public MenuProvider m_7246_(BlockState state, Level level, BlockPos pos) {
        return this.getMenu(state, level, pos);
    }
}

